/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.harctoolbox.cmdline.CmdLineProgram;
import org.harctoolbox.cmdline.ProgramExitStatus;
import org.harctoolbox.cmdline.UsageException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.ThisCannotHappenException;

public class CmdUtils {
    public static void checkForOption(String functionName, List<String> args) throws UsageException {
        if (args != null && !args.isEmpty() && args.get(0).startsWith("-")) {
            throw new UsageException("Unknown option to " + functionName + ": " + args.get(0));
        }
    }

    public static String[] shellSplit(String string) {
        return string.split("\\s+");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String execute(Class<? extends CmdLineProgram> clazz, String[] args) {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        try (PrintStream outStream = new PrintStream((OutputStream)outBytes, false, "UTF-8");){
            Constructor<? extends CmdLineProgram> constructor = clazz.getConstructor(PrintStream.class);
            CmdLineProgram instance = constructor.newInstance(outStream);
            ProgramExitStatus status = instance.run(args);
            if (!status.isSuccess()) {
                String string = null;
                return string;
            }
            outStream.flush();
            String string = new String(outBytes.toByteArray(), IrCoreUtils.UTF8).trim();
            return string;
        }
        catch (UnsupportedEncodingException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    public static ByteArrayOutputStream storeStdErr() {
        ByteArrayOutputStream errBytes = new ByteArrayOutputStream();
        try {
            PrintStream errStream = new PrintStream((OutputStream)errBytes, false, "UTF-8");
            System.setErr(errStream);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ThisCannotHappenException();
        }
        return errBytes;
    }

    public static String restoreStdErr(ByteArrayOutputStream errBytes) {
        System.err.flush();
        System.err.close();
        try {
            String stderr = errBytes.toString("UTF-8");
            System.setErr(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.err), true, "UTF-8"));
            return stderr;
        }
        catch (UnsupportedEncodingException ex) {
            throw new ThisCannotHappenException();
        }
    }

    private CmdUtils() {
    }
}

