/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.harctoolbox.analyze.AbstractDecoder;
import org.harctoolbox.analyze.Analyzer;
import org.harctoolbox.analyze.Burst;
import org.harctoolbox.analyze.NoDecoderMatchException;
import org.harctoolbox.cmdline.AbstractCommand;
import org.harctoolbox.cmdline.CmdLineProgram;
import org.harctoolbox.cmdline.CmdUtils;
import org.harctoolbox.cmdline.CommandCommonOptions;
import org.harctoolbox.cmdline.FrequencyParser;
import org.harctoolbox.cmdline.Radix;
import org.harctoolbox.cmdline.UsageException;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.MultiParser;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ThingsLineParser;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BitCounter;
import org.harctoolbox.irp.BitDirection;
import org.harctoolbox.irp.DomainViolationException;
import org.harctoolbox.irp.DuplicateFinder;
import org.harctoolbox.irp.FiniteBitField;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpException;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.Name;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.Number;
import org.harctoolbox.irp.Protocol;
import org.harctoolbox.irp.ProtocolListDomFactory;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Parameters(commandNames={"analyze"}, commandDescription="Analyze signal: tries to find an IRP form with parameters.")
public class CommandAnalyze
extends AbstractCommand {
    public static final String RAWGIRR2NAMEINPUT = "/rawgirr2named.xsl";
    private static final Logger logger = Logger.getLogger(CommandAnalyze.class.getName());
    @Parameter(names={"-a", "--all"}, description="List all decoder outcomes, instead of only the one with lowest weight.")
    private boolean allDecodes = false;
    @Parameter(names={"-b", "--bit-usage"}, description="Create bit usage report. (Not with --all.)")
    private boolean bitUsage = false;
    @Parameter(names={"-c", "--chop"}, description="Chop input sequence into several using threshold (in milliseconds) given as argument.")
    private Integer chop = null;
    @Parameter(names={"-C", "--clean"}, description="Output the cleaned sequence(s).")
    private boolean clean = false;
    @Parameter(names={"-d", "--decoder"}, description="Use only the decoders matching argument (regular expression, or prefix). Use the argument \"list\" to list the available decoders.")
    private String decoder = null;
    @Parameter(names={"-e", "--extent"}, description="Output the last gap as an extent.")
    private boolean extent = false;
    @Parameter(names={"--eliminate-vars"}, description="Eliminate variables in output form.")
    private boolean eliminateVars = false;
    @Parameter(names={"--fatgirr"}, description="Generate Girr file in fat format. Inhibits all other output.")
    private boolean fatgirr = false;
    @Parameter(names={"-f", "--frequency"}, converter=FrequencyParser.class, description="Modulation frequency of raw signal.")
    private Double frequency = null;
    @Parameter(names={"-g", "--girroutput"}, description="Generate Girr file. Inhibits all other output.")
    private boolean girr = false;
    @Parameter(names={"-G", "--girrinput"}, description="Read raw input in Girr format.")
    private String girrInput = null;
    @Parameter(names={"-i", "--input"}, description="File/URL from which to take inputs, one sequence per line.")
    private String input = null;
    @Parameter(names={"-I", "--invert"}, description="Invert the order in bitspec.")
    private boolean invert = false;
    @Parameter(names={"--ire", "--intro-repeat-ending"}, description="Consider the argument as begin, repeat, and ending sequence.")
    private boolean introRepeatEnding = false;
    @Parameter(names={"-l", "--lsb"}, description="Force lsb-first bitorder for the parameters.")
    private boolean lsb = false;
    @Parameter(names={"-m", "--maxunits"}, description="Maximal multiplier of time unit in durations.")
    private double maxUnits = 30.0;
    @Parameter(names={"-n", "--namedinput"}, description="File/URL from which to take inputs, one line name, data one line.")
    private String namedInput = null;
    @Parameter(names={"-p", "--parametertable"}, description="Create parameter table.")
    private boolean parameterTable = false;
    @Parameter(names={"-P", "--parameterspecs"}, description="Compute a dumb parameter specs in the IRP.")
    private boolean parameterSpecs = false;
    @Parameter(names={"-u", "--maxmicroseconds"}, description="Maximal duration to be expressed as micro seconds.")
    private double maxMicroSeconds = 10000.0;
    @Parameter(names={"--maxroundingerror"}, description="Maximal rounding errors for expressing as multiple of time unit.")
    private double maxRoundingError = 0.3;
    @Parameter(names={"-M", "--maxparameterwidth"}, description="Maximal parameter width.")
    private int maxParameterWidth = 63;
    @Parameter(names={"-w", "--parameterwidths"}, description="Comma separated list of either parameter widths or name:width pairs.")
    private List<String> parameterNamedWidths = new ArrayList<String>(4);
    @Parameter(names={"-r", "--repeatfinder"}, description="Invoke the repeatfinder.")
    private boolean repeatFinder = false;
    @Parameter(names={"-R", "--dump-repeatfinder"}, description="Print the result of the repeatfinder.")
    private boolean dumpRepeatfinder = false;
    @Parameter(names={"--radix"}, description="Radix used for printing of output parameters.", validateWith={Radix.class})
    private int radix = 16;
    @Parameter(names={"-s", "--statistics"}, description="Print some statistics.")
    private boolean statistics = false;
    @Parameter(names={"-t", "--timebase"}, description="Force time unit , in microseconds (no suffix), or in periods (with suffix \"p\").")
    private String timeBase = null;
    @Parameter(names={"--timings"}, description="Print the total timings of the compute IRP form.")
    private boolean timings = false;
    @Parameter(names={"-T", "--trailinggap"}, description="Dummy trailing gap (in micro seconds) added to sequences of odd length.")
    private Double trailingGap = null;
    @Parameter(names={"--validate"}, description="Validate that the resulted protocol can be used for rendering and produces the same signal.")
    private boolean validate = false;
    @Parameter(names={"--xslt"}, description="File/URL name of XSLT transformation that will be applied to --input or --namedinput argument")
    private String xslt = null;
    @Parameter(description="durations in microseconds, or pronto hex.", required=false)
    private List<String> args = null;

    @Override
    public String description() {
        return "The \"analyze\" command takes as input one or several sequences or signals, and computes an IRP form that corresponds to the given input (within the specified tolerances). The input can be given either as Pronto Hex or in raw form, optionally with signs (ignored). Several raw format input sequences can be given by enclosing the individual sequences in brackets (\"[]\"). However, if using the --intro-repeat-ending option, the sequences are instead interpreted as intro-, repeat-, and (optionally) ending sequences of an IR signal. \n\nFor raw sequences, an explicit modulation frequency can be given with the --frequency option. Otherwise the default frequency, 38000Hz, will be assumed. \n\nUsing the option --input, instead the content of a file can be taken as input, containing sequences to be analyzed, one per line, blank lines ignored. Using the option --namedinput, the sequences may have names, immediately preceeding the signal. \n\nInput sequences can be pre-processed using the options --chop, --clean, and --repeatfinder. \n\nThe input sequence(s) are matched using different \"decoders\". Normally the \"best\" decoder match is output. With the --all option, all decoder matches are output. Using the --decode option, the used decoders can be further limited. The presently available decoders are: " + String.join((CharSequence)", ", AbstractDecoder.decoderNames()) + ".\n\nThe options --statistics and --dump-repeatfinder (the latter forces the repeatfinder to be on) can be used to print extra information. The common options --absolutetolerance, --relativetolerance, --minrepeatgap determine how the repeat finder breaks the input data. The options --extent, --invert, --lsb, --maxmicroseconds, --maxparameterwidth, --maxroundingerror, --maxunits, --parameterwidths, --radix, and --timebase determine how the computed IRP is displayed.";
    }

    @Override
    public boolean process(CmdLineProgram instance) {
        boolean result = super.process(instance);
        if (result) {
            return true;
        }
        if (this.decoder != null && (this.decoder.equals("list") || this.decoder.equals("help") || this.decoder.equals("?"))) {
            IrCoreUtils.trivialFormatter(instance.getOutputStream(), "Available decoders: " + String.join((CharSequence)", ", AbstractDecoder.decoderNames()), 65);
            return true;
        }
        return false;
    }

    private Double possiblyOverrideWithAnalyzeFrequency(Double frequency) {
        return this.frequency != null ? this.frequency : frequency;
    }

    public void analyze(PrintStream out, CommandCommonOptions commandLineArgs) throws IrpException, IrCoreException, NoDecoderMatchException, UsageException, IOException, SAXException, UnsupportedEncodingException, TransformerException {
        AnalyzeClass analyzeClass = new AnalyzeClass(out, commandLineArgs);
        analyzeClass.analyze();
    }

    private class AnalyzeClass {
        private final PrintStream out;
        private final CommandCommonOptions commandLineArgs;

        AnalyzeClass(PrintStream out, CommandCommonOptions commandLineArgs) {
            this.out = out;
            this.commandLineArgs = commandLineArgs;
        }

        private void analyze() throws IrpException, IrCoreException, NoDecoderMatchException, UsageException, IOException, SAXException, UnsupportedEncodingException, TransformerException {
            CmdUtils.checkForOption("analyze", CommandAnalyze.this.args);
            if (CommandAnalyze.this.allDecodes && CommandAnalyze.this.decoder != null) {
                throw new UsageException("Cannot use both --alldecodes and --decode.");
            }
            if (CommandAnalyze.this.allDecodes && CommandAnalyze.this.girr) {
                throw new UsageException("Cannot use both --alldecodes and --girr.");
            }
            if (CommandAnalyze.this.bitUsage && (CommandAnalyze.this.allDecodes || CommandAnalyze.this.eliminateVars)) {
                throw new UsageException("Bit usage report not possible together with --all or --eliminate-vars");
            }
            if (CommandAnalyze.this.parameterTable && CommandAnalyze.this.eliminateVars) {
                throw new UsageException("Parameter table is meaninless together with --eliminate-vars");
            }
            if (IrCoreUtils.numberTrue(CommandAnalyze.this.input != null, CommandAnalyze.this.namedInput != null, CommandAnalyze.this.girrInput != null, CommandAnalyze.this.args != null) != 1) {
                throw new UsageException("Must use exactly one of --input, --namedinput, --girrinput and non-empty arguments");
            }
            if (CommandAnalyze.this.maxParameterWidth > 63) {
                logger.log(Level.WARNING, "The given value of --maxparameterwidth ({0}) is larger than {1}. This is using unspecified behavior, and the correct execution is not guaranteed.", new Object[]{CommandAnalyze.this.maxParameterWidth, 63});
                FiniteBitField.setAllowLargeBitfields(true);
            }
            if (CommandAnalyze.this.input != null) {
                if (CommandAnalyze.this.validate) {
                    throw new UsageException("Cannot use --validate with --input.");
                }
                ThingsLineParser irSignalParser = new ThingsLineParser(line -> MultiParser.newIrCoreParser(line).toModulatedIrSequence(CommandAnalyze.this.frequency, CommandAnalyze.this.trailingGap), this.commandLineArgs.commentStart);
                List<ModulatedIrSequence> modSeqs = CommandAnalyze.this.xslt == null ? irSignalParser.readThings(CommandAnalyze.this.input, this.commandLineArgs.inputEncoding, false) : irSignalParser.readThings(CommandAnalyze.this.input, CommandAnalyze.this.xslt, this.commandLineArgs.inputEncoding, false);
                this.analyze(modSeqs, ModulatedIrSequence.frequencyAverage(modSeqs));
            } else if (CommandAnalyze.this.namedInput != null) {
                Map<String, ModulatedIrSequence> signals;
                if (CommandAnalyze.this.validate) {
                    throw new UsageException("Cannot use --validate with --namedinput.");
                }
                ThingsLineParser thingsLineParser = new ThingsLineParser(line -> MultiParser.newIrCoreParser(line).toModulatedIrSequence(CommandAnalyze.this.frequency, CommandAnalyze.this.trailingGap), this.commandLineArgs.commentStart);
                Map<String, ModulatedIrSequence> map = signals = CommandAnalyze.this.xslt == null ? thingsLineParser.readNamedThings(CommandAnalyze.this.namedInput, this.commandLineArgs.inputEncoding) : thingsLineParser.readNamedThings(CommandAnalyze.this.namedInput, CommandAnalyze.this.xslt, this.commandLineArgs.inputEncoding);
                if (signals.isEmpty()) {
                    throw new InvalidArgumentException("No parseable sequences found.");
                }
                this.analyze(signals);
            } else if (CommandAnalyze.this.girrInput != null) {
                if (CommandAnalyze.this.validate) {
                    throw new UsageException("Cannot use --validate with --girrinput.");
                }
                ThingsLineParser thingsLineParser = new ThingsLineParser(line -> MultiParser.newIrCoreParser(line).toModulatedIrSequence(CommandAnalyze.this.frequency, CommandAnalyze.this.trailingGap), this.commandLineArgs.commentStart);
                InputStream xsltStream = CommandAnalyze.class.getResourceAsStream(CommandAnalyze.RAWGIRR2NAMEINPUT);
                Document xsltDoc = XmlUtils.openXmlStream(xsltStream, null, true, true);
                Map<String, ModulatedIrSequence> signals = thingsLineParser.readNamedThings(CommandAnalyze.this.girrInput, xsltDoc, this.commandLineArgs.inputEncoding);
                if (signals.isEmpty()) {
                    throw new InvalidArgumentException("No parseable sequences found.");
                }
                this.analyze(signals);
            } else {
                MultiParser parser = MultiParser.newIrCoreParser(CommandAnalyze.this.args);
                if (CommandAnalyze.this.introRepeatEnding) {
                    IrSignal irSignal = CommandAnalyze.this.chop != null ? parser.toIrSignalChop(CommandAnalyze.this.frequency, CommandAnalyze.this.chop.intValue()) : parser.toIrSignal(CommandAnalyze.this.frequency, CommandAnalyze.this.trailingGap);
                    this.analyze(irSignal);
                } else if (CommandAnalyze.this.chop != null) {
                    List<IrSequence> list = parser.toListChop(CommandAnalyze.this.chop.intValue(), CommandAnalyze.this.trailingGap);
                    this.analyze(list);
                } else {
                    List<IrSequence> list = parser.toList(CommandAnalyze.this.trailingGap);
                    if (list.size() > 1) {
                        this.analyze(list);
                    } else {
                        IrSignal irSignal = parser.toIrSignal(CommandAnalyze.this.frequency, CommandAnalyze.this.trailingGap);
                        if (irSignal != null) {
                            this.analyze(irSignal);
                        } else {
                            throw new UsageException("Invalid signal, neither valid as Pronto nor as raw.");
                        }
                    }
                }
            }
        }

        private void analyze(IrSignal irSignal) throws IrpException, IrCoreException, NoDecoderMatchException, UsageException, UnsupportedEncodingException {
            Analyzer analyzer;
            Double freq = CommandAnalyze.this.possiblyOverrideWithAnalyzeFrequency(irSignal.getFrequency());
            if (CommandAnalyze.this.repeatFinder || CommandAnalyze.this.dumpRepeatfinder) {
                ModulatedIrSequence irSequence = irSignal.toModulatedIrSequence();
                analyzer = new Analyzer(irSequence, freq, true, this.commandLineArgs.absoluteTolerance, this.commandLineArgs.relativeTolerance);
            } else {
                IrSignal fixedSignal = CommandAnalyze.this.frequency != null ? new IrSignal(irSignal, CommandAnalyze.this.frequency) : irSignal;
                analyzer = new Analyzer(fixedSignal, this.commandLineArgs.absoluteTolerance, this.commandLineArgs.relativeTolerance);
            }
            this.analyze(analyzer, new ArrayList<String>(0), irSignal);
        }

        private void analyze(Map<String, ModulatedIrSequence> modulatedIrSequences) throws IrpException, IrCoreException, NoDecoderMatchException, UsageException, UnsupportedEncodingException {
            LinkedHashMap<String, IrSequence> irSequences = new LinkedHashMap<String, IrSequence>(modulatedIrSequences.size());
            irSequences.putAll(modulatedIrSequences);
            Double frequency = CommandAnalyze.this.possiblyOverrideWithAnalyzeFrequency(ModulatedIrSequence.frequencyAverage(modulatedIrSequences.values()));
            this.analyze(irSequences, frequency);
        }

        private void analyze(Map<String, IrSequence> irSequences, Double frequency) throws IrpException, IrCoreException, NoDecoderMatchException, UsageException, UnsupportedEncodingException {
            if (irSequences.isEmpty()) {
                throw new InvalidArgumentException("No parseable sequences found.");
            }
            Analyzer analyzer = new Analyzer(irSequences.values(), CommandAnalyze.this.possiblyOverrideWithAnalyzeFrequency(frequency), CommandAnalyze.this.repeatFinder || CommandAnalyze.this.dumpRepeatfinder, this.commandLineArgs.absoluteTolerance, this.commandLineArgs.relativeTolerance);
            this.analyze(analyzer, new ArrayList<String>(irSequences.keySet()), null);
        }

        private void analyze(List<? extends IrSequence> irSequences) throws IrpException, IrCoreException, NoDecoderMatchException, UsageException, UnsupportedEncodingException {
            this.analyze(irSequences, CommandAnalyze.this.frequency);
        }

        private void analyze(List<? extends IrSequence> irSequences, Double frequency) throws IrpException, IrCoreException, NoDecoderMatchException, UsageException, UnsupportedEncodingException {
            if (irSequences.isEmpty()) {
                throw new InvalidArgumentException("No parseable sequences found.");
            }
            Analyzer analyzer = new Analyzer(irSequences, CommandAnalyze.this.possiblyOverrideWithAnalyzeFrequency(frequency), CommandAnalyze.this.repeatFinder || CommandAnalyze.this.dumpRepeatfinder, this.commandLineArgs.absoluteTolerance, this.commandLineArgs.relativeTolerance);
            this.analyze(analyzer, new ArrayList<String>(0), null);
        }

        private void analyze(Analyzer analyzer, List<String> names, IrSignal inputSignal) throws IrpException, UsageException, IrCoreException, NoDecoderMatchException, UnsupportedEncodingException {
            block30: {
                int i;
                List<Protocol> protocols;
                Analyzer.AnalyzerParams params;
                ArrayList<String> parameterNames;
                ArrayList<Integer> parameterWidths;
                block31: {
                    block29: {
                        parameterWidths = new ArrayList<Integer>(CommandAnalyze.this.parameterNamedWidths.size());
                        parameterNames = new ArrayList<String>(CommandAnalyze.this.parameterNamedWidths.size());
                        if (!CommandAnalyze.this.parameterNamedWidths.isEmpty() && ((String)CommandAnalyze.this.parameterNamedWidths.get(0)).contains(":")) {
                            for (String param2 : CommandAnalyze.this.parameterNamedWidths) {
                                String[] arr = param2.split(":");
                                if (arr.length != 2) {
                                    throw new UsageException("Must use name:width form for all or none of parameterWidth values.");
                                }
                                String name = arr[0];
                                if (!Name.validName(name)) {
                                    throw new InvalidNameException(name);
                                }
                                parameterNames.add(name);
                                int width2 = Integer.parseInt(arr[1]);
                                parameterWidths.add(width2);
                            }
                        } else {
                            CommandAnalyze.this.parameterNamedWidths.stream().map(param -> Integer.valueOf(param)).forEachOrdered(width -> parameterWidths.add((Integer)width));
                        }
                        Burst.Preferences burstPrefs = new Burst.Preferences(CommandAnalyze.this.maxRoundingError, CommandAnalyze.this.maxUnits, CommandAnalyze.this.maxMicroSeconds);
                        params = new Analyzer.AnalyzerParams(analyzer.getFrequency(), CommandAnalyze.this.timeBase, CommandAnalyze.this.lsb ? BitDirection.lsb : BitDirection.msb, CommandAnalyze.this.extent, parameterWidths, CommandAnalyze.this.maxParameterWidth, CommandAnalyze.this.invert, burstPrefs, parameterNames);
                        if (CommandAnalyze.this.statistics) {
                            analyzer.printStatistics(this.out, params);
                            this.out.println();
                        }
                        if (CommandAnalyze.this.clean) {
                            for (int i2 = 0; i2 < analyzer.getNoSequences(); ++i2) {
                                if (analyzer.getNoSequences() > 1) {
                                    this.out.print("#" + i2 + ":\t");
                                }
                                this.out.println(analyzer.cleanedIrSequence(i2).toString(true));
                                if (!CommandAnalyze.this.statistics) continue;
                                this.out.println(analyzer.toTimingsString(i2));
                            }
                        }
                        if (CommandAnalyze.this.dumpRepeatfinder) {
                            for (int i3 = 0; i3 < analyzer.getNoSequences(); ++i3) {
                                if (analyzer.getNoSequences() > 1) {
                                    this.out.print("#" + i3 + ":\t");
                                }
                                this.out.println(analyzer.repeatReducedIrSignal(i3).toString(true));
                                this.out.println("RepeatFinderData: " + analyzer.repeatFinderData(i3).toString());
                            }
                        }
                        if (!CommandAnalyze.this.allDecodes) break block29;
                        List<List<Protocol>> protocols2 = analyzer.searchAllProtocols(params, CommandAnalyze.this.decoder, this.commandLineArgs.regexp);
                        int noSignal = 0;
                        for (List<Protocol> protocolList : protocols2) {
                            if (protocols2.size() > 1) {
                                this.out.print((names.isEmpty() ? "#" + noSignal : names.get(noSignal)) + ":\t");
                            }
                            if (CommandAnalyze.this.statistics) {
                                this.out.println(analyzer.toTimingsString(noSignal));
                            }
                            for (Protocol protocol2 : protocolList) {
                                if (CommandAnalyze.this.parameterSpecs) {
                                    protocol2.createParameterSpecsIfPossible();
                                }
                                this.printAnalyzedProtocol(protocol2, CommandAnalyze.this.radix, params.isPreferPeriods(), true, true);
                                if (!CommandAnalyze.this.validate) continue;
                                if (inputSignal != null) {
                                    this.validate(protocol2, inputSignal);
                                    continue;
                                }
                                this.out.println("Validation for current case not implemented.");
                            }
                            ++noSignal;
                        }
                        break block30;
                    }
                    protocols = analyzer.searchBestProtocol(params, CommandAnalyze.this.decoder, this.commandLineArgs.regexp);
                    if (CommandAnalyze.this.parameterSpecs || CommandAnalyze.this.girr || CommandAnalyze.this.fatgirr) {
                        protocols.forEach(protocol -> protocol.createParameterSpecsIfPossible());
                    }
                    if (!CommandAnalyze.this.girr && !CommandAnalyze.this.fatgirr) break block31;
                    Document doc = ProtocolListDomFactory.protocolListToDom(analyzer, protocols, names, CommandAnalyze.this.radix, CommandAnalyze.this.fatgirr);
                    XmlUtils.printDOM(this.out, doc, this.commandLineArgs.outputEncoding, "");
                    break block30;
                }
                int maxNameLength = IrCoreUtils.maxLength(names);
                for (int i4 = 0; i4 < protocols.size(); ++i4) {
                    if (protocols.size() > 1) {
                        this.out.print(names.isEmpty() ? "#" + i4 + "\t" : names.get(i4) + (this.commandLineArgs.tsvOptimize ? "\t" : IrCoreUtils.spaces(maxNameLength - names.get(i4).length() + 1)));
                    }
                    if (CommandAnalyze.this.statistics) {
                        this.out.println(analyzer.toTimingsString(i4));
                    }
                    this.printAnalyzedProtocol(protocols.get(i4), CommandAnalyze.this.radix, params.isPreferPeriods(), CommandAnalyze.this.statistics, CommandAnalyze.this.timings);
                    if (!CommandAnalyze.this.validate) continue;
                    if (inputSignal != null) {
                        this.validate(protocols.get(i4), inputSignal);
                        continue;
                    }
                    this.out.println("Validation for current case not implemented.");
                }
                if (CommandAnalyze.this.bitUsage) {
                    this.out.println();
                    this.out.println("Bit usage analysis:");
                    Map<String, BitCounter> bitStatistics = BitCounter.scrutinizeProtocols(protocols);
                    bitStatistics.entrySet().forEach(kvp -> this.out.println((String)kvp.getKey() + "\t" + ((BitCounter)kvp.getValue()).toString() + (CommandAnalyze.this.lsb ? " (note: lsb-first)" : "") + "\t" + ((BitCounter)kvp.getValue()).toIntSequenceString()));
                    try {
                        DuplicateFinder duplicateFinder = new DuplicateFinder(protocols, bitStatistics);
                        this.out.println("Duplicates analysis:");
                        Map<String, DuplicateFinder.DuplicateCollection> duplicates = duplicateFinder.getDuplicates();
                        duplicates.entrySet().forEach(kvp -> this.out.println((String)kvp.getKey() + "\t" + ((DuplicateFinder.DuplicateCollection)kvp.getValue()).toString() + (CommandAnalyze.this.lsb ? " (note: lsb-first)" : "")));
                    }
                    catch (NameUnassignedException ex) {
                        logger.warning("Duplicates analysis not possible due to different variables in the protocols.");
                    }
                }
                if (!CommandAnalyze.this.parameterTable) break block30;
                this.out.println();
                this.out.print("Parameter table:");
                for (i = 0; i < parameterNames.size(); ++i) {
                    this.out.print("\t" + (String)parameterNames.get(i) + ":" + parameterWidths.get(i));
                }
                this.out.println();
                for (i = 0; i < protocols.size(); ++i) {
                    if (protocols.size() > 1) {
                        this.out.print(names != null ? names.get(i) + (this.commandLineArgs.tsvOptimize ? "" : IrCoreUtils.spaces(maxNameLength - names.get(i).length() + 1)) : "#" + i + "\t");
                    }
                    Protocol protocol3 = protocols.get(i);
                    ArrayList<String> parameters = parameterNames.isEmpty() ? protocol3.getDefinitions().getNames() : parameterNames;
                    this.printParameters(parameters, protocol3);
                }
            }
        }

        private void printParameters(Iterable<String> parameterNames, Protocol protocol) {
            for (String name : parameterNames) {
                try {
                    int length = protocol.guessParameterLength(name);
                    Number num = protocol.getDefinitions().get(name).toNumber();
                    this.out.print("\t" + num.formatIntegerWithLeadingZeros(CommandAnalyze.this.radix, length));
                }
                catch (NameUnassignedException ex) {
                    throw new ThisCannotHappenException(ex);
                }
            }
            this.out.println();
        }

        private void printAnalyzedProtocol(Protocol protocol, int radix, boolean usePeriods, boolean printWeight, boolean printTimings) {
            if (protocol == null) {
                this.out.println();
                return;
            }
            Protocol actualProtocol = CommandAnalyze.this.eliminateVars ? protocol.substituteConstantVariables() : protocol;
            this.out.println(actualProtocol.toIrpString(radix, usePeriods, this.commandLineArgs.tsvOptimize));
            if (printWeight) {
                this.out.println("weight = " + protocol.weight() + "\t" + protocol.getDecoderName());
            }
            if (printTimings) {
                try {
                    IrSignal irSignal = protocol.toIrSignal(new NameEngine());
                    int introDuration = (int)irSignal.getIntroSequence().getTotalDuration();
                    int repeatDuration = (int)irSignal.getRepeatSequence().getTotalDuration();
                    int endingDuration = (int)irSignal.getEndingSequence().getTotalDuration();
                    this.out.println("timings = (" + introDuration + ", " + repeatDuration + ", " + endingDuration + ").");
                }
                catch (OddSequenceLengthException | DomainViolationException | InvalidNameException | IrpInvalidArgumentException | NameUnassignedException ex) {
                    throw new ThisCannotHappenException(ex);
                }
            }
        }

        private boolean validate(Protocol protocol, IrSignal inputSignal) throws IrpException, IrCoreException {
            IrSignal rendered = protocol.toIrSignal(new NameEngine());
            boolean success = rendered.approximatelyEquals(inputSignal);
            this.out.println(success ? "Validation succeeded!" : String.format("Validation failed: expected%n%s%ngot%n%s", inputSignal.toString(), rendered.toString()));
            return success;
        }
    }
}

