/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.cmdline.AbstractCommand;
import org.harctoolbox.cmdline.CommandCommonOptions;
import org.harctoolbox.cmdline.NameEngineParser;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.BitField;
import org.harctoolbox.irp.FiniteBitField;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.xml.XmlUtils;

@Parameters(commandNames={"bitfield"}, commandDescription="Evaluate bitfield given as argument.")
public class CommandBitField
extends AbstractCommand {
    private static final Logger logger = Logger.getLogger(CommandBitField.class.getName());
    @Parameter(names={"-n", "--nameengine", "--parameters"}, description="Define a name engine for resolving the bitfield.", converter=NameEngineParser.class)
    private NameEngine nameEngine = new NameEngine();
    @Parameter(names={"-l", "--lsb"}, description="Output bitstream with least significant bit first.")
    private boolean lsb = false;
    @Parameter(names={"--xml"}, description="Generate XML and write to file given as argument.")
    private String xml = null;
    @Parameter(description="bitfield", required=true)
    private List<String> bitField;

    @Override
    public String description() {
        return "The \"bitfield\" command computes the value and the binary form corresponding to the bitfield given as input. Using the --nameengine argument, the bitfield can also refer to names. \n\nAs an alternatively, the \"expression\" command may be used. However, a bitfield has a length, which an expression, evaluating to an integer value, does not.";
    }

    public void bitfield(PrintStream out, CommandCommonOptions commandLineArgs) throws NameUnassignedException, FileNotFoundException, UnsupportedEncodingException {
        String text = String.join((CharSequence)"", this.bitField).trim();
        BitField bitfield = BitField.newBitField(text);
        long result = bitfield.toLong(this.nameEngine);
        this.listProperty("integer value", result, out, commandLineArgs.quiet);
        if (bitfield instanceof FiniteBitField) {
            FiniteBitField fbf = (FiniteBitField)bitfield;
            this.listProperty("bitfield", fbf.toBinaryString(this.nameEngine, this.lsb), out, commandLineArgs.quiet);
        }
        if (this.xml != null) {
            XmlUtils.printDOM(IrCoreUtils.getPrintStream(this.xml, commandLineArgs.outputEncoding), bitfield.toDocument(), commandLineArgs.outputEncoding, null);
            logger.log(Level.INFO, "Wrote {0}", this.xml);
        }
    }

    private void listProperty(String propertyName, long value, PrintStream out, boolean quiet) {
        this.listProperty(propertyName, Long.toString(value), out, quiet);
    }

    private void listProperty(String propertyName, String propertyValue, PrintStream out, boolean quiet) {
        if (!quiet && propertyName != null) {
            out.print(propertyName + "=");
        }
        out.println(propertyValue);
    }
}

