/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.harctoolbox.cmdline.AbstractCommand;
import org.harctoolbox.cmdline.CommandCommonOptions;
import org.harctoolbox.cmdline.UsageException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.CodeGenerator;
import org.harctoolbox.irp.DumpCodeGenerator;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.STCodeGenerator;
import org.harctoolbox.irp.UnknownProtocolException;
import org.harctoolbox.irp.UnsupportedRepeatException;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Document;

@Parameters(commandNames={"code"}, commandDescription="Generate code for the given target(s)")
public class CommandCode
extends AbstractCommand {
    private static final Logger logger = Logger.getLogger(CommandCode.class.getName());
    @Parameter(names={"-d", "--directory"}, description="Directory in whicht the generate output files will be written, if not using the --output option.")
    private String directory = null;
    @Parameter(names={"--inspect"}, description="Fire up stringtemplate inspector on generated code (if sensible)")
    private boolean inspect = false;
    @Parameter(names={"-p", "--parameter"}, description="Specify target dependent parameters to the code generators.")
    private List<String> parameters = new ArrayList<String>(4);
    @Parameter(names={"-s", "--stdirectory"}, description="Directory containing st (string template) files for code generation.")
    private String stDir = System.getenv("STDIR") != null ? System.getenv("STDIR") : "st";
    @Parameter(names={"-t", "--target"}, required=true, description="Target(s) for code generation. Use ? for a list.")
    private List<String> target = new ArrayList<String>(4);
    @Parameter(description="protocols")
    private List<String> protocols;

    public void code(PrintStream out, CommandCommonOptions commandLineArgs, IrpDatabase irpDatabase, String[] args) throws IrpInvalidArgumentException, UnknownProtocolException, InvalidNameException, UnsupportedRepeatException, NameUnassignedException, UsageException, UnsupportedEncodingException, IOException {
        CodeClass codeClass = new CodeClass(out, commandLineArgs, irpDatabase, args);
        codeClass.code();
    }

    private class CodeClass {
        private final PrintStream out;
        private final CommandCommonOptions commandLineArgs;
        private final IrpDatabase irpDatabase;
        private final String[] args;

        private CodeClass(PrintStream out, CommandCommonOptions commandLineArgs, IrpDatabase irpDatabase, String[] args) {
            this.out = out;
            this.commandLineArgs = commandLineArgs;
            this.irpDatabase = irpDatabase;
            this.args = args;
        }

        private void code() throws IrpInvalidArgumentException, UnknownProtocolException, InvalidNameException, UnsupportedRepeatException, NameUnassignedException, UsageException, UnsupportedEncodingException, IOException {
            if (CommandCode.this.directory != null && this.commandLineArgs.output != null) {
                throw new UsageException("The --output and the --directory options are mutually exclusive.");
            }
            List<String> protocolNames = this.irpDatabase.evaluateProtocols(CommandCode.this.protocols, this.commandLineArgs.sort, this.commandLineArgs.regexp, this.commandLineArgs.urlDecode);
            if (protocolNames.isEmpty()) {
                throw new UsageException("No protocols matched (forgot --regexp?)");
            }
            if (protocolNames.size() > 1 && CommandCode.this.directory == null) {
                logger.warning("Several protocol will be concatenated in one file. Consider using --directory.");
            }
            STCodeGenerator.setStDir(CommandCode.this.stDir);
            Iterator iterator = CommandCode.this.target.iterator();
            block10: while (iterator.hasNext()) {
                String target;
                switch (target = (String)iterator.next()) {
                    case "?": {
                        this.listTargets(this.out);
                        continue block10;
                    }
                    case "xml": {
                        this.createXmlProtocols(protocolNames);
                        continue block10;
                    }
                    case "dump": {
                        this.code(protocolNames, new DumpCodeGenerator());
                        continue block10;
                    }
                }
                if (!new File(CommandCode.this.stDir).isDirectory()) {
                    throw new IOException("Cannot find stdir = " + new File(CommandCode.this.stDir).getCanonicalPath());
                }
                this.code(protocolNames, target);
            }
        }

        private void code(Collection<String> protocolNames, String pattern) throws IrpInvalidArgumentException, UnknownProtocolException, InvalidNameException, UnsupportedRepeatException, NameUnassignedException, UsageException, IOException {
            File[] targets = IrCoreUtils.filesInDirMatchingRegExp(new File(CommandCode.this.stDir), pattern + ".stg");
            if (targets.length > 1 && CommandCode.this.directory == null) {
                logger.warning("Several targets will be concatenated in one file. Consider using --directory.");
            }
            for (File target : targets) {
                STCodeGenerator codeGenerator;
                try {
                    codeGenerator = new STCodeGenerator(target);
                }
                catch (FileNotFoundException ex) {
                    throw new UsageException("Target " + target.getName() + " not available.  Available targets: " + String.join((CharSequence)" ", this.listTargets()));
                }
                this.code(protocolNames, codeGenerator);
            }
        }

        private void code(Collection<String> protocolNames, CodeGenerator codeGenerator) throws IrpInvalidArgumentException, UnknownProtocolException, InvalidNameException, UnsupportedRepeatException, NameUnassignedException, UsageException, IOException {
            Map<String, String> params = this.assembleParameterMap(CommandCode.this.parameters);
            if (CommandCode.this.directory != null) {
                codeGenerator.generate(protocolNames, this.irpDatabase, new File(CommandCode.this.directory), CommandCode.this.inspect, params, this.commandLineArgs.absoluteTolerance, this.commandLineArgs.relativeTolerance, this.commandLineArgs.frequencyTolerance, this.getClass().getSimpleName(), "1.2.14", String.join((CharSequence)" ", this.args));
            } else {
                codeGenerator.generate(protocolNames, this.irpDatabase, this.out, CommandCode.this.inspect, params, this.commandLineArgs.absoluteTolerance, this.commandLineArgs.relativeTolerance, this.commandLineArgs.frequencyTolerance, this.getClass().getSimpleName(), "1.2.14", String.join((CharSequence)" ", this.args));
            }
        }

        private List<String> listTargets() throws IOException {
            List<String> targets = STCodeGenerator.listTargets();
            targets.add("xml");
            targets.add("dump");
            targets.sort(String.CASE_INSENSITIVE_ORDER);
            return targets;
        }

        private void listTargets(PrintStream stream) throws IOException {
            stream.println(String.join((CharSequence)" ", this.listTargets()));
        }

        private void createXmlProtocols(List<String> protocolNames) throws UnsupportedEncodingException {
            Document document = this.irpDatabase.toDocument(protocolNames, this.commandLineArgs.absoluteTolerance, this.commandLineArgs.relativeTolerance, this.commandLineArgs.frequencyTolerance, this.commandLineArgs.minLeadout);
            XmlUtils.printDOM(this.out, document, this.commandLineArgs.outputEncoding, "Irp");
        }

        private Map<String, String> assembleParameterMap(List<String> paramStrings) throws UsageException {
            HashMap<String, String> result = new HashMap<String, String>(paramStrings.size());
            for (String s : paramStrings) {
                String[] kvp = s.split(":");
                if (kvp.length != 2) {
                    throw new UsageException("Wrong syntax for parameter:value");
                }
                result.put(kvp[0], kvp[1]);
            }
            return result;
        }
    }
}

