/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.harctoolbox.analyze.Cleaner;
import org.harctoolbox.analyze.RepeatFinder;
import org.harctoolbox.cmdline.AbstractCommand;
import org.harctoolbox.cmdline.CmdUtils;
import org.harctoolbox.cmdline.CommandAnalyze;
import org.harctoolbox.cmdline.CommandCommonOptions;
import org.harctoolbox.cmdline.FrequencyParser;
import org.harctoolbox.cmdline.Radix;
import org.harctoolbox.cmdline.UsageException;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.MultiParser;
import org.harctoolbox.ircore.ThingsLineParser;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.ElementaryDecode;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpParseException;
import org.harctoolbox.irp.ProtocolListDomFactory;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Parameters(commandNames={"decode"}, commandDescription="Decode IR signal given as argument")
public class CommandDecode
extends AbstractCommand {
    private static final Logger logger = Logger.getLogger(CommandDecode.class.getName());
    @Parameter(names={"-a", "--all", "--no-prefer-over"}, description="Output all decodes; ignore prefer-over.")
    private boolean noPreferOver = false;
    @Parameter(names={"-c", "--clean"}, description="Invoke cleaner on signal")
    private boolean cleaner = false;
    @Parameter(names={"--debugpattern"}, description="Stop pattern for decoding", hidden=true)
    private String debugPattern = null;
    @Parameter(names={"-f", "--frequency"}, converter=FrequencyParser.class, description="Set modulation frequency.")
    private Double frequency = null;
    @Parameter(names={"-g", "--girroutput"}, description="Generate output in Girr format (only)")
    private boolean girr = false;
    @Parameter(names={"-G", "--girrinput"}, description="Read raw input in Girr format.")
    private String girrInput = null;
    @Parameter(names={"-l", "--ignoreleadinggarbage"}, description="Accept decodes starting with undecodable pairs.")
    private boolean ignoreLeadingGarbage = false;
    @Parameter(names={"-i", "--input"}, description="File/URL from which to take inputs, one per line.")
    private String input = null;
    @Parameter(names={"-k", "--keep-defaulted"}, description="In output, do not remove parameters that are equal to their defaults.")
    private boolean keepDefaultedParameters = false;
    @Parameter(names={"-n", "--namedinput"}, description="File/URL from which to take inputs, one line name, data one line.")
    private String namedInput = null;
    @Parameter(names={"-p", "--protocol"}, description="Comma separated list of protocols to try match (default all).")
    private String protocol = null;
    @Parameter(names={"-r", "--repeatfinder"}, description="Invoke repeat finder on input sequence")
    private boolean repeatFinder = false;
    @Parameter(names={"-R", "--dump-repeatfinder"}, description="Print the result of the repeatfinder.")
    private boolean dumpRepeatfinder = false;
    @Parameter(names={"--radix"}, description="Radix used for printing of output parameters.", validateWith={Radix.class})
    private int radix = 10;
    @Parameter(names={"--recursive"}, description="Apply decoder recursively, (for long signals).")
    private boolean recursive = false;
    @Parameter(names={"-s", "--strict"}, description="Require intro- and repeat sequences to match exactly.")
    private boolean strict = false;
    @Parameter(names={"-T", "--trailinggap"}, description="Trailing gap (in micro seconds) added to sequences of odd length.")
    private Double trailingGap = null;
    @Parameter(names={"--xslt"}, description="File/URL name of XSLT transformation that will be applied to --input or --namedinput argument")
    private String xslt = null;
    @Parameter(description="durations in micro seconds, alternatively pronto hex", required=false)
    private List<String> args;

    @Override
    public String description() {
        return "The \"decode\" command takes as input one or several sequences or signals, and output one or many protocol/parameter combinations that corresponds to the given input (within the specified tolerances). The input can be given either as Pronto Hex or in raw form, optionally with signs (ignored). Several raw format input sequences can be given by enclosing the individual sequences in brackets (\"[]\"). \n\nFor raw sequences, an explicit modulation frequency can be given with the --frequency option. Otherwise the default frequency, 38000Hz, will be assumed. \n\nUsing the option --input, instead the content of a file can be taken as input, containing sequences to be analyzed, one per line, blank lines ignored. Using the option --namedinput, the sequences may have names, immediately preceeding the signal. \n\nInput sequences can be pre-processed using the options --clean, and --repeatfinder. \n\nThe common options --absolutetolerance --relativetolerance, --minrepeatgap determine how the repeat finder breaks the input data. ";
    }

    public void decode(PrintStream out, CommandCommonOptions commandLineArgs, IrpDatabase irpDatabase) throws UsageException, IrpParseException, IOException, InvalidArgumentException, SAXException, TransformerException {
        DecodeClass decodeClass = new DecodeClass(out, commandLineArgs, irpDatabase);
        decodeClass.decode();
    }

    private class DecodeClass {
        private final PrintStream out;
        private final CommandCommonOptions commandLineArgs;
        private final IrpDatabase irpDatabase;
        private final Decoder.DecoderParameters decoderParams;
        private Decoder decoder;

        DecodeClass(PrintStream out, CommandCommonOptions commandLineArgs, IrpDatabase irpDatabase) {
            this.out = out;
            this.commandLineArgs = commandLineArgs;
            this.irpDatabase = irpDatabase;
            this.decoderParams = this.newDecoderParameters();
        }

        private void decode() throws UsageException, IrpParseException, IOException, InvalidArgumentException, SAXException, TransformerException {
            CmdUtils.checkForOption("decode", CommandDecode.this.args);
            if (IrCoreUtils.numberTrue(CommandDecode.this.input != null, CommandDecode.this.namedInput != null, CommandDecode.this.girrInput != null, CommandDecode.this.args != null) != 1) {
                throw new UsageException("Must use exactly one of --input, --namedinput, --girrinput and non-empty arguments");
            }
            if (CommandDecode.this.ignoreLeadingGarbage && CommandDecode.this.strict) {
                throw new UsageException("--strict and --ignoreleadinggarbage may not be used together.");
            }
            Decoder.setDebugProtocolRegExp(CommandDecode.this.debugPattern);
            List<String> protocolNamePatterns = CommandDecode.this.protocol == null ? null : Arrays.asList(CommandDecode.this.protocol.split(","));
            List<String> protocolsNames = this.irpDatabase.evaluateProtocols(protocolNamePatterns, this.commandLineArgs.sort, this.commandLineArgs.regexp, this.commandLineArgs.urlDecode);
            if (protocolsNames.isEmpty()) {
                throw new UsageException("No protocol given or matched.");
            }
            this.decoder = new Decoder(this.irpDatabase, protocolsNames);
            if (CommandDecode.this.input != null) {
                ThingsLineParser irSignalParser = new ThingsLineParser(line -> MultiParser.newIrCoreParser(line).toIrSignal(CommandDecode.this.frequency, CommandDecode.this.trailingGap), this.commandLineArgs.commentStart);
                List<IrSignal> signals = CommandDecode.this.xslt == null ? irSignalParser.readThings(CommandDecode.this.input, this.commandLineArgs.inputEncoding, false) : irSignalParser.readThings(CommandDecode.this.input, CommandDecode.this.xslt, this.commandLineArgs.inputEncoding, false);
                this.decode(signals);
            } else if (CommandDecode.this.namedInput != null) {
                ThingsLineParser irSignalParser = new ThingsLineParser(line -> MultiParser.newIrCoreParser(line).toIrSignal(CommandDecode.this.frequency, CommandDecode.this.trailingGap), this.commandLineArgs.commentStart);
                Map<String, IrSignal> signals = CommandDecode.this.xslt == null ? irSignalParser.readNamedThings(CommandDecode.this.namedInput, this.commandLineArgs.inputEncoding) : irSignalParser.readNamedThings(CommandDecode.this.namedInput, CommandDecode.this.xslt, this.commandLineArgs.inputEncoding);
                this.decode(signals);
            } else if (CommandDecode.this.girrInput != null) {
                ThingsLineParser irSignalParser = new ThingsLineParser(line -> MultiParser.newIrCoreParser(line).toIrSignal(CommandDecode.this.frequency, CommandDecode.this.trailingGap), this.commandLineArgs.commentStart);
                InputStream xsltStream = CommandAnalyze.class.getResourceAsStream("/rawgirr2named.xsl");
                Document xsltDoc = XmlUtils.openXmlStream(xsltStream, null, true, true);
                Map<String, IrSignal> signals = irSignalParser.readNamedThings(CommandDecode.this.girrInput, xsltDoc, this.commandLineArgs.inputEncoding);
                this.decode(signals);
            } else {
                MultiParser prontoRawParser = MultiParser.newIrCoreParser(CommandDecode.this.args);
                IrSignal irSignal = prontoRawParser.toIrSignal(CommandDecode.this.frequency, CommandDecode.this.trailingGap);
                if (irSignal == null) {
                    throw new UsageException("Could not parse as IrSignal: " + String.join((CharSequence)" ", CommandDecode.this.args));
                }
                this.decode(irSignal, null, 0);
            }
        }

        private void decode(List<IrSignal> signals) throws InvalidArgumentException, UnsupportedEncodingException {
            if (CommandDecode.this.girr) {
                ProtocolListDomFactory factory = new ProtocolListDomFactory(CommandDecode.this.radix);
                for (IrSignal irSignal : signals) {
                    Decoder.AbstractDecodesCollection<? extends ElementaryDecode> decodes = this.mkDecodes(irSignal);
                    factory.add(decodes);
                }
                this.printAsGirr(factory);
            } else {
                for (IrSignal irSignal : signals) {
                    this.decode(irSignal, null, 0);
                }
            }
        }

        private void decode(Map<String, IrSignal> signals) throws InvalidArgumentException, UnsupportedEncodingException {
            if (CommandDecode.this.girr) {
                ProtocolListDomFactory factory = new ProtocolListDomFactory(CommandDecode.this.radix);
                for (Map.Entry<String, IrSignal> kvp : signals.entrySet()) {
                    Decoder.AbstractDecodesCollection<? extends ElementaryDecode> decodes = this.mkDecodes(kvp.getValue());
                    factory.add(decodes, kvp.getKey());
                }
                this.printAsGirr(factory);
            } else {
                int maxNameLength = IrCoreUtils.maxLength(signals.keySet());
                for (Map.Entry<String, IrSignal> kvp : signals.entrySet()) {
                    this.decode(kvp.getValue(), kvp.getKey(), maxNameLength);
                }
            }
        }

        private void decode(IrSignal irSig, String name, int maxNameLength) throws InvalidArgumentException, UnsupportedEncodingException {
            Decoder.AbstractDecodesCollection<? extends ElementaryDecode> decodes = this.mkDecodes(irSig);
            if (CommandDecode.this.girr) {
                ProtocolListDomFactory factory = new ProtocolListDomFactory(CommandDecode.this.radix);
                factory.add(decodes);
                this.printAsGirr(factory);
            } else {
                this.printDecodes(decodes, name, maxNameLength);
            }
        }

        private Decoder.AbstractDecodesCollection<? extends ElementaryDecode> mkDecodes(IrSignal irSig) throws InvalidArgumentException {
            Decoder.SimpleDecodesSet decodes;
            IrSignal irSignal;
            Objects.requireNonNull(irSig, "irSignal must be non-null");
            IrSignal irSignal2 = irSignal = CommandDecode.this.frequency != null ? new IrSignal(irSig, CommandDecode.this.frequency) : irSig;
            if (CommandDecode.this.cleaner) {
                irSignal = Cleaner.clean(irSignal, this.commandLineArgs.absoluteTolerance, this.commandLineArgs.relativeTolerance);
                logger.log(Level.INFO, "Cleansed signal: {0}", irSignal.toString(true));
            }
            if (CommandDecode.this.repeatFinder) {
                ModulatedIrSequence sequence = irSignal.toModulatedIrSequence();
                RepeatFinder repeatFinder = new RepeatFinder(sequence, this.commandLineArgs.absoluteTolerance, this.commandLineArgs.relativeTolerance, this.commandLineArgs.minRepeatGap);
                IrSignal fixedIrSignal = repeatFinder.toIrSignalClean(sequence);
                if (CommandDecode.this.dumpRepeatfinder) {
                    this.out.println("RepeatReduced: " + fixedIrSignal);
                    this.out.println("RepeatData: " + repeatFinder.getRepeatFinderData());
                }
                decodes = this.decoder.decodeIrSignal(fixedIrSignal, this.decoderParams);
            } else {
                decodes = this.decoder.decodeLoose(irSignal, this.decoderParams);
            }
            return decodes;
        }

        private Decoder.DecoderParameters newDecoderParameters() {
            return new Decoder.DecoderParameters(CommandDecode.this.strict, CommandDecode.this.noPreferOver, !CommandDecode.this.keepDefaultedParameters, CommandDecode.this.recursive, this.commandLineArgs.frequencyTolerance, this.commandLineArgs.absoluteTolerance, this.commandLineArgs.relativeTolerance, this.commandLineArgs.minLeadout, this.commandLineArgs.override, CommandDecode.this.ignoreLeadingGarbage);
        }

        private void printDecodes(Decoder.AbstractDecodesCollection<? extends ElementaryDecode> decodes, String name, int maxNameLength) {
            if (name != null) {
                this.out.print(name + ":" + (this.commandLineArgs.tsvOptimize ? "\t" : IrCoreUtils.spaces(maxNameLength - name.length() + 1)));
            }
            decodes.println(this.out, CommandDecode.this.radix, this.commandLineArgs.tsvOptimize ? "\t" : " ", this.commandLineArgs.quiet);
        }

        private void printAsGirr(ProtocolListDomFactory factory) throws UnsupportedEncodingException {
            Document doc = factory.toDocument();
            XmlUtils.printDOM(this.out, doc, this.commandLineArgs.outputEncoding, "");
        }
    }
}

