/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.util.List;
import org.harctoolbox.cmdline.AbstractCommand;
import org.harctoolbox.cmdline.CommandCommonOptions;
import org.harctoolbox.cmdline.NameEngineParser;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.MultiParser;
import org.harctoolbox.ircore.OddSequenceLengthException;

@Parameters(commandNames={"demodulate"}, commandDescription="Demodulate IrSequence given as argument (EXPERIMENTAL).")
public class CommandDemodulate
extends AbstractCommand {
    @Parameter(names={"-t", "--threshold"}, description="Threshold used for demodulating, in micro seconds.", converter=NameEngineParser.class)
    private double threshold = 35.0;
    @Parameter(description="durations in micro seconds, alternatively pronto hex", required=true)
    private List<String> args;

    @Override
    public String description() {
        return "This command demodulates its argument IrSequence, emulating the use of a demodulating IR receiver. This means that all gaps less than or equal to the threshold are squeezed into the preceeding flash. Typically the threshold is taken around the period of the expected modulation frequency.";
    }

    public void demodulate(PrintStream out, CommandCommonOptions commandLineArgs) throws OddSequenceLengthException, InvalidArgumentException {
        MultiParser prontoRawParser = MultiParser.newIrCoreParser(this.args);
        IrSequence irSequence = prontoRawParser.toIrSequence(commandLineArgs.minLeadout);
        ModulatedIrSequence demodulated = ModulatedIrSequence.demodulate(irSequence, this.threshold);
        out.println(demodulated.toString(true));
    }
}

