/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.cmdline.AbstractCommand;
import org.harctoolbox.cmdline.CommandCommonOptions;
import org.harctoolbox.cmdline.NameEngineParser;
import org.harctoolbox.cmdline.Radix;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.IrpParseException;
import org.harctoolbox.irp.IrpUtils;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.xml.XmlUtils;

@Parameters(commandNames={"expression"}, commandDescription="Evaluate expression given as argument.")
public class CommandExpression
extends AbstractCommand {
    private static final Logger logger = Logger.getLogger(CommandExpression.class.getName());
    @Parameter(names={"-n", "--nameengine", "--parameters"}, description="Define a name engine to use for evaluating.", converter=NameEngineParser.class)
    private NameEngine nameEngine = new NameEngine();
    @Parameter(names={"-r", "--radix"}, description="Radix for outputting result.", validateWith={Radix.class})
    private int radix = 10;
    @Parameter(names={"--stringtree"}, description="Output stringtree.")
    private boolean stringTree = false;
    @Parameter(names={"--gui", "--display"}, description="Display parse diagram.")
    private boolean gui = false;
    @Parameter(names={"--xml"}, description="Generate XML and write to file argument.")
    private String xml = null;
    @Parameter(description="expression", required=true)
    private List<String> expressions;

    @Override
    public String description() {
        return "This command evaluates its argument as an expression. Using the --nameengine argument, the expression may also contain names. The --gui options presents a graphical representation of the parse tree.";
    }

    public void expression(PrintStream out, CommandCommonOptions commandLineArgs) throws FileNotFoundException, NameUnassignedException, IrpParseException, UnsupportedEncodingException {
        String text = String.join((CharSequence)" ", this.expressions).trim();
        Expression expression = Expression.newExpressionEOF(text);
        long result = expression.toLong(this.nameEngine);
        out.println(IrCoreUtils.radixPrefix(this.radix) + Long.toString(result, this.radix));
        if (this.stringTree) {
            out.println(expression.toStringTree());
        }
        if (this.xml != null) {
            XmlUtils.printDOM(this.xml, expression.toDocument(), commandLineArgs.outputEncoding, null);
            logger.log(Level.INFO, "Wrote {0}", this.xml);
        }
        if (this.gui) {
            IrpUtils.showTreeViewer(expression.toTreeViewer(), text + "=" + result);
        }
    }
}

