/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameterized;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.DefaultConsole;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.harctoolbox.cmdline.AbstractCommand;
import org.harctoolbox.cmdline.CommandCommonOptions;
import org.harctoolbox.cmdline.CommandLogOptions;

@Parameters(commandNames={"help"}, commandDescription="Describe the syntax of program and commands.")
public class CommandHelp
extends AbstractCommand {
    @Parameter(names={"-c", "--common", "--options"}, description="Describe the common options only.")
    private boolean commonOptions = false;
    @Parameter(names={"-l", "--logging"}, description="Describe the logging related options only.")
    private boolean loggingOptions = false;
    @Parameter(names={"-s", "--short"}, description="Produce a short usage message.")
    private boolean shortForm = false;
    @Parameter(description="commands")
    private List<String> commands = null;

    private static String padString(String name, int length) {
        StringBuilder stringBuilder = new StringBuilder(name);
        while (stringBuilder.length() < length) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static void usage(PrintStream printStream, String command, JCommander argumentParser) {
        argumentParser.setConsole(new DefaultConsole(printStream));
        if (command == null) {
            argumentParser.usage();
        } else {
            DefaultUsageFormatter formatter = new DefaultUsageFormatter(argumentParser);
            formatter.usage(command);
        }
    }

    public void help(PrintStream out, AbstractCommand commonCommand, JCommander argumentParser, String url) {
        Help instance = new Help(out, argumentParser, commonCommand);
        instance.help(url);
    }

    @Override
    public String description() {
        return "This command lists the syntax for the command(s) given as argument, default all. Also see the option \"--describe\".";
    }

    private class Help {
        private final PrintStream out;
        private final JCommander argumentParser;
        private final AbstractCommand commonCommand;

        private Help(PrintStream out, JCommander argumentParser, AbstractCommand commonCommand) {
            this.out = out;
            this.argumentParser = argumentParser;
            this.commonCommand = commonCommand;
            argumentParser.setConsole(new DefaultConsole(out));
        }

        private void help(String url) {
            if (CommandHelp.this.shortForm) {
                this.shortUsage(this.out, this.argumentParser, url);
                return;
            }
            if (CommandHelp.this.commonOptions) {
                this.commonOptions(this.out);
                return;
            }
            if (CommandHelp.this.loggingOptions) {
                this.loggingOptions(this.out);
                return;
            }
            String cmd = this.argumentParser.getParsedCommand();
            if (CommandHelp.this.commands != null) {
                CommandHelp.this.commands.forEach(command -> {
                    try {
                        CommandHelp.usage(this.out, command, this.argumentParser);
                    }
                    catch (ParameterException ex) {
                        this.out.println("No such command: " + command);
                    }
                });
            } else if (cmd == null || cmd.equals("help")) {
                CommandHelp.usage(this.out, null, this.argumentParser);
                this.printDocumentationUrl(url);
            } else {
                CommandHelp.usage(this.out, cmd, this.argumentParser);
            }
        }

        private void commonOptions(PrintStream out) {
            JCommander parser = new JCommander(this.commonCommand);
            this.options(out, parser, "Common options:\n");
        }

        private void options(PrintStream out, JCommander parser, String title) {
            parser.setConsole(new DefaultConsole(out));
            StringBuilder str = new StringBuilder(2500);
            DefaultUsageFormatter formatter = new DefaultUsageFormatter(parser);
            formatter.usage(str);
            str.replace(0, 41, title);
            out.println(str.toString().trim());
        }

        private void loggingOptions(PrintStream out) {
            List<String> loggingOpts = Arrays.asList(CommandLogOptions.loggingOptions);
            CommandCommonOptions cla = new CommandCommonOptions();
            JCommander parser = new JCommander(cla);
            Map<Parameterized, ParameterDescription> f = parser.getFields();
            ArrayList<Parameterized> list = new ArrayList<Parameterized>(f.keySet());
            list.stream().filter(p -> !loggingOpts.contains(p.getName())).forEachOrdered(p -> f.remove(p));
            this.options(out, parser, "Logging options:\n");
        }

        private void shortUsage(PrintStream out, JCommander argumentParser, String documentationUrl) {
            String PROGRAMNAME = argumentParser.getProgramName();
            out.println("Usage: " + PROGRAMNAME + " [options] [command] [command options]");
            out.println("Commands:");
            DefaultUsageFormatter formatter = new DefaultUsageFormatter(argumentParser);
            ArrayList<String> cmds = new ArrayList<String>(argumentParser.getCommands().keySet());
            Collections.sort(cmds);
            cmds.forEach(cmd -> out.println("   " + CommandHelp.padString(cmd, 16) + formatter.getCommandDescription((String)cmd)));
            out.println();
            out.println("Use");
            out.println("    \"" + PROGRAMNAME + " help\" for the full syntax,");
            out.println("    \"" + PROGRAMNAME + " help <command>\" for a particular command,");
            out.println("    \"" + PROGRAMNAME + " <command> --describe\" for a description,");
            out.println("    \"" + PROGRAMNAME + " help --common\" for the common options.");
            out.println("    \"" + PROGRAMNAME + " help --logging\" for the logging related options.");
            this.printDocumentationUrl(documentationUrl);
        }

        private void printDocumentationUrl(String documentationUrl) {
            this.out.println();
            this.out.println("For documentation, see " + documentationUrl);
        }
    }
}

