/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.harctoolbox.cmdline.CommandBasicOptions;
import org.harctoolbox.cmdline.FileListParser;
import org.harctoolbox.cmdline.UsageException;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpParseException;
import org.harctoolbox.irp.UnknownProtocolException;
import org.xml.sax.SAXException;

public class CommandIrpDatabaseOptions
extends CommandBasicOptions {
    @Parameter(names={"-b", "--blacklist"}, description="List of protocols to be removed from the data base")
    public List<String> blackList = null;
    @Parameter(names={"-c", "--configfiles"}, listConverter=FileListParser.class, description="Pathname(s) of IRP database file(s) in XML format. Default is the one in the jar file. Can be given several times.")
    public List<File> configFiles = null;
    @Parameter(names={"-i", "--irp"}, description="Explicit IRP string to use as protocol definition.")
    public String irp = null;
    @Parameter(names={"--validate"}, description="Validate IRP database files against the schema, abort if not valid.")
    public boolean validate = false;

    public IrpDatabase setupDatabase() throws UsageException, IrpParseException, IOException, UnknownProtocolException, SAXException {
        if (this.configFiles != null && this.irp != null) {
            throw new UsageException("At most one of --configfile and --irp can be specified");
        }
        IrpDatabase.setValidating(this.validate);
        IrpDatabase irpDatabase = this.irp != null ? IrpDatabase.parseIrp("user_protocol", this.irp, "Protocol entered on the command line") : (this.configFiles != null ? new IrpDatabase(this.configFiles) : new IrpDatabase((String)null));
        irpDatabase.remove(this.blackList);
        return irpDatabase;
    }
}

