/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.harctoolbox.cmdline.AbstractCommand;
import org.harctoolbox.cmdline.Radix;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.NonUniqueBitCodeException;
import org.harctoolbox.lirc.LircCommand;
import org.harctoolbox.lirc.LircConfigFile;
import org.harctoolbox.lirc.LircIrp;
import org.harctoolbox.lirc.LircRemote;

@Parameters(commandNames={"lirc"}, commandDescription="Convert Lirc configuration files to IRP form.")
public class CommandLirc
extends AbstractCommand {
    @Parameter(names={"-c", "--commands"}, description="Also list the commands if the remotes.")
    private boolean commands = false;
    @Parameter(names={"-r", "--radix"}, hidden=true, description="Radix for outputting result, default 16.", validateWith={Radix.class})
    private int radix = 16;
    @Parameter(description="Lirc config files/directories/URLs; empty for <stdin>.", required=false)
    private List<String> files = new ArrayList<String>(8);

    @Override
    public String description() {
        return "This command reads a Lirc configuration, from a file, directory, or an URL, and computes a correponding IRP form. No attempt is made to clean up, for example by rounding times or finding a largest common divider.";
    }

    public void lirc(PrintStream out, String encoding) throws IOException {
        List<LircRemote> list;
        if (this.files.isEmpty()) {
            list = LircConfigFile.readRemotes(new InputStreamReader(System.in, encoding));
        } else {
            list = new ArrayList<LircRemote>(this.files.size());
            for (String f : this.files) {
                list.addAll(LircConfigFile.readRemotes(f, encoding));
            }
        }
        for (LircRemote rem : list) {
            out.print(rem.getName() + ":\t");
            try {
                out.println(LircIrp.toProtocol(rem).toIrpString(this.radix, false));
            }
            catch (LircIrp.RawRemoteException ex) {
                out.println("raw remote");
            }
            catch (LircIrp.LircCodeRemoteException ex) {
                out.println("lirc code remote, does not contain relevant information.");
            }
            catch (NonUniqueBitCodeException ex) {
                out.println("Non-unique bitcodes");
            }
            if (!this.commands) continue;
            for (LircCommand cmd : rem.getCommands()) {
                out.print(cmd.getName() + ":\t");
                cmd.getCodes().forEach(x -> out.print(IrCoreUtils.radixPrefix(this.radix) + Long.toUnsignedString(x, this.radix) + " "));
                out.println();
            }
        }
    }
}

