/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.cmdline.AbstractCommand;
import org.harctoolbox.cmdline.CmdUtils;
import org.harctoolbox.cmdline.CommandCommonOptions;
import org.harctoolbox.cmdline.Radix;
import org.harctoolbox.cmdline.UsageException;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.IrpUtils;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.NamedProtocol;
import org.harctoolbox.irp.UnknownProtocolException;
import org.harctoolbox.irp.UnsupportedRepeatException;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

@Parameters(commandNames={"list"}, commandDescription="List protocols and their properties.")
public class CommandList
extends AbstractCommand {
    private static final Logger logger = Logger.getLogger(CommandList.class.getName());
    @Parameter(names={"-a", "--all"}, description="Implies (almost) all of the \"list xxx\"-options.")
    private boolean all = false;
    @Parameter(names={"--check-sorted"}, description="Check if the protocol are alphabetically.")
    private boolean checkSorted = false;
    @Parameter(names={"-c", "--classify"}, description="Classify the protocol(s).")
    private boolean classify = false;
    @Parameter(names={"--documentation"}, description="Print (possible longer) documentation, as a dumb rendering of the HTML documenation.")
    private boolean documentation = false;
    @Parameter(names={"-d", "--dump"}, description="Print the IRP data base as DOC tree stringified, including initial XML comments.")
    private boolean dump = false;
    @Parameter(names={"--gui", "--display"}, description="Display parse diagram.")
    private boolean gui = false;
    @Parameter(names={"--html"}, description="Print (possible longer) documentation as HTML.")
    private boolean html = false;
    @Parameter(names={"-i", "--irp"}, description="List IRP form, as given in the database (unparsed, i.e. preserving comments and whitespace, not taking --radix into account).")
    private boolean irp = false;
    @Parameter(names={"--istring"}, hidden=true, description="test toIrpString.")
    private boolean is = false;
    @Parameter(names={"-m", "--mindiff"}, description="Compute minimal difference between contained durations.")
    private boolean minDiff = false;
    @Parameter(names={"-n", "--normalform"}, description="List the normal form.")
    private boolean normalForm = false;
    @Parameter(names={"-p", "--parsedirp"}, hidden=true, description="List IRP form, as parsed.")
    private boolean parsedIrp = false;
    @Parameter(names={"--prefer-overs"}, description="List all protocol's prefer-overs, recursively.")
    private boolean preferOvers = false;
    @Parameter(names={"--name"}, description="List protocol name, also if --quiet is given.")
    private boolean name = false;
    @Parameter(names={"-r", "--radix"}, description="Radix of parameter output.", validateWith={Radix.class})
    private int radix = 10;
    @Parameter(names={"--stringtree"}, description="Produce stringtree.")
    private boolean stringTree = false;
    @Parameter(names={"-w", "--weight"}, description="Compute weight of the protocols.")
    private boolean weight = false;
    @Parameter(names={"--warnings"}, description="Issue warnings for some problematic IRP constructs.")
    private boolean warnings = false;
    @Parameter(names={"-x", "--xml"}, description="Like dump, but without XML comments.")
    private boolean xml = false;
    @Parameter(description="List of protocols (default all)")
    private List<String> protocols = new ArrayList<String>(8);

    @Override
    public String description() {
        return "This command list miscellaneous properties of the protocol(s) given as arguments.";
    }

    public void list(PrintStream out, CommandCommonOptions commandLineArgs, IrpDatabase irpDatabase) throws UsageException, InvalidNameException, UnsupportedRepeatException, IrpInvalidArgumentException, NameUnassignedException, UnknownProtocolException, UnsupportedEncodingException, NamedProtocol.TooDeepPreferOversException {
        List<String> list;
        CmdUtils.checkForOption("list", this.protocols);
        if (this.checkSorted) {
            String offender = irpDatabase.checkSorted();
            if (offender == null) {
                out.println("Protocol data base is sorted.");
            } else {
                out.println("Protocol data base is NOT sorted, first offending protocol: " + offender + ".");
            }
            return;
        }
        if (!commandLineArgs.quiet) {
            this.protocols.stream().filter(protocol -> irpDatabase.isAlias((String)protocol)).forEachOrdered(protocol -> out.println(protocol + " -> " + irpDatabase.expandAlias((String)protocol)));
        }
        if ((list = irpDatabase.evaluateProtocols(this.protocols, commandLineArgs.sort, commandLineArgs.regexp, commandLineArgs.urlDecode)).isEmpty()) {
            throw new UsageException("No protocol matched.");
        }
        if (this.dump || this.xml) {
            Document document = irpDatabase.toDocument(list, this.dump);
            XmlUtils.printDOM(out, document, commandLineArgs.outputEncoding, "Irp Documentation");
            return;
        }
        for (String name : list) {
            NamedProtocol protocol2;
            String protocolName = irpDatabase.expandAlias(name);
            try {
                protocol2 = irpDatabase.getNamedProtocol(protocolName);
                logger.log(Level.FINE, "Protocol {0} parsed", protocolName);
            }
            catch (UnknownProtocolException ex) {
                logger.log(Level.WARNING, "{0}", ex.getMessage());
                continue;
            }
            catch (InvalidNameException | IrpInvalidArgumentException | NameUnassignedException | UnsupportedRepeatException ex) {
                logger.log(Level.WARNING, "Unparsable protocol {0}", protocolName);
                continue;
            }
            if (!commandLineArgs.quiet || this.name || this.all) {
                this.listProperty(out, "name", irpDatabase.getName(protocolName), commandLineArgs.quiet);
            }
            if (this.irp || this.all) {
                this.listProperty(out, "irp", irpDatabase.getIrp(protocolName), commandLineArgs.quiet);
            }
            if (this.parsedIrp) {
                this.listProperty(out, "parsedirp", protocol2.toIrpString(this.radix), commandLineArgs.quiet);
            }
            if (this.normalForm) {
                try {
                    this.listProperty(out, "normal form", irpDatabase.getNormalFormIrp(protocolName, this.radix), commandLineArgs.quiet);
                }
                catch (InvalidNameException | IrpInvalidArgumentException | NameUnassignedException | UnknownProtocolException | UnsupportedRepeatException ex) {
                    throw new ThisCannotHappenException(ex);
                }
            }
            if (this.documentation || this.all) {
                this.listProperty(out, "documentation", irpDatabase.getDocumentation(protocolName), commandLineArgs.quiet);
            }
            if (this.html) {
                this.listDocumentFragment(out, protocol2.getDocumentation(), commandLineArgs.quiet, commandLineArgs.outputEncoding);
            }
            if (this.stringTree) {
                this.listProperty(out, "stringTree", protocol2.toStringTree(), commandLineArgs.quiet);
            }
            if (this.is) {
                this.listProperty(out, "irpString", protocol2.toIrpString(this.radix), commandLineArgs.quiet);
            }
            if (this.gui) {
                IrpUtils.showTreeViewer(protocol2.toTreeViewer(), "Parse tree for " + protocolName);
            }
            if (this.weight || this.all) {
                this.listProperty(out, "Weight", protocol2.weight(), commandLineArgs.quiet);
            }
            if (this.minDiff || this.all) {
                this.listProperty(out, "minDiff", protocol2.minDurationDiff(), commandLineArgs.quiet);
            }
            if (this.classify || this.all) {
                this.listProperty(out, "classification", protocol2.classificationString(), commandLineArgs.quiet);
            }
            if (this.warnings || this.all) {
                this.listProperty(out, "warnings", protocol2.warningsString(), commandLineArgs.quiet);
            }
            if (!this.preferOvers && !this.all) continue;
            out.println("preferovers tree:");
            if (commandLineArgs.quiet && !this.name && !protocol2.preferredOvers().isEmpty()) {
                out.println(irpDatabase.getName(protocolName) + ":");
            }
            protocol2.dumpPreferOvers(out, irpDatabase);
        }
    }

    private void listProperty(PrintStream out, String propertyName, String propertyValue, boolean quiet) {
        if (!quiet && propertyName != null) {
            out.print(propertyName + "=");
        }
        out.println(propertyValue);
    }

    private void listProperty(PrintStream out, String propertyName, double value, boolean quiet) {
        this.listProperty(out, propertyName, Math.round(value), quiet);
    }

    private void listProperty(PrintStream out, String propertyName, int value, boolean quiet) {
        this.listProperty(out, propertyName, Integer.toString(value), quiet);
    }

    private void listProperty(PrintStream out, String propertyName, long value, boolean quiet) {
        this.listProperty(out, propertyName, Long.toString(value), quiet);
    }

    private void listDocumentFragment(PrintStream out, DocumentFragment fragment, boolean quiet, String encoding) throws UnsupportedEncodingException {
        Objects.requireNonNull(fragment);
        Document document = XmlUtils.wrapDocumentFragment(fragment, "http://www.w3.org/1999/xhtml", "div", "class", "protocol-documentation");
        if (!quiet) {
            out.print("html=");
        }
        XmlUtils.printHtmlDOM(out, document, encoding);
        out.println();
    }
}

