/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.cmdline.AbstractCommand;
import org.harctoolbox.cmdline.CommandCommonOptions;
import org.harctoolbox.cmdline.NameEngineParser;
import org.harctoolbox.cmdline.UsageException;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.Pronto;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.DomainViolationException;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.IrpParseException;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.NamedProtocol;
import org.harctoolbox.irp.Protocol;
import org.harctoolbox.irp.UnknownProtocolException;
import org.harctoolbox.irp.UnsupportedRepeatException;

@Parameters(commandNames={"render"}, commandDescription="Render signal from parameters")
public class CommandRender
extends AbstractCommand {
    private static final Logger logger = Logger.getLogger(CommandRender.class.getName());
    @Parameter(names={"-#", "--count"}, description="Generate am IR sequence with count number of transmissions")
    private Integer count = null;
    @Parameter(names={"-d", "--decode"}, description="Send the rendered signal to the decoder (for debugging/development).")
    private boolean decode = false;
    @Parameter(names={"-m", "--modulate"}, description="Generate modulated form (EXPERIMENTAL)")
    private boolean modulate = false;
    @Parameter(names={"-n", "--nameengine", "--parameters"}, description="Name Engine to use", converter=NameEngineParser.class)
    private NameEngine nameEngine = new NameEngine();
    @Parameter(names={"-p", "--pronto", "--ccf", "--hex"}, description="Generate Pronto hex.")
    private boolean pronto = false;
    @Parameter(names={"-P", "--printparameters"}, description="Print actual parameters values, for example by --random")
    private boolean printParameters = false;
    @Parameter(names={"-r", "--signed-raw"}, description="Generate raw form.")
    private boolean raw = false;
    @Parameter(names={"-R", "--raw-without-signs"}, description="Generate raw form without signs.")
    private boolean rawWithoutSigns = false;
    @Parameter(names={"--random"}, description="Generate random, valid, parameters")
    private boolean random = false;
    @Parameter(names={"--number-repeats"}, description="Generate an IR sequence containing the given number of repeats")
    private Integer numberRepeats = null;
    @Parameter(description="protocol(s) or pattern (if using --regexp)")
    private List<String> protocols = new ArrayList<String>(0);

    @Override
    public String description() {
        return "This command is used to compute an IR signal from one or more protocols (\"render\" it). The protocol can be given either by name(s) (or regular expression if using the --regexp option), or, using the --irp options, given explicitly as an IRP form. The parameters can be either given directly with the -n option, or the --random option can be used to generate random, but valid parameters. With the --count or --number-repeats option, instead an IR sequence is computed, containing the desired number of repeats.\n\nThe syntax of the name engine is as in the IRP specification, for example: --nameengine {D=12,F=34}. For convenience, the braces may be left out. Space around the equal sign \"=\" and around the comma \",\" is allowed, as long as the name engine is still only one argument in the sense of the shell -- it may need to be enclosed within single or double quotes.";
    }

    public void render(PrintStream printStream, IrpDatabase irpDatabase, CommandCommonOptions commonOptions) throws UsageException, IOException, OddSequenceLengthException, UnknownProtocolException, InvalidNameException, DomainViolationException, UnsupportedRepeatException, IrpInvalidArgumentException, NameUnassignedException, IrpParseException, Protocol.ProtocolNotRenderableException {
        Renderer renderer = new Renderer(printStream, irpDatabase, commonOptions);
        renderer.render();
    }

    private class Renderer {
        private final PrintStream out;
        private final CommandCommonOptions commandLineArgs;
        private final IrpDatabase irpDatabase;

        private Renderer(PrintStream printStream, IrpDatabase irpDatabase, CommandCommonOptions commonOptions) {
            this.irpDatabase = irpDatabase;
            this.commandLineArgs = commonOptions;
            this.out = printStream;
        }

        private void render() throws UsageException, IOException, OddSequenceLengthException, UnknownProtocolException, InvalidNameException, DomainViolationException, UnsupportedRepeatException, IrpInvalidArgumentException, NameUnassignedException, IrpParseException, Protocol.ProtocolNotRenderableException {
            if (this.commandLineArgs.irp == null && CommandRender.this.random != CommandRender.this.nameEngine.isEmpty()) {
                throw new UsageException("Must give exactly one of --nameengine and --random, unless using --irp");
            }
            if (this.commandLineArgs.irp != null && !CommandRender.this.protocols.isEmpty()) {
                throw new UsageException("Cannot not use --irp together with named protocols");
            }
            List<String> list = this.irpDatabase.evaluateProtocols(CommandRender.this.protocols, this.commandLineArgs.sort, this.commandLineArgs.regexp, this.commandLineArgs.urlDecode);
            if (list.isEmpty()) {
                throw new UsageException("No protocol matched.");
            }
            for (String proto : list) {
                NamedProtocol protocol = this.irpDatabase.getNamedProtocolExpandAlias(proto);
                this.render(protocol);
            }
        }

        private void render(NamedProtocol protocol) throws OddSequenceLengthException, DomainViolationException, IrpInvalidArgumentException, NameUnassignedException, UsageException, InvalidNameException, Protocol.ProtocolNotRenderableException, IrpParseException {
            if (CommandRender.this.nameEngine.isEmpty() && CommandRender.this.random) {
                CommandRender.this.nameEngine = new NameEngine(protocol.randomParameters());
                logger.log(Level.INFO, CommandRender.this.nameEngine.toString());
            }
            if (CommandRender.this.printParameters) {
                this.out.println(CommandRender.this.nameEngine.toString());
            }
            if (!(CommandRender.this.pronto || CommandRender.this.raw || CommandRender.this.rawWithoutSigns || CommandRender.this.printParameters)) {
                logger.warning("No output requested. Use either --raw, --raw-without-signs, --pronto or --printparameters to get output.");
            }
            NameEngine newNameEngine = new NameEngine(CommandRender.this.nameEngine);
            IrSignal irSignal = protocol.render(newNameEngine);
            if (CommandRender.this.count != null) {
                if (CommandRender.this.numberRepeats != null) {
                    throw new UsageException("Can only specify one of --number-repeats and --count.");
                }
                this.renderPrint(irSignal.toModulatedIrSequence(CommandRender.this.count));
            } else if (CommandRender.this.numberRepeats != null) {
                this.renderPrint(irSignal.toModulatedIrSequence(true, CommandRender.this.numberRepeats, true));
            } else {
                if (CommandRender.this.modulate) {
                    throw new UsageException("--modulate is only supported together with --number-repeats or --count.");
                }
                this.renderPrint(irSignal);
            }
            if (CommandRender.this.decode) {
                this.decode(irSignal, protocol.getName());
            }
        }

        private void renderPrint(IrSignal irSignal) {
            if (CommandRender.this.raw) {
                this.out.println(irSignal.toString(true));
            }
            if (CommandRender.this.rawWithoutSigns) {
                this.out.println(irSignal.toString(false));
            }
            if (CommandRender.this.pronto) {
                this.out.println(Pronto.toString(irSignal));
            }
        }

        private void renderPrint(ModulatedIrSequence irSequence) {
            if (CommandRender.this.raw) {
                this.out.println(irSequence.toString(true));
            }
            if (CommandRender.this.rawWithoutSigns) {
                this.out.println(irSequence.toString(false));
            }
            if (CommandRender.this.pronto) {
                this.out.println(Pronto.toString(new IrSignal(irSequence)));
            }
            if (CommandRender.this.modulate) {
                this.out.println(irSequence.modulate().toString(true));
            }
        }

        private void decode(IrSignal irSignal, String name) throws IrpParseException {
            Decoder decoder = new Decoder(this.irpDatabase);
            Decoder.DecoderParameters decoderParams = new Decoder.DecoderParameters();
            decoderParams.setAllDecodes(true);
            decoderParams.setRemoveDefaultedParameters(true);
            Decoder.SimpleDecodesSet decodes = decoder.decodeIrSignal(irSignal, decoderParams);
            Decoder.Decode dec = (Decoder.Decode)decodes.get(name);
            if (dec == null) {
                System.err.println("Decode failed.");
                return;
            }
            Map<String, Long> map = CommandRender.this.nameEngine.toMap();
            dec.getNamedProtocol().removeDefaulteds(map);
            NameEngine reducedNameEngine = new NameEngine(map);
            if (reducedNameEngine.numericallyEquals(dec.getMap())) {
                System.err.println("Decode succeeded!");
            } else {
                System.err.println("Decode failed. Actual decodes:");
                decodes.forEach(decode -> this.out.println(decode));
            }
        }
    }
}

