/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.cmdline;

import java.io.PrintStream;

public class ProgramExitStatus {
    public static final int EXIT_SUCCESS = 0;
    public static final int EXIT_USAGE_ERROR = 1;
    public static final int EXIT_SEMANTIC_USAGE_ERROR = 2;
    public static final int EXIT_FATAL_PROGRAM_FAILURE = 3;
    public static final int EXIT_INTERNAL_FAILURE = 4;
    public static final int EXIT_CONFIG_READ_ERROR = 5;
    public static final int EXIT_CONFIG_WRITE_ERROR = 6;
    public static final int EXIT_IO_ERROR = 7;
    public static final int EXIT_XML_ERROR = 8;
    public static final int EXIT_DYNAMICLINK_ERROR = 9;
    public static final int EXIT_THIS_CANNOT_HAPPEN = 10;
    public static final int EXIT_INTERRUPTED = 11;
    private final int exitStatus;
    private final String message;
    private final String programName;

    private static void doExit(int exitCode) {
        System.exit(exitCode);
    }

    public static void die(String progName, int exitStatus, String message) {
        new ProgramExitStatus(progName, exitStatus, message).die();
    }

    public ProgramExitStatus(String programName, int exitStatus, String message) {
        this.programName = programName;
        this.exitStatus = exitStatus;
        this.message = message;
    }

    public ProgramExitStatus() {
        this(null, 0, null);
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isSuccess() {
        return this.exitStatus == 0;
    }

    public void die() {
        PrintStream stream;
        PrintStream printStream = stream = this.exitStatus == 0 ? System.out : System.err;
        if (this.message != null && !this.message.isEmpty()) {
            stream.println(this.message);
        }
        if (this.exitStatus == 1) {
            stream.println();
            stream.println(this.programName != null ? "Use \"" + this.programName + " help\" or \"" + this.programName + " help --short\"\nfor command syntax." : "Usage error.");
        }
        ProgramExitStatus.doExit(this.exitStatus);
    }
}

