/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.girr;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.harctoolbox.girr.GirrException;
import org.harctoolbox.girr.XmlStatic;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class AdminData
implements Serializable {
    public static final String DATE_FORMATSTRING = "yyyy-MM-dd_HH:mm:ss";
    private String creatingUser = null;
    private String source = null;
    private String creationDate = null;
    private String tool = null;
    private String toolVersion = null;
    private String tool2 = null;
    private String tool2Version = null;
    private Map<String, String> notes = new HashMap<String, String>(4);

    static void setAttributeIfNonNull(Element element, String attributeName, Object object) {
        if (object == null) {
            return;
        }
        String value = object.toString();
        if (value.isEmpty()) {
            return;
        }
        element.setAttribute(attributeName, value);
    }

    static void printIfNonempty(StringBuilder sb, String name, Object object) {
        if (object != null && !object.toString().isEmpty()) {
            sb.append(name).append(": ").append(object.toString()).append("\n");
        }
    }

    AdminData() {
        this((String)null);
    }

    AdminData(String source) {
        this(null, source, null, null, null, null, null, null);
    }

    AdminData(String creatingUser, String source, String creationDate, String tool, String toolVersion, String tool2, String tool2Version, Map<String, String> notes) {
        this.creatingUser = creatingUser;
        this.source = source;
        this.creationDate = creationDate;
        this.tool = tool;
        this.toolVersion = toolVersion;
        this.tool2 = tool2;
        this.tool2Version = tool2Version;
        this.notes = notes != null ? notes : new HashMap(4);
    }

    AdminData(Element element) throws GirrException {
        if (!element.getTagName().equals("adminData")) {
            throw new GirrException("Element not adminData");
        }
        this.notes = XmlStatic.parseElementsByLanguage(element.getElementsByTagName("notes"));
        NodeList nodeList = element.getElementsByTagName("creationData");
        if (nodeList.getLength() > 0) {
            Element creationdata = (Element)nodeList.item(0);
            this.creatingUser = creationdata.getAttribute("creatingUser");
            this.source = creationdata.getAttribute("source");
            this.creationDate = creationdata.getAttribute("creationDate");
            this.tool = creationdata.getAttribute("tool");
            this.toolVersion = creationdata.getAttribute("toolVersion");
            this.tool2 = creationdata.getAttribute("tool2");
            this.tool2Version = creationdata.getAttribute("tool2Version");
        }
    }

    Element toElement(Document doc) {
        Element element = doc.createElementNS("http://www.harctoolbox.org/Girr", "adminData");
        Element creationEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "creationData");
        AdminData.setAttributeIfNonNull(creationEl, "creatingUser", this.creatingUser);
        AdminData.setAttributeIfNonNull(creationEl, "source", this.source);
        AdminData.setAttributeIfNonNull(creationEl, "creationDate", this.creationDate);
        AdminData.setAttributeIfNonNull(creationEl, "tool", this.tool);
        AdminData.setAttributeIfNonNull(creationEl, "toolVersion", this.toolVersion);
        AdminData.setAttributeIfNonNull(creationEl, "tool2", this.tool2);
        AdminData.setAttributeIfNonNull(creationEl, "tool2Version", this.tool2Version);
        if (creationEl.hasChildNodes() || creationEl.hasAttributes()) {
            element.appendChild(creationEl);
        }
        if (this.notes != null) {
            this.notes.entrySet().stream().map(note -> {
                Element notesEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "notes");
                notesEl.setAttribute("xml:lang", (String)note.getKey());
                notesEl.setTextContent((String)note.getValue());
                return notesEl;
            }).forEachOrdered(notesEl -> element.appendChild((Node)notesEl));
        }
        return element;
    }

    public String toFormattedString(String lang) {
        StringBuilder sb = new StringBuilder(256);
        AdminData.printIfNonempty(sb, "creatingUser", this.creatingUser);
        AdminData.printIfNonempty(sb, "source", this.source);
        AdminData.printIfNonempty(sb, "creationDate", this.creationDate);
        AdminData.printIfNonempty(sb, "tool", this.tool);
        AdminData.printIfNonempty(sb, "toolVersion", this.toolVersion);
        AdminData.printIfNonempty(sb, "tool2", this.tool2);
        AdminData.printIfNonempty(sb, "tool2Version", this.tool2Version);
        String note = this.notes.get(lang);
        if (note == null) {
            note = this.notes.get("en");
        }
        AdminData.printIfNonempty(sb, "notes", note);
        int len = sb.length();
        if (len > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String toFormattedString() {
        return this.toFormattedString("en");
    }

    public void setCreationDate(String date) {
        this.creationDate = date != null ? date : new SimpleDateFormat(DATE_FORMATSTRING).format(new Date());
    }

    public void setCreationDate() {
        this.setCreationDate(null);
    }

    public void setCreatingUser(String creator) {
        this.creatingUser = creator != null ? creator : System.getProperty("user.name");
    }

    public void setCreatingUser() {
        this.setCreatingUser(null);
    }

    void merge(AdminData mergee) {
        if (this.creatingUser == null) {
            this.creatingUser = mergee.creatingUser;
        }
        if (this.source == null) {
            this.source = mergee.source;
        }
        if (this.creationDate == null) {
            this.creationDate = mergee.creationDate;
        }
        if (this.tool == null) {
            this.tool = mergee.tool;
        }
        if (this.toolVersion == null) {
            this.toolVersion = mergee.toolVersion;
        }
        if (this.tool2 == null) {
            this.tool2 = mergee.tool2;
        }
        if (this.tool2Version == null) {
            this.tool2Version = mergee.tool2Version;
        }
        mergee.notes.entrySet().forEach(kvp -> {
            String key = (String)kvp.getKey();
            if (!this.notes.containsKey(key)) {
                this.notes.put(key, (String)kvp.getValue());
            }
        });
    }

    public String getNotes() {
        return this.getNotes("en");
    }

    public String getNotes(String language) {
        return this.notes.get(language);
    }

    public void setNotes(String lang, String str) {
        this.notes.put(lang, str);
    }

    public void setNotes(String str) {
        this.notes.put("en", str);
    }

    public String getCreatingUser() {
        return this.creatingUser;
    }

    public String getSource() {
        return this.source;
    }

    public void setSourceIfEmpty(String source) {
        if (this.source == null || this.source.isEmpty()) {
            this.source = source;
        }
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getTool() {
        return this.tool;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public String getTool2() {
        return this.tool2;
    }

    public String getTool2Version() {
        return this.tool2Version;
    }

    public Map<String, String> getAllNotes() {
        return Collections.unmodifiableMap(this.notes);
    }
}

