/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.girr;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.GirrException;
import org.harctoolbox.girr.Named;
import org.harctoolbox.girr.XmlExporter;
import org.harctoolbox.girr.XmlStatic;
import org.harctoolbox.ircore.IrCoreException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.IrpException;
import org.harctoolbox.irp.NameEngine;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class CommandSet
extends XmlExporter
implements Named,
Iterable<Command> {
    private static final Logger logger = Logger.getLogger(CommandSet.class.getName());
    private final Map<String, String> notes;
    private String protocolName;
    private final String name;
    private final Map<String, Long> parameters;
    private final Map<String, Command> commands;

    public CommandSet(String file) throws GirrException, IOException, SAXException {
        this(CommandSet.getElement(file));
    }

    public CommandSet(Reader reader) throws IOException, SAXException, GirrException {
        this(CommandSet.getElement(reader));
    }

    public CommandSet(Document doc) throws GirrException {
        this(CommandSet.getElement(doc));
    }

    public CommandSet(Element element) throws GirrException {
        if (!element.getTagName().equals("commandSet")) {
            throw new GirrException("Element is not of type commandSet");
        }
        this.name = element.getAttribute("name");
        this.protocolName = null;
        this.commands = new LinkedHashMap<String, Command>(4);
        this.parameters = new LinkedHashMap<String, Long>(4);
        this.notes = XmlStatic.parseElementsByLanguage(element.getElementsByTagName("notes"));
        NodeList nl = element.getChildNodes();
        for (int nodeNr = 0; nodeNr < nl.getLength(); ++nodeNr) {
            Element el;
            if (nl.item(nodeNr).getNodeType() != 1 || !(el = (Element)nl.item(nodeNr)).getTagName().equals("parameters")) continue;
            String newProtocol = el.getAttribute("protocol");
            if (!newProtocol.isEmpty()) {
                this.protocolName = newProtocol;
            }
            NodeList paramList = el.getElementsByTagName("parameter");
            for (int i = 0; i < paramList.getLength(); ++i) {
                Element e = (Element)paramList.item(i);
                try {
                    this.parameters.put(e.getAttribute("name"), IrCoreUtils.parseLong(e.getAttribute("value")));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new GirrException(ex);
                }
            }
        }
        nl = element.getElementsByTagName("command");
        for (int i = 0; i < nl.getLength(); ++i) {
            try {
                Command irCommand = new Command((Element)nl.item(i), this.protocolName, this.parameters);
                this.commands.put(irCommand.getName(), irCommand);
                continue;
            }
            catch (GirrException ex) {
                String cmdName = ((Element)nl.item(i)).getAttribute("name");
                logger.log(Level.WARNING, "Command {0}: {1}", new Object[]{cmdName, ex.getMessage()});
            }
        }
    }

    public CommandSet(String name, Map<String, String> notes, Map<String, Command> commands, String protocolName, Map<String, Long> parameters) {
        this.name = name != null ? name : "commandSet";
        this.notes = notes != null ? notes : new HashMap(0);
        this.commands = commands;
        this.protocolName = protocolName;
        this.parameters = parameters != null ? new LinkedHashMap<String, Long>(parameters) : new LinkedHashMap(4);
    }

    public CommandSet(Command command) {
        this(command.getName(), null, Named.toMap(command), null, null);
    }

    public CommandSet() {
        this(new Command());
    }

    public Collection<Command> getCommands() {
        return Collections.unmodifiableCollection(this.commands.values());
    }

    public int getNumberOfCommand() {
        return this.commands.size();
    }

    public Command getCommand(String commandName) {
        return this.commands.get(commandName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.name).append(": ");
        if (this.protocolName != null && !this.protocolName.isEmpty()) {
            sb.append("protocol").append("=").append(this.protocolName).append(" ");
            sb.append(" ").append(new NameEngine(this.parameters));
        }
        sb.append(" (").append(Integer.toString(this.size())).append(" commands)");
        return sb.toString();
    }

    public int size() {
        return this.commands.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<Command> iterator() {
        return this.commands.values().iterator();
    }

    public void sort(Comparator<? super Named> comparator) {
        ArrayList<Command> list = new ArrayList<Command>(this.commands.values());
        Collections.sort(list, comparator);
        Named.populateMap(this.commands, list);
    }

    public void sort() {
        this.sort(new Named.CompareNameCaseSensitive());
    }

    public void sortIgnoringCase() {
        this.sort(new Named.CompareNameCaseInsensitive());
    }

    public void generateInheritanceParameters() {
        Command firstCommand = this.iterator().next();
        if (firstCommand != null && firstCommand.getMasterType() == Command.MasterType.parameters) {
            try {
                firstCommand.checkForParameters();
                this.protocolName = firstCommand.getProtocolName();
                for (Map.Entry<String, Long> kvp : firstCommand.getParameters().entrySet()) {
                    String parameterName = kvp.getKey();
                    if (parameterName.equals("F")) continue;
                    this.parameters.put(parameterName, kvp.getValue());
                }
            }
            catch (IrCoreException | IrpException ex) {
                logger.log(Level.WARNING, "Cannot generate inheritance parameters");
            }
        }
    }

    public void deleteInheritanceParameters() {
        this.protocolName = null;
        this.parameters.clear();
    }

    @Override
    Element toElement(Document doc, boolean fatRaw, boolean generateParameters, boolean generateProntoHex, boolean generateRaw) {
        if (Command.isUseInheritanceForXml()) {
            this.generateInheritanceParameters();
        }
        Element element = doc.createElementNS("http://www.harctoolbox.org/Girr", "commandSet");
        element.setAttribute("name", this.name);
        this.notes.entrySet().stream().map(note -> {
            Element notesEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "notes");
            notesEl.setAttribute("xml:lang", (String)note.getKey());
            notesEl.setTextContent((String)note.getValue());
            return notesEl;
        }).forEachOrdered(notesEl -> element.appendChild((Node)notesEl));
        if (this.shouldDoParameters(generateParameters, generateProntoHex, generateRaw)) {
            Element parametersEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "parameters");
            parametersEl.setAttribute("protocol", this.protocolName);
            element.appendChild(parametersEl);
            this.parameters.entrySet().stream().map(parameter -> {
                Element parameterEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "parameter");
                parameterEl.setAttribute("name", (String)parameter.getKey());
                parameterEl.setAttribute("value", ((Long)parameter.getValue()).toString());
                return parameterEl;
            }).forEachOrdered(parameterEl -> parametersEl.appendChild((Node)parameterEl));
        }
        if (this.commands != null) {
            this.commands.values().forEach(command -> element.appendChild(command.toElement(doc, fatRaw, generateParameters, generateProntoHex, generateRaw, this.protocolName, this.parameters)));
        }
        return element;
    }

    private boolean shouldDoParameters(boolean generateParameters, boolean generateProntoHex, boolean generateRaw) {
        return this.parameters != null && !this.parameters.isEmpty() && (generateParameters || this.firstCommandMasterParameters(generateParameters, generateProntoHex, generateRaw));
    }

    private boolean firstCommandMasterParameters(boolean generateParameters, boolean generateProntoHex, boolean generateRaw) {
        Command command = this.commands.values().iterator().next();
        return command != null && command.actualMasterType(generateParameters, generateProntoHex, generateRaw) == Command.MasterType.parameters;
    }

    public void addFormat(Command.CommandTextFormat format, int repeatCount) {
        this.commands.values().forEach(command -> {
            try {
                command.addFormat(format, repeatCount);
            }
            catch (IrCoreException | IrpException ex) {
                logger.log(Level.WARNING, null, ex);
            }
        });
    }

    public void strip() {
        for (Command command : this) {
            command.strip();
        }
    }
}

