/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.girr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface Named
extends Serializable {
    public static <T extends Named> Map<String, T> toMap(T thing) {
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>(1);
        map.put(thing.getName(), thing);
        return map;
    }

    public static <T extends Named> List<T> toList(T thing) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(thing);
        return list;
    }

    public static <T extends Named> void populateMap(Map<String, T> map, Collection<T> collection) {
        map.clear();
        collection.forEach(thing -> map.put(thing.getName(), thing));
    }

    public static <T extends Named> Map<String, T> toMap(Collection<T> collection) {
        LinkedHashMap map = new LinkedHashMap(collection.size());
        Named.populateMap(map, collection);
        return map;
    }

    public String getName();

    public static class CompareNameCaseInsensitive
    implements Comparator<Named>,
    Serializable {
        @Override
        public int compare(Named o1, Named o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    public static class CompareNameCaseSensitive
    implements Comparator<Named>,
    Serializable {
        @Override
        public int compare(Named o1, Named o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

