/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.girr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.validation.Schema;
import org.harctoolbox.girr.AdminData;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.CommandSet;
import org.harctoolbox.girr.GirrException;
import org.harctoolbox.girr.Named;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.XmlExporter;
import org.harctoolbox.girr.XmlStatic;
import org.harctoolbox.ircore.IrCoreException;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpException;
import org.harctoolbox.irp.IrpParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class RemoteSet
extends XmlExporter
implements Iterable<Remote> {
    private static final Logger logger = Logger.getLogger(RemoteSet.class.getName());
    private static final int INITIAL_LIST_CAPACITY = 8;
    private final AdminData adminData;
    private final Map<String, Remote> remotes;
    private final IrpDatabase irpDatabase;

    public static void main(String[] args) {
        try {
            Command.setIrpDatabase(new IrpDatabase());
            RemoteSet remoteSet = RemoteSet.parse(new File(args[0]), XmlStatic.girrSchema());
            if (!remoteSet.isEmpty()) {
                remoteSet.print(args.length > 1 ? args[1] : "-");
            }
        }
        catch (IOException | GirrException | IrpParseException | SAXException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public static Collection<RemoteSet> parseAsCollection(File file, Schema schema) {
        ArrayList<RemoteSet> coll = new ArrayList<RemoteSet>(8);
        if (file.isFile() && !RemoteSet.ignoreByExtension(file.getName())) {
            try {
                RemoteSet remoteSet = RemoteSet.parse(RemoteSet.getElement(file, schema), file.toString());
                coll.add(remoteSet);
            }
            catch (SAXParseException ex) {
                logger.log(Level.WARNING, "Could not read file {0}: {1}", new Object[]{file.toString(), ex.getMessage()});
            }
            catch (IOException | GirrException | SAXException ex) {
                logger.log(Level.WARNING, "Could not read file {0}", file.toString());
            }
        } else if (file.isDirectory()) {
            Object[] files = file.listFiles();
            if (files == null) {
                logger.log(Level.WARNING, "Could not read directory {0}", file.toString());
                return null;
            }
            Arrays.sort(files);
            for (Object f : files) {
                Collection<RemoteSet> c = RemoteSet.parseAsCollection((File)f, schema);
                if (c == null) continue;
                coll.addAll(c);
            }
        }
        return coll;
    }

    public static Collection<RemoteSet> parseAsCollection(File file) {
        return RemoteSet.parseAsCollection(file, null);
    }

    public static RemoteSet parse(File file, Schema schema) throws GirrException, IOException, SAXException {
        Collection<RemoteSet> collection = RemoteSet.parseAsCollection(file, schema);
        return new RemoteSet(null, file.toString(), collection);
    }

    public static RemoteSet parse(File file) throws GirrException, IOException, SAXException {
        return RemoteSet.parse(file, null);
    }

    public static RemoteSet parse(String file, Schema schema) throws IOException, SAXException, GirrException {
        return RemoteSet.parse(RemoteSet.getElement(file, schema), file);
    }

    public static RemoteSet parse(String file) throws IOException, SAXException, GirrException {
        return RemoteSet.parse(RemoteSet.getElement(file, null), file);
    }

    public static RemoteSet parse(Element element, String source) throws GirrException {
        switch (element.getTagName()) {
            case "remotes": {
                return new RemoteSet(element, source);
            }
            case "remote": {
                Remote remote = new Remote(element, source);
                return new RemoteSet(remote);
            }
            case "commandSet": {
                CommandSet commandSet = new CommandSet(element);
                return new RemoteSet(commandSet, source);
            }
            case "command": {
                Command command = new Command(element);
                return new RemoteSet(command, source);
            }
        }
        throw new GirrException("Unsupported root element type");
    }

    private static boolean ignoreByExtension(String path) {
        int index = path.lastIndexOf(46);
        if (index == -1) {
            return false;
        }
        String extension = path.substring(index + 1);
        return extension.equals("jpg") || extension.equals("jpeg") || extension.equals("pdf");
    }

    public static RemoteSet pmud(InputStream inputStream) throws IOException, ClassNotFoundException {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);){
            RemoteSet remoteSet = (RemoteSet)objectInputStream.readObject();
            return remoteSet;
        }
    }

    public static RemoteSet pmud(File file) throws IOException, ClassNotFoundException {
        return RemoteSet.pmud(new FileInputStream(file));
    }

    public static RemoteSet pmud(String thing) throws IOException, ClassNotFoundException {
        return RemoteSet.pmud(new File(thing));
    }

    private static IrpDatabase mkIrpDatabase(Element element) {
        try {
            return new IrpDatabase(element);
        }
        catch (IrpParseException ex) {
            logger.log(Level.WARNING, ex.getLocalizedMessage());
            return new IrpDatabase();
        }
    }

    public RemoteSet(String creatingUser, File file) {
        this(creatingUser, file.toString(), RemoteSet.parseAsCollection(file, null));
    }

    public RemoteSet(String creatingUser, String source, Collection<RemoteSet> remoteSets) {
        this(creatingUser, source, null, "Girr", "Girr version 2.2.14", null, null);
        for (RemoteSet remoteSet : remoteSets) {
            this.irpDatabase.patch(remoteSet.getIrpDatabase());
            for (Remote remote : remoteSet) {
                String originalName;
                String name = originalName = remote.getName();
                int i = 0;
                while (this.remotes.containsKey(name)) {
                    name = originalName + "_" + Integer.toString(++i);
                    remote.setName(name);
                    remote.setComment("Name changed from \"" + originalName + "\" to \"" + name + "\".");
                }
                remote.getAdminData().merge(remoteSet.getAdminData());
                this.remotes.put(name, remote);
            }
        }
    }

    public RemoteSet(Document doc) throws GirrException {
        this(doc.getDocumentElement(), null);
    }

    public RemoteSet(Element root, String source) throws GirrException {
        if (!root.getTagName().equals("remotes")) {
            throw new GirrException("Root element not of type \"remotes\".");
        }
        NodeList nl = root.getElementsByTagName("adminData");
        this.adminData = nl.getLength() > 0 ? new AdminData((Element)nl.item(0)) : new AdminData();
        this.adminData.setSourceIfEmpty(source);
        this.remotes = new LinkedHashMap<String, Remote>(4);
        nl = root.getElementsByTagName("remote");
        for (int i = 0; i < nl.getLength(); ++i) {
            Remote remote = new Remote((Element)nl.item(i), source);
            this.remotes.put(remote.getName(), remote);
        }
        nl = root.getElementsByTagName("irp:protocols");
        if (nl.getLength() > 0) {
            Element protocolsElement = (Element)nl.item(0);
            this.irpDatabase = RemoteSet.mkIrpDatabase(protocolsElement);
        } else {
            this.irpDatabase = new IrpDatabase();
        }
    }

    public RemoteSet(File file) throws GirrException, IOException, SAXException {
        this(RemoteSet.getElement(file, null), file.toString());
    }

    public RemoteSet(String file) throws GirrException, IOException, SAXException {
        this(RemoteSet.getElement(file), file);
    }

    public RemoteSet(Reader reader, Schema schema) throws IOException, SAXException, GirrException {
        this(RemoteSet.getElement(reader, schema), null);
    }

    public RemoteSet(String creatingUser, String source, String creationDate, String tool, String toolVersion, String tool2, String tool2Version, Map<String, String> notes, Map<String, Remote> remotes) {
        this(new AdminData(creatingUser, source, creationDate, tool, toolVersion, tool2, tool2Version, notes), remotes);
    }

    public RemoteSet(String creatingUser, String source, String creationDate, String tool, String toolVersion, String tool2, String tool2Version) {
        this(new AdminData(creatingUser, source, null, tool, toolVersion, tool2, tool2Version, null), null);
    }

    RemoteSet(AdminData adminData, Map<String, Remote> remotes) {
        this.adminData = adminData;
        this.remotes = remotes != null ? remotes : new LinkedHashMap(1);
        this.irpDatabase = new IrpDatabase();
    }

    public RemoteSet() {
        this(new AdminData(), null);
    }

    public RemoteSet(String creatingUser, String source, String creationDate, String tool, String toolVersion, String tool2, String tool2Version, Map<String, String> notes, Remote remote) {
        this(new AdminData(creatingUser, source, creationDate, tool, toolVersion, tool2, tool2Version, notes), null);
        this.remotes.put(remote.getName(), remote);
    }

    public RemoteSet(String creatingUser, String source, Remote remote) {
        this(creatingUser, source, null, "Girr", "Girr version 2.2.14", "IrpTransmogrifier", "1.2.14", new HashMap<String, String>(0), remote);
    }

    public RemoteSet(String creatingUser, String source, Map<String, Remote> remotes) {
        this(creatingUser, source, null, "Girr", "Girr version 2.2.14", "IrpTransmogrifier", "1.2.14", null, remotes);
    }

    public RemoteSet(String source, String creatingUser, IrSignal irSignal, String name, String comment, String deviceName) {
        this(creatingUser, source, new Remote(irSignal, name, comment, deviceName));
    }

    public RemoteSet(Remote remote) {
        this(remote.getAdminData(), Named.toMap(remote));
    }

    private RemoteSet(CommandSet commandSet, String source) {
        this(new AdminData(source), Named.toMap(new Remote(commandSet)));
    }

    private RemoteSet(Command command, String source) {
        this(new CommandSet(command), source);
    }

    public void setCreationDate(String date) {
        this.adminData.setCreationDate(date);
    }

    public void setCreationDate() {
        this.adminData.setCreationDate();
    }

    public void sort(Comparator<? super Named> comparator, boolean recurse) {
        ArrayList<Remote> list = new ArrayList<Remote>(this.remotes.values());
        Collections.sort(list, comparator);
        this.remotes.clear();
        list.forEach(remote -> {
            if (recurse) {
                remote.sort(comparator);
            }
            this.remotes.put(remote.getName(), (Remote)remote);
        });
    }

    public void sort(boolean recurse) {
        this.sort(new Named.CompareNameCaseInsensitive(), recurse);
    }

    public boolean isEmpty() {
        return this.remotes.isEmpty();
    }

    public void append(RemoteSet remoteSet) {
        this.remotes.putAll(remoteSet.remotes);
    }

    @Override
    public Element toElement(Document doc, boolean fatRaw, boolean generateParameters, boolean generateProntoHex, boolean generateRaw) {
        Element element = doc.createElementNS("http://www.harctoolbox.org/Girr", "remotes");
        Element adminDataEl = this.adminData.toElement(doc);
        if (adminDataEl.hasChildNodes() || adminDataEl.hasAttributes()) {
            element.appendChild(adminDataEl);
        }
        if (!this.irpDatabase.isEmpty()) {
            element.appendChild(this.irpDatabase.toElement(doc));
        }
        for (Remote remote : this) {
            element.appendChild(remote.toElement(doc, fatRaw, generateParameters, generateProntoHex, generateRaw));
        }
        return element;
    }

    public void addFormat(Command.CommandTextFormat format, int repeatCount) {
        for (Remote remote : this) {
            remote.addFormat(format, repeatCount);
        }
    }

    public Collection<Command> getCommands() {
        ArrayList<Command> allCommands = new ArrayList<Command>(32);
        for (Remote remote : this) {
            allCommands.addAll(remote.getCommands());
        }
        return allCommands;
    }

    public List<Command> getCommand(String name) {
        ArrayList<Command> list = new ArrayList<Command>(this.remotes.size());
        for (Remote remote : this) {
            list.addAll(remote.getCommand(name));
        }
        return list;
    }

    public Command getCommand(String remote, String commandSet, String command) {
        return this.getRemote(remote).getCommand(commandSet, remote);
    }

    public int getNumberOfCommands() {
        int sum = 0;
        for (Remote remote : this) {
            sum += remote.getNumberOfCommands();
        }
        return sum;
    }

    public void checkForParameters() throws IrpException, IrCoreException {
        for (Remote remote : this) {
            remote.checkForParameters();
        }
    }

    AdminData getAdminData() {
        return this.adminData;
    }

    public String getCreatingUser() {
        return this.adminData.getCreatingUser();
    }

    public String getSource() {
        return this.adminData.getSource();
    }

    public String getCreationDate() {
        return this.adminData.getCreationDate();
    }

    public String getTool() {
        return this.adminData.getTool();
    }

    public String getToolVersion() {
        return this.adminData.getToolVersion();
    }

    public String getTool2() {
        return this.adminData.getTool2();
    }

    public String getTool2Version() {
        return this.adminData.getTool2Version();
    }

    public String getNotes(String lang) {
        return this.adminData.getNotes(lang);
    }

    public Collection<Remote> getRemotes() {
        return Collections.unmodifiableCollection(this.remotes.values());
    }

    public Remote getRemote(String name) {
        return this.remotes.get(name);
    }

    @Override
    public Iterator<Remote> iterator() {
        return this.remotes.values().iterator();
    }

    public IrpDatabase getIrpDatabase() {
        return this.irpDatabase;
    }

    public int size() {
        return this.remotes.size();
    }

    public void strip() {
        for (Remote remote : this) {
            remote.strip();
        }
    }

    public void dump(OutputStream outputStream) throws IOException {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);){
            objectOutputStream.writeObject(this);
        }
    }

    public void dump(File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.dump(fileOutputStream);
        }
    }
}

