/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.girr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.xml.validation.Schema;
import org.harctoolbox.girr.XmlStatic;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class XmlExporter
implements Serializable {
    private static final boolean IS_NAMESPACE_AWARE = true;
    private static final boolean IS_XINCLUDE_AWARE = true;

    protected static Element getElement(File file, Schema schema) throws IOException, SAXException {
        return XmlExporter.getElement(XmlUtils.openXmlFile(file, schema, true, true));
    }

    protected static Element getElement(File file) throws IOException, SAXException {
        return XmlExporter.getElement(file, null);
    }

    protected static Element getElement(String file, Schema schema) throws IOException, SAXException {
        return XmlExporter.getElement(XmlUtils.openXmlThing(file, schema, true, true));
    }

    protected static Element getElement(String file) throws IOException, SAXException {
        return XmlExporter.getElement(file, null);
    }

    protected static Element getElement(Reader reader, Schema schema) throws IOException, SAXException {
        return XmlExporter.getElement(XmlUtils.openXmlReader(reader, schema, true, true));
    }

    protected static Element getElement(Reader reader) throws IOException, SAXException {
        return XmlExporter.getElement(reader, null);
    }

    protected static Element getElement(Document document) {
        return document.getDocumentElement();
    }

    protected XmlExporter() {
    }

    public final void print(OutputStream ostr, boolean generateProtocol, boolean generateProntoHex, boolean generateRaw) {
        Document doc = this.toDocument(null, false, generateProtocol, generateProntoHex, generateRaw);
        try {
            XmlUtils.printDOM(ostr, doc, "UTF-8", null);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    public final void print(String file, boolean generateProtocol, boolean generateProntoHex, boolean generateRaw) throws IOException {
        this.print(IrCoreUtils.getPrintStream(file, "UTF-8"), generateProtocol, generateProntoHex, generateRaw);
    }

    public final void print(String file) throws IOException {
        this.print(file, true, true, true);
    }

    public final void print(File file, boolean generateProtocol, boolean generateProntoHex, boolean generateRaw) throws IOException {
        this.print(new FileOutputStream(file), generateProtocol, generateProntoHex, generateRaw);
    }

    public final void print(File file) throws IOException {
        this.print(file, true, true, true);
    }

    public final Document toDocument(String title, boolean fatRaw, boolean generateParameters, boolean generateProntoHex, boolean generateRaw) {
        Element root = this.toElement(XmlUtils.newDocument(true), fatRaw, generateParameters, generateProntoHex, generateRaw);
        return XmlStatic.createDocument(title, root);
    }

    abstract Element toElement(Document var1, boolean var2, boolean var3, boolean var4, boolean var5);
}

