/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.girr;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.validation.Schema;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public abstract class XmlStatic {
    public static final String GIRR_VERSION = "1.2";
    public static final String GIRR_NAMESPACE = "http://www.harctoolbox.org/Girr";
    public static final String GIRR_HOMEPAGE = "http://www.harctoolbox.org/Girr.html";
    public static final String GIRR_SCHEMA_LOCATION_URI = "http://www.harctoolbox.org/schemas/girr_ns-1.2.xsd";
    public static final String GIRR_NONAMESPACE_SCHEMA_LOCATION_URI = "http://www.harctoolbox.org/schemas/girr.xsd";
    public static final String GIRR_SCHEMA_LOCATION_JAR = "/girr_ns-1.2.xsd";
    public static final String GIRR_COMMENT = "This file is in the Girr (General IR Remote) format, see http://www.harctoolbox.org/Girr.html";
    public static final String GIRR_VERSION_ATTRIBUTE_NAME = "girrVersion";
    public static final String TOGGLE_ATTRIBUTE_NAME = "T";
    public static final String F_ATTRIBUTE_NAME = "F";
    public static final String VALUE_ATTRIBUTE_NAME = "value";
    public static final String NAME_ATTRIBUTE_NAME = "name";
    public static final String COMMENT_ATTRIBUTE_NAME = "comment";
    public static final String MASTER_ATTRIBUTE_NAME = "master";
    public static final String FREQUENCY_ATTRIBUTE_NAME = "frequency";
    public static final String DUTYCYCLE_ATTRIBUTE_NAME = "dutyCycle";
    public static final String TITLE_ATTRIBUTE_NAME = "title";
    public static final String PROTOCOL_ATTRIBUTE_NAME = "protocol";
    public static final String DISPLAYNAME_ATTRIBUTE_NAME = "displayName";
    public static final String MANUFACTURER_ATTRIBUTE_NAME = "manufacturer";
    public static final String APPLICATION_ATTRIBUTE_NAME = "application";
    public static final String MODEL_ATTRIBUTE_NAME = "model";
    public static final String DEVICECLASS_ATTRIBUTE_NAME = "deviceClass";
    public static final String REMOTENAME_ATTRIBUTE_NAME = "remoteName";
    public static final String CREATINGUSER_ATTRIBUTE_NAME = "creatingUser";
    public static final String SOURCE_ATTRIBUTE_NAME = "source";
    public static final String CREATIONDATE_ATTRIBUTE_NAME = "creationDate";
    public static final String TOOL_ATTRIBUTE_NAME = "tool";
    public static final String TOOLVERSIION_ATTRIBUTE_NAME = "toolVersion";
    public static final String TOOL2_ATTRIBUTE_NAME = "tool2";
    public static final String TOOL2VERSION_ATTRIBUTE_NAME = "tool2Version";
    public static final String PRONTO_HEX_ELEMENT_NAME = "ccf";
    public static final String FLASH_ELEMENT_NAME = "flash";
    public static final String GAP_ELEMENT_NAME = "gap";
    public static final String PARAMETER_ELEMENT_NAME = "parameter";
    public static final String NOTES_ELEMENT_NAME = "notes";
    public static final String PARAMETERS_ELEMENT_NAME = "parameters";
    public static final String PROTOCOL_ELEMENT_NAME = "protocol";
    public static final String RAW_ELEMENT_NAME = "raw";
    public static final String INTRO_ELEMENT_NAME = "intro";
    public static final String REPEAT_ELEMENT_NAME = "repeat";
    public static final String ENDING_ELEMENT_NAME = "ending";
    public static final String FORMAT_ELEMENT_NAME = "format";
    public static final String COMMAND_ELEMENT_NAME = "command";
    public static final String COMMANDSET_ELEMENT_NAME = "commandSet";
    public static final String APPLICATIONDATA_ELEMENT_NAME = "applicationData";
    public static final String APPPARAMETER_ELEMENT_NAME = "appParameter";
    public static final String REMOTE_ELEMENT_NAME = "remote";
    public static final String ADMINDATA_ELEMENT_NAME = "adminData";
    public static final String CREATIONDATA_ELEMENT_NAME = "creationData";
    public static final String REMOTES_ELEMENT_NAME = "remotes";
    public static final String SPACE = " ";
    public static final String EQUALS = "=";
    private static String stylesheetType = null;
    private static String stylesheetUrl = null;

    public static void setStylesheetType(String aStylesheetType) {
        stylesheetType = aStylesheetType;
    }

    public static void setStylesheetUrl(String aStylesheetUrl) {
        stylesheetUrl = aStylesheetUrl;
    }

    static Document createDocument(String title, Element root) {
        Document document = root.getOwnerDocument();
        if (stylesheetType != null && !stylesheetType.isEmpty() && stylesheetUrl != null && !stylesheetUrl.isEmpty()) {
            ProcessingInstruction pi = document.createProcessingInstruction("xml-stylesheet", "type=\"text/" + stylesheetType + "\" href=\"" + stylesheetUrl + "\"");
            document.appendChild(pi);
        }
        Comment comment = document.createComment(GIRR_COMMENT);
        document.appendChild(comment);
        document.appendChild(root);
        root.setAttribute(GIRR_VERSION_ATTRIBUTE_NAME, GIRR_VERSION);
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xmlns", GIRR_NAMESPACE);
        root.setAttribute("xmlns:html", "http://www.w3.org/1999/xhtml");
        root.setAttribute("xsi:schemaLocation", "http://www.harctoolbox.org/Girr http://www.harctoolbox.org/schemas/girr_ns-1.2.xsd");
        if (title != null && !title.isEmpty()) {
            root.setAttribute(TITLE_ATTRIBUTE_NAME, title);
        }
        return document;
    }

    static Map<String, String> parseElementsByLanguage(NodeList nodeList) {
        HashMap<String, String> map = new HashMap<String, String>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element note = (Element)nodeList.item(i);
            String lang = note.getAttribute("xml:lang");
            if (lang.isEmpty()) {
                lang = "en";
            }
            map.put(lang, note.getTextContent().trim());
        }
        return map;
    }

    static Schema girrSchema() throws SAXException {
        InputStream stream = XmlStatic.class.getResourceAsStream(GIRR_SCHEMA_LOCATION_JAR);
        return XmlUtils.readSchema(stream);
    }

    private XmlStatic() {
    }
}

