/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.ircore;

import java.util.ArrayList;
import java.util.List;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.OddSequenceLengthException;

public abstract class AbstractIrParser {
    private final String source;

    protected static String fixIrRemoteSilliness(String str) {
        return str.replaceAll("\\+\\s+", "+").replaceAll("-\\s+", "-");
    }

    protected static IrSignal mkIrSignal(List<IrSequence> list, Double frequency) throws OddSequenceLengthException {
        return !list.isEmpty() && list.size() <= 3 ? new IrSignal(list.get(0), list.size() > 1 ? list.get(1) : null, list.size() > 2 ? list.get(2) : null, frequency, null) : null;
    }

    protected static IrSignal mkIrSignal(String[] codes, Double fallbackFrequency, Double dummyGap) throws OddSequenceLengthException {
        if (codes.length == 0 || codes.length > 3) {
            return null;
        }
        IrSequence intro = new IrSequence(codes[0], dummyGap);
        IrSequence repeat = codes.length > 1 ? new IrSequence(codes[1], dummyGap) : null;
        IrSequence ending = codes.length > 2 ? new IrSequence(codes[2], dummyGap) : null;
        return new IrSignal(intro, repeat, ending, fallbackFrequency);
    }

    public AbstractIrParser(String source) {
        this.source = source.trim();
    }

    public AbstractIrParser(Iterable<? extends CharSequence> args) {
        this(String.join((CharSequence)" ", args));
    }

    public final String toString() {
        return this.source;
    }

    public List<IrSequence> toListChop(double threshold, Double dummyGap) throws OddSequenceLengthException, InvalidArgumentException {
        return this.toIrSequence(dummyGap).chop(threshold);
    }

    public final List<IrSequence> toListChop(double threshold) throws OddSequenceLengthException, InvalidArgumentException {
        return this.toListChop(threshold, null);
    }

    public List<IrSequence> toList(Double dummyGap) throws OddSequenceLengthException, InvalidArgumentException {
        return null;
    }

    protected final List<IrSequence> toList(String[] parts, Double dummyGap) throws OddSequenceLengthException {
        ArrayList<IrSequence> result = new ArrayList<IrSequence>(parts.length);
        for (String s : parts) {
            try {
                result.add(new IrSequence(s, dummyGap));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public final List<IrSequence> toList() throws OddSequenceLengthException, InvalidArgumentException {
        return this.toList(null);
    }

    public ModulatedIrSequence toModulatedIrSequence(Double fallbackFrequency, Double dummyGap) throws InvalidArgumentException {
        try {
            IrSignal irSignal = this.toIrSignal(fallbackFrequency, dummyGap);
            if (irSignal != null) {
                return irSignal.toModulatedIrSequence();
            }
        }
        catch (NumberFormatException | InvalidArgumentException exception) {
            // empty catch block
        }
        return null;
    }

    public final ModulatedIrSequence toModulatedIrSequence(Double fallbackFrequency) throws OddSequenceLengthException, InvalidArgumentException {
        return this.toModulatedIrSequence(fallbackFrequency, null);
    }

    public final ModulatedIrSequence toModulatedIrSequence() throws OddSequenceLengthException, InvalidArgumentException {
        return this.toModulatedIrSequence(null);
    }

    protected final String getSource() {
        return this.source;
    }

    public final IrSequence toIrSequence() throws OddSequenceLengthException, InvalidArgumentException {
        return this.toIrSequence(null);
    }

    public IrSequence toIrSequence(Double dummyGap) throws OddSequenceLengthException, InvalidArgumentException {
        return new IrSequence(this.source, dummyGap);
    }

    public final IrSignal toIrSignal() throws OddSequenceLengthException, InvalidArgumentException {
        return this.toIrSignal(null);
    }

    public final IrSignal toIrSignal(Double fallbackFrequency) throws OddSequenceLengthException, InvalidArgumentException, NumberFormatException {
        return this.toIrSignal(fallbackFrequency, null);
    }

    public abstract IrSignal toIrSignal(Double var1, Double var2) throws OddSequenceLengthException, InvalidArgumentException, NumberFormatException;

    public IrSignal toIrSignalChop(Double fallbackFrequency, double threshold) throws OddSequenceLengthException, InvalidArgumentException {
        List<IrSequence> list = this.toListChop(threshold);
        return AbstractIrParser.mkIrSignal(list, fallbackFrequency);
    }
}

