/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.ircore;

import java.util.List;
import org.harctoolbox.ircore.AbstractIrParser;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.IrSignalParser;
import org.harctoolbox.ircore.OddSequenceLengthException;

public class BracketedIrSignalParser
extends AbstractIrParser
implements IrSignalParser {
    private static String[] splitBracketed(String str) {
        String[] stringArray;
        if (str.startsWith("[")) {
            stringArray = str.replace("[", "").split("\\]");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = str;
        }
        return stringArray;
    }

    public BracketedIrSignalParser(String source) {
        super(BracketedIrSignalParser.fixIrRemoteSilliness(source));
    }

    public BracketedIrSignalParser(Iterable<? extends CharSequence> args) {
        this(String.join((CharSequence)" ", args));
    }

    @Override
    public IrSignal toIrSignal(Double fallbackFrequency, Double dummyGap) throws OddSequenceLengthException {
        String s = this.getSource();
        Double readFrequency = null;
        if (s.startsWith("Freq=")) {
            int pos = s.indexOf(72, 6);
            if (pos != -1) {
                try {
                    readFrequency = Double.valueOf(s.substring(5, pos));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                s = s.substring(pos + 2).trim();
            } else {
                pos = s.indexOf(91, 6);
                if (pos != -1) {
                    try {
                        readFrequency = Double.valueOf(s.substring(5, pos));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    s = s.substring(pos).trim();
                }
            }
        }
        if (!s.startsWith("[")) {
            return null;
        }
        try {
            return BracketedIrSignalParser.mkIrSignal(BracketedIrSignalParser.splitBracketed(s), readFrequency != null ? readFrequency : fallbackFrequency, dummyGap);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public List<IrSequence> toList(Double dummyGap) throws OddSequenceLengthException {
        return this.toList(BracketedIrSignalParser.splitBracketed(this.getSource()), dummyGap);
    }

    @Override
    public String getName() {
        return "BracketedIrSignal";
    }
}

