/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.ircore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.harctoolbox.ircore.ThisCannotHappenException;

public final class IrCoreUtils {
    public static final long INVALID = -1L;
    public static final long ALL = -2L;
    public static final long SOME = -3L;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Map<Integer, String> radixPrefixes;
    private static Map<String, Integer> prefixToRadix;
    public static final double DEFAULT_ABSOLUTE_TOLERANCE = 100.0;
    public static final double DEFAULT_RELATIVE_TOLERANCE = 0.3;
    public static final double DEFAULT_FREQUENCY_TOLERANCE = 2000.0;
    public static final double DEFAULT_DUTYCYCLE_TOLERANCE = 0.3;
    public static final double DEFAULT_MINIMUM_LEADOUT = 20000.0;
    public static final double DEFAULT_MIN_REPEAT_LAST_GAP = 5000.0;
    public static final String DUMB_CHARSET_NAME = "US-ASCII";
    public static final Charset DUMB_CHARSET;
    public static final String EXTENDED_LATIN1_NAME = "WINDOWS-1252";
    public static final Charset EXTENDED_LATIN1;
    public static final String UTF8_NAME = "UTF-8";
    public static final Charset UTF8;
    public static final String WHITESPACE = "\\s+";
    public static final String LINEFEED = "\n";

    public static void setRadixPrefixes(Map<String, Integer> map) {
        prefixToRadix = map;
        radixPrefixes = new HashMap<Integer, String>(map.size());
        map.entrySet().forEach(kvp -> radixPrefixes.putIfAbsent((Integer)kvp.getValue(), (String)kvp.getKey()));
    }

    private static double getDoubleWithSubstitute(Double userValue, double fallback) {
        return userValue != null ? userValue : fallback;
    }

    public static double getRelativeTolerance(Double userValue) {
        return IrCoreUtils.getDoubleWithSubstitute(userValue, 0.3);
    }

    public static double getAbsoluteTolerance(Double userValue) {
        return IrCoreUtils.getDoubleWithSubstitute(userValue, 100.0);
    }

    public static double getFrequencyTolerance(Double userValue) {
        return IrCoreUtils.getDoubleWithSubstitute(userValue, 2000.0);
    }

    public static double getMinimumLeadout(Double userValue) {
        return IrCoreUtils.getDoubleWithSubstitute(userValue, 20000.0);
    }

    public static double getMinRepeatLastGap(Double userValue) {
        return IrCoreUtils.getDoubleWithSubstitute(userValue, 5000.0);
    }

    public static double seconds2microseconds(double secs) {
        return 1000000.0 * secs;
    }

    public static double milliseconds2microseconds(double ms) {
        return 1000.0 * ms;
    }

    public static double microseconds2milliseconds(double us) {
        return 0.001 * us;
    }

    public static double microseconds2seconds(double us) {
        return 1.0E-6 * us;
    }

    public static double khz2Hz(double khz) {
        return 1000.0 * khz;
    }

    public static double hz2khz(double frequency) {
        return 0.001 * frequency;
    }

    public static double us2Periods(double us, double frequency) {
        return IrCoreUtils.microseconds2seconds(us) * frequency;
    }

    public static double percent2real(double percent) {
        return 0.01 * percent;
    }

    public static double real2percent(double x) {
        return 100.0 * x;
    }

    public static double l1Norm(Double[] sequence) {
        double sum = 0.0;
        for (Double d : sequence) {
            sum += Math.abs(d);
        }
        return sum;
    }

    public static double l1Norm(Iterable<Double> sequence) {
        double sum = 0.0;
        for (Double d : sequence) {
            sum += Math.abs(d);
        }
        return sum;
    }

    public static double l1Norm(double[] sequence) {
        return IrCoreUtils.l1Norm(sequence, 0, sequence.length);
    }

    public static double l1Norm(double[] sequence, int beg, int length) {
        double sum = 0.0;
        for (int i = beg; i < beg + length; ++i) {
            sum += Math.abs(sequence[i]);
        }
        return sum;
    }

    public static double l1Norm(List<Double> list, int beg) {
        double sum = 0.0;
        for (int i = beg; i < list.size(); ++i) {
            sum += Math.abs(list.get(i));
        }
        return sum;
    }

    public static int l1Norm(int[] sequence, int beg, int length) {
        int sum = 0;
        for (int i = beg; i < beg + length; ++i) {
            sum += Math.abs(sequence[i]);
        }
        return sum;
    }

    public static int l1Norm(int[] sequence) {
        return IrCoreUtils.l1Norm(sequence, 0, sequence.length);
    }

    public static String chars(int length, char ch) {
        return IrCoreUtils.chars(length, (byte)ch);
    }

    public static String chars(int length, byte value) {
        if (length <= 0) {
            return "";
        }
        byte[] buf = new byte[length];
        Arrays.fill(buf, value);
        return new String(buf, DUMB_CHARSET);
    }

    public static String spaces(int length) {
        return IrCoreUtils.chars(length, (byte)32);
    }

    public static String tabs(int length) {
        return IrCoreUtils.chars(length, (byte)9);
    }

    public static long ones(Number numOnes) {
        if (numOnes == null) {
            return -1L;
        }
        long n = numOnes.longValue();
        if (n < 0L || n > 64L) {
            throw new IllegalArgumentException("Argument must be non-negative and <= 64");
        }
        return n == 64L ? -1L : (1L << (int)n) - 1L;
    }

    public static String toCName(String name) {
        String newName = name.replaceAll("[^0-9A-Za-z_]", "_");
        return newName.matches("\\d.*") ? "X" + newName : newName;
    }

    public static int numberTrue(Boolean ... args) {
        int result = 0;
        Boolean[] booleanArray = args;
        int n = booleanArray.length;
        for (int i = 0; i < n; ++i) {
            boolean b = booleanArray[i];
            if (!b) continue;
            ++result;
        }
        return result;
    }

    public static PrintStream getPrintStream(String filename, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        String realFilename;
        if (filename == null) {
            return null;
        }
        String string = realFilename = filename.startsWith("+") ? filename.substring(1) : filename;
        return filename.equals("-") ? new PrintStream((OutputStream)System.out, false, encoding) : (filename.equals("NULL") ? new PrintStream((OutputStream)new NullOutputStream(), false, encoding) : new PrintStream((OutputStream)new FileOutputStream(realFilename, filename.startsWith("+")), false, encoding));
    }

    public static PrintStream getPrintStream(String filename) throws FileNotFoundException {
        try {
            return IrCoreUtils.getPrintStream(filename, UTF8_NAME);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    public static InputStream getInputStream(String filename) throws FileNotFoundException, IOException {
        if (filename == null || filename.isEmpty() || filename.equals("-")) {
            return System.in;
        }
        try {
            URL url = new URL(filename);
            return url.openStream();
        }
        catch (MalformedURLException ex) {
            return new FileInputStream(filename);
        }
    }

    public static InputStreamReader getInputReader(String filename, String encoding) throws FileNotFoundException, IOException {
        InputStream inputStream = IrCoreUtils.getInputStream(filename);
        return new InputStreamReader(inputStream, encoding);
    }

    public static void trivialFormatter(PrintStream out, String string, int lineLength) {
        String[] data;
        int pos = 0;
        boolean justBrokeLine = false;
        for (String str : data = string.split("((?<=\\s)|(?=\\s))")) {
            if (!(pos <= 0 && str.matches(" ") || pos == 0 && str.matches("\\v") && justBrokeLine)) {
                out.print(str);
            }
            justBrokeLine = false;
            int n = pos = str.matches("\\v") ? 0 : pos + str.length();
            if (pos <= lineLength) continue;
            out.println();
            pos = 0;
            justBrokeLine = true;
        }
        if (pos > 0) {
            out.println();
        }
    }

    public static String formatIntegerWithLeadingZeros(long x, int radix, int length) {
        return radix == 2 ? IrCoreUtils.formatIntegerBase2WithLeadingZeros(x, length) : (radix == 8 ? IrCoreUtils.formatIntegerBase8WithLeadingZeros(x, length) : (radix == 16 ? IrCoreUtils.formatIntegerBase16WithLeadingZeros(x, length) : IrCoreUtils.formatIntegerBaseSomeWithLeadingZeros(x, radix, length)));
    }

    private static String formatIntegerBase2WithLeadingZeros(long x, int length) {
        return IrCoreUtils.pad(Long.toBinaryString(x), length, 1.0);
    }

    private static String formatIntegerBase8WithLeadingZeros(long x, int length) {
        return IrCoreUtils.pad(Long.toOctalString(x), length, 3.0);
    }

    private static String formatIntegerBase16WithLeadingZeros(long x, int length) {
        return IrCoreUtils.pad(Long.toHexString(x), length, 4.0);
    }

    private static String formatIntegerBaseSomeWithLeadingZeros(long x, int radix, int length) {
        return IrCoreUtils.pad(Long.toString(x, radix), length, Math.log(radix) / Math.log(2.0));
    }

    private static String pad(String rawString, int length, double noBits) {
        StringBuilder str = new StringBuilder(rawString);
        int effectiveLength = (int)Math.ceil((double)length / noBits);
        while (str.length() < effectiveLength) {
            str.insert(0, '0');
        }
        return str.toString();
    }

    public static String padString(String s, int length) {
        return s + IrCoreUtils.spaces(length - s.length());
    }

    public static long power(long x, long y) {
        if (y < 0L) {
            throw new ArithmeticException("power to a negative integer is not sensible here.");
        }
        long r = 1L;
        for (long i = 0L; i < y; ++i) {
            r *= x;
        }
        return r;
    }

    public static long log2(long x) {
        if (x <= 0L) {
            throw new IllegalArgumentException("argument must be positive");
        }
        int d = 64 - Long.numberOfLeadingZeros(x);
        return Long.bitCount(x) > 1 ? (long)d : (long)(d - 1);
    }

    public static String radixPrefix(int radix) {
        return radixPrefixes.getOrDefault(radix, "");
    }

    public static int prefixRadix(String prefix) {
        return prefixToRadix.getOrDefault(prefix, 10);
    }

    public static long parseLong(String str, boolean special, int defaultRadix) {
        String s;
        if (special && (str.startsWith("#") || str.contains(","))) {
            return -3L;
        }
        String string = s = special ? str.replaceAll("[:.\\+<#].*$", "").trim() : str;
        if (special && (s.equals("*") || s.equals("'*'"))) {
            return -2L;
        }
        return IrCoreUtils.parseWithPrefix(s, defaultRadix);
    }

    public static long parseWithPrefix(String s, int defaultRadix) {
        if (s.equals("0")) {
            return 0L;
        }
        for (Map.Entry<String, Integer> kvp : prefixToRadix.entrySet()) {
            String prefix = kvp.getKey();
            if (!s.startsWith(prefix) || prefix.equals("0") && (!s.matches("[0-7]+") || defaultRadix != 10)) continue;
            String payload = s.substring(prefix.length());
            int radix = kvp.getValue();
            return Long.parseLong(payload, radix);
        }
        return Long.parseLong(s, defaultRadix);
    }

    public static long parseLong(String str, boolean special) {
        return IrCoreUtils.parseLong(str, special, 10);
    }

    public static long parseLong(String str, int defaultRadix) {
        return IrCoreUtils.parseLong(str, false, defaultRadix);
    }

    public static long parseLong(String str) {
        return IrCoreUtils.parseLong(str, false);
    }

    public static long parseUpper(String str) {
        String[] s = str.split("\\.\\.");
        if (s.length == 1) {
            s = str.split(":");
        }
        return s.length == 2 ? IrCoreUtils.parseLong(s[1], false) : -1L;
    }

    public static long reverse(long x, int width) {
        long y = Long.reverse(x);
        if (width > 0) {
            y >>>= 64 - width;
        }
        return y;
    }

    public static int reverse(int x, int width) {
        int y = Integer.reverse(x);
        if (width > 0) {
            y >>>= 32 - width;
        }
        return y;
    }

    public static BigInteger reverse(BigInteger x, int width) {
        try {
            if (width < 64) {
                return BigInteger.valueOf(IrCoreUtils.reverse(x.longValueExact(), width));
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        StringBuilder str = new StringBuilder(x.toString(2));
        if (str.length() > width) {
            str.delete(0, str.length() - width);
        } else {
            while (str.length() < width) {
                str.insert(0, '0');
            }
        }
        str.reverse();
        return new BigInteger(str.toString(), 2);
    }

    public static boolean approximatelyEquals(Double x, Double y, double absoluteTolerance, double relativeTolerance) {
        boolean absoluteOk;
        if (x == null && y == null) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        double absDiff = Math.abs(x - y);
        boolean bl = absoluteOk = absDiff <= absoluteTolerance;
        if (absoluteOk) {
            return true;
        }
        double max = Math.max(Math.abs(x), Math.abs(y));
        if (max < 1.0) {
            return false;
        }
        double relDiff = absDiff / max;
        return relDiff <= relativeTolerance;
    }

    public static boolean approximatelyEquals(Double x, Double y) {
        return IrCoreUtils.approximatelyEquals(x, y, 100.0, 0.3);
    }

    public static boolean approximatelyEquals(int x, int y, int absoluteTolerance, double relativeTolerance) {
        boolean absoluteOk;
        int absDiff = Math.abs(x - y);
        boolean bl = absoluteOk = absDiff <= absoluteTolerance;
        if (absoluteOk) {
            return true;
        }
        int max = Math.max(Math.abs(x), Math.abs(y));
        return max > 0 && (double)absDiff / (double)max <= relativeTolerance;
    }

    public static long maskTo(long data, int width) {
        return data & IrCoreUtils.ones(width);
    }

    public static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase(Locale.US) + s.substring(1);
    }

    public static String javaifyString(String s) {
        return s.replaceAll("\n\r?", " ").replaceAll("\\s\\s+", " ").replace("\"", "\\\"");
    }

    public static boolean hasDuplicatedElements(List<?> list) {
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                if (!obj.equals(list.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public static int approximateGreatestCommonDivider(List<Integer> args, double relTolerance) {
        if (args.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return IrCoreUtils.approximateGreatestCommonDivider(null, args, relTolerance);
    }

    private static int approximateGreatestCommonDivider(Integer num, List<Integer> args, double relTolerance) {
        if (args.isEmpty()) {
            return num;
        }
        int newNum = num == null ? args.get(0) : IrCoreUtils.approximateGreatestCommonDivider((int)num, args.get(0), relTolerance);
        ArrayList<Integer> list = new ArrayList<Integer>(args);
        list.remove(0);
        return IrCoreUtils.approximateGreatestCommonDivider((Integer)newNum, list, relTolerance);
    }

    public static int approximateGreatestCommonDivider(int first, int second, double relTolerance) {
        return first > second ? IrCoreUtils.approximateGCD(first, second, relTolerance) : IrCoreUtils.approximateGCD(second, first, relTolerance);
    }

    private static int approximateGCD(int first, int second, double relTolerance) {
        int quot = (first + second / 2) / second;
        int rest = Math.abs(first - quot * second);
        return (double)rest / (double)second <= relTolerance ? second : IrCoreUtils.approximateGCD(second, rest, relTolerance);
    }

    public static int maxLength(Iterable<String> strings) {
        int max = 0;
        for (String s : strings) {
            int len = s.length();
            if (len <= max) continue;
            max = len;
        }
        return max;
    }

    public static int maxLength(String[] strings) {
        return strings != null ? IrCoreUtils.maxLength(Arrays.asList(strings)) : 0;
    }

    public static void main(String[] args) {
        int i;
        boolean hasOption = args[0].equals("-r");
        double relTolerance = hasOption ? Double.parseDouble(args[1]) : 0.0;
        ArrayList<Integer> data = new ArrayList<Integer>(args.length);
        int n = i = hasOption ? 2 : 0;
        while (i < args.length) {
            data.add(Integer.valueOf(args[i]));
            ++i;
        }
        int gcd = IrCoreUtils.approximateGreatestCommonDivider(data, relTolerance);
        System.out.println(gcd);
    }

    public static File[] filesInDirMatchingRegExp(File dir, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        return dir.listFiles((dir1, name) -> pattern.matcher(name).matches());
    }

    public static double minDiff(TreeSet<Double> numbers) {
        double lowestYet = Double.MAX_VALUE;
        double last = -1.7976931348623157E308;
        for (Double d : numbers) {
            double diff = d - last;
            if (diff < lowestYet) {
                lowestYet = diff;
            }
            last = d;
        }
        return lowestYet;
    }

    public static String basename(String filename) {
        return new File(filename).getName().split("\\.")[0];
    }

    private static boolean hasExtension(String filename) {
        int lastSeparator = filename.lastIndexOf(File.separator);
        int lastPeriod = filename.lastIndexOf(46);
        return lastPeriod > lastSeparator;
    }

    public static String addExtensionIfNotPresent(String filename, String extension) {
        return filename + (extension != null && !IrCoreUtils.hasExtension(filename) ? '.' + extension : "");
    }

    public static int hashForDouble(Double d) {
        return d == null ? 0 : d.hashCode();
    }

    public static int lexicalCompare(int ... compare) {
        for (int c : compare) {
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public static void checkEncoding(String encoding) throws UnsupportedEncodingException {
        try {
            if (!Charset.isSupported(encoding)) {
                throw new UnsupportedEncodingException(encoding);
            }
        }
        catch (IllegalArgumentException unused) {
            throw new UnsupportedEncodingException(encoding);
        }
    }

    private IrCoreUtils() {
    }

    static {
        DUMB_CHARSET = Charset.forName(DUMB_CHARSET_NAME);
        EXTENDED_LATIN1 = Charset.forName(EXTENDED_LATIN1_NAME);
        UTF8 = Charset.forName(UTF8_NAME);
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>(4);
        map.put("0b", 2);
        map.put("%", 2);
        map.put("0", 8);
        map.put("0x", 16);
        IrCoreUtils.setRadixPrefixes(map);
    }

    private static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

