/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.ircore;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.StringJoiner;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ThisCannotHappenException;

public class IrSequence
implements Cloneable,
Serializable {
    private static final double EPSILON = 0.001;
    public static final double DUMMYGAPDURATION = 50000.0;
    public static final IrSequence EMPTY = new IrSequence();
    private static Random random = null;
    private double[] data;

    public static void initRandom(long seed) {
        IrSequence.initRandom();
        random.setSeed(seed);
    }

    public static void initRandom() {
        random = new Random();
    }

    public static IrSequence concatenate(Collection<IrSequence> sequences) {
        int totalLength = 0;
        totalLength = sequences.stream().map(seq -> seq.data.length).reduce(totalLength, Integer::sum);
        double[] data = new double[totalLength];
        int pos = 0;
        for (IrSequence seq2 : sequences) {
            System.arraycopy(seq2.data, 0, data, pos, seq2.data.length);
            pos += seq2.data.length;
        }
        try {
            return new IrSequence(data);
        }
        catch (OddSequenceLengthException ex) {
            throw new ThisCannotHappenException();
        }
    }

    public static IrSequence concatenate(IrSequence ... sequences) {
        return IrSequence.concatenate(Arrays.asList(sequences));
    }

    private static boolean isFlash(int i) {
        return i % 2 == 0;
    }

    private static void checkOddLength(int length) throws OddSequenceLengthException {
        if (length % 2 != 0) {
            throw new OddSequenceLengthException(length);
        }
    }

    private static void checkOddLength(double[] data) throws OddSequenceLengthException {
        IrSequence.checkOddLength(data.length);
    }

    private static double[] fixOddLength(double[] data, Double dummyGapDuration) throws OddSequenceLengthException {
        if (data.length % 2 != 0) {
            if (dummyGapDuration == null || data.length < 2) {
                IrSequence.checkOddLength(data);
                return data;
            }
            double[] newData = new double[data.length + 1];
            System.arraycopy(data, 0, newData, 0, data.length);
            newData[data.length] = dummyGapDuration;
            return newData;
        }
        return data;
    }

    public static List<Double> toInterleavingList(Collection<? extends Number> list) {
        if (list == null || list.isEmpty()) {
            return new ArrayList<Double>(0);
        }
        ArrayList<Double> result = new ArrayList<Double>(list.size());
        Number previous = -1;
        for (Number number : list) {
            double value = number.doubleValue();
            if (result.isEmpty() && value <= 0.0 || value == 0.0) continue;
            if (IrSequence.equalSign(value, previous)) {
                result.set(result.size() - 1, (Double)result.get(result.size() - 1) + value);
            } else {
                result.add(value);
            }
            previous = value;
        }
        return result;
    }

    private static boolean equalSign(Number x, Number y) {
        return x.doubleValue() < 0.0 == y.doubleValue() < 0.0;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] toInts(Iterable<? extends IrSequence> list) {
        int length = 0;
        for (IrSequence irSequence : list) {
            length += irSequence.getLength();
        }
        int[] result = new int[length];
        boolean bl = false;
        for (IrSequence irSequence : list) {
            void var3_5;
            int[] array = irSequence.toInts();
            System.arraycopy(array, 0, result, (int)var3_5, array.length);
            var3_5 += array.length;
        }
        return result;
    }

    private static double[] toDoubles(Collection<? extends Number> collection) {
        double[] result = new double[collection.size()];
        int i = 0;
        for (Number number : collection) {
            result[i] = number.doubleValue();
            ++i;
        }
        return result;
    }

    private static double[] stringsToDoubles(String[] collection) {
        double[] result = new double[collection.length];
        int i = 0;
        for (String str : collection) {
            result[i] = Double.parseDouble(str);
            ++i;
        }
        return result;
    }

    public static double[] toDoublesPreservingSigns(String str) {
        if (str == null || str.trim().isEmpty()) {
            return new double[0];
        }
        String[] strings = str.trim().split("[\\s,;]+");
        if (strings.length == 1) {
            strings = str.trim().split("(?=\\+)|(?=-)");
        }
        return IrSequence.stringsToDoubles(strings);
    }

    private static double[] toDoubles(String string) {
        if (string == null || string.trim().isEmpty()) {
            return new double[0];
        }
        String str = IrSequence.stripDecoratedString(string);
        String[] strings = str.trim().split("\\s+");
        return IrSequence.stringsToDoubles(strings);
    }

    public static String stripDecoratedString(String in) {
        return in.replaceAll("[+\\-,;\\s]+", " ").trim();
    }

    public static String normalize(String in, Double dummyGap, boolean useSigns, String separator) throws OddSequenceLengthException {
        IrSequence irSequence = new IrSequence(in, dummyGap);
        return irSequence.toString(useSigns, separator, "", "");
    }

    public IrSequence() {
        this.data = new double[0];
    }

    public IrSequence(double[] inData) throws OddSequenceLengthException {
        IrSequence.checkOddLength(inData);
        this.setup(inData);
    }

    public IrSequence(double[] inData, Double dummyGapDuration) throws OddSequenceLengthException {
        this.setup(IrSequence.fixOddLength(inData, dummyGapDuration));
    }

    public IrSequence(int[] inData) throws OddSequenceLengthException {
        IrSequence.checkOddLength(inData.length);
        this.setup(inData);
    }

    public IrSequence(Collection<? extends Number> collection) throws OddSequenceLengthException {
        this(IrSequence.toDoubles(collection));
    }

    public IrSequence(String[] strings) throws OddSequenceLengthException {
        this(IrSequence.stringsToDoubles(strings));
    }

    public IrSequence(String string) throws OddSequenceLengthException {
        this(IrSequence.toDoubles(string));
    }

    public IrSequence(String string, Double dummyGapDuration) throws OddSequenceLengthException {
        this(IrSequence.toDoubles(string), dummyGapDuration);
    }

    public IrSequence(int[] idata, int offset, int length) throws InvalidArgumentException {
        if (offset >= idata.length && length != 0) {
            throw new InvalidArgumentException("IrSequence: offset beyond end.");
        }
        if (offset + length > idata.length) {
            throw new InvalidArgumentException("IrSequence: length too large.");
        }
        this.data = new double[length];
        for (int i = 0; i < length; ++i) {
            this.data[i] = Math.abs(idata[i + offset]);
        }
    }

    public IrSequence(IrSequence src) {
        this.data = (double[])src.data.clone();
    }

    public IrSequence(IrSequence src, int start, int length) throws InvalidArgumentException {
        if (start % 2 != 0 || length % 2 != 0) {
            throw new OddSequenceLengthException("Start and length must be even");
        }
        if (start + length > src.data.length) {
            throw new InvalidArgumentException("Selection extends beyond end.");
        }
        this.data = new double[length];
        System.arraycopy(src.data, start, this.data, 0, length);
    }

    private void setup(double[] inData) {
        this.data = new double[inData.length];
        int i = 0;
        for (double d : inData) {
            this.data[i] = Math.abs(d);
            ++i;
        }
    }

    private void setup(int[] inData) {
        this.data = new double[inData.length];
        int i = 0;
        for (int d : inData) {
            this.data[i] = Math.abs(d);
            ++i;
        }
    }

    public final double get(int i) {
        return this.data[i];
    }

    public final int[] toInts() {
        int[] array = new int[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            array[i] = (int)Math.round(this.data[i]);
        }
        return array;
    }

    public final double[] toDoubles() {
        return (double[])this.data.clone();
    }

    public final int[] toPulses(double frequency) {
        int[] array = new int[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            array[i] = (int)Math.round(Math.abs(frequency * this.data[i] / 1000000.0));
        }
        return array;
    }

    public IrSequence append(IrSequence tail, int repetitions) {
        double[] newData = new double[this.data.length + repetitions * tail.data.length];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        for (int r = 0; r < repetitions; ++r) {
            System.arraycopy(tail.data, 0, newData, this.data.length + r * tail.data.length, tail.data.length);
        }
        try {
            return new IrSequence(newData);
        }
        catch (OddSequenceLengthException ex) {
            throw new ThisCannotHappenException();
        }
    }

    public IrSequence append(IrSequence tail) {
        return this.append(tail, 1);
    }

    public IrSequence append(double delay) throws InvalidArgumentException {
        if (this.data.length == 0) {
            throw new InvalidArgumentException("IrSequence is empty");
        }
        IrSequence irSequence = new IrSequence(this);
        int n = this.data.length - 1;
        irSequence.data[n] = irSequence.data[n] + delay;
        return irSequence;
    }

    public IrSequence clone() {
        IrSequence result;
        try {
            result = (IrSequence)super.clone();
            result.data = (double[])this.data.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new ThisCannotHappenException(ex);
        }
        return result;
    }

    public IrSequence subSequence(int start, int length) throws InvalidArgumentException {
        try {
            return new IrSequence(this, start, length);
        }
        catch (OddSequenceLengthException ex) {
            throw new ThisCannotHappenException();
        }
    }

    public IrSequence truncate(int length) throws InvalidArgumentException {
        return this.subSequence(0, length);
    }

    public List<IrSequence> chop(double threshold) {
        ArrayList<IrSequence> arrayList = new ArrayList<IrSequence>(16);
        int beg = 0;
        for (int i = 1; i < this.data.length; i += 2) {
            if (!(this.data[i] >= threshold) && i != this.data.length - 1) continue;
            double[] arr = new double[i - beg + 1];
            System.arraycopy(this.data, beg, arr, 0, i - beg + 1);
            try {
                arrayList.add(new IrSequence(arr));
            }
            catch (OddSequenceLengthException ex) {
                throw new ThisCannotHappenException();
            }
            beg = i + 1;
        }
        return arrayList;
    }

    public IrSequence addToFlashes(double amount) {
        IrSequence clone = this.clone();
        for (int i = 0; i < this.data.length; i += 2) {
            int n = i;
            clone.data[n] = clone.data[n] + amount;
        }
        return clone;
    }

    public IrSequence addToGaps(double amount) {
        IrSequence clone = this.clone();
        for (int i = 1; i < this.data.length; i += 2) {
            int n = i;
            clone.data[n] = clone.data[n] + amount;
        }
        return clone;
    }

    public IrSequence flashExcess(double amount) {
        return this.addToFlashes(amount).addToGaps(-amount);
    }

    public IrSequence addNoise(double max) {
        IrSequence clone = this.clone();
        for (int i = 0; i < this.data.length; i += 2) {
            double t = max * (2.0 * random.nextDouble() - 1.0);
            int n = i;
            clone.data[n] = clone.data[n] + t;
            int n2 = i + 1;
            clone.data[n2] = clone.data[n2] - t;
        }
        return clone;
    }

    public boolean approximatelyEquals(IrSequence irSequence) {
        return this.approximatelyEquals(irSequence, 1.0, 0.001);
    }

    public boolean approximatelyEquals(IrSequence irSequence, double absoluteTolerance, double relativeTolerance) {
        if (irSequence == null || this.data.length != irSequence.data.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (IrCoreUtils.approximatelyEquals(this.data[i], irSequence.data[i], absoluteTolerance, relativeTolerance)) continue;
            return false;
        }
        return true;
    }

    public boolean approximatelyEquals(int beginning, int compareStart, int length, double absoluteTolerance, double relativeTolerance, double lastLimit) {
        boolean specialTreatment = compareStart + length == this.data.length && lastLimit > 0.0;
        for (int i = 0; i < (specialTreatment ? length - 1 : length); ++i) {
            if (IrCoreUtils.approximatelyEquals(this.data[beginning + i], this.data[compareStart + i], absoluteTolerance, relativeTolerance)) continue;
            return false;
        }
        return !specialTreatment || IrCoreUtils.approximatelyEquals(this.data[beginning + length - 1], this.data[compareStart + length - 1], absoluteTolerance, relativeTolerance) || this.data[beginning + length - 1] >= lastLimit && this.data[compareStart + length - 1] >= lastLimit;
    }

    public boolean approximatelyEquals(int beginning, int compareStart, int length, double absoluteTolerance, double relativeTolerance) {
        return this.approximatelyEquals(beginning, compareStart, length, absoluteTolerance, relativeTolerance, 0.0);
    }

    public final int getLength() {
        return this.data.length;
    }

    public final Double getLastGap() {
        return this.data.length > 0 ? Double.valueOf(this.data[this.data.length - 1]) : null;
    }

    public final boolean isEmpty() {
        return this.data.length == 0;
    }

    public final boolean containsZeros() {
        for (double t : this.data) {
            if (!(t < 0.001)) continue;
            return true;
        }
        return false;
    }

    public final boolean replaceZeros(double replacement) {
        boolean wasChanged = false;
        for (int i = 0; i < this.data.length; ++i) {
            if (!(this.data[i] < 0.001)) continue;
            this.data[i] = replacement;
            wasChanged = true;
        }
        return wasChanged;
    }

    public final double getTotalDuration() {
        return this.getTotalDuration(0, this.data.length);
    }

    public double getTotalDuration(int begin, int length) {
        return IrCoreUtils.l1Norm(this.data, begin, length);
    }

    public int firstBigGap(int start, double limit) {
        for (int i = start + start % 2; i < this.data.length - 2; i += 2) {
            if (!(this.data[i + 1] >= limit)) continue;
            return i + 1;
        }
        return -1;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean alternatingSigns) {
        return this.toString(alternatingSigns, ",", "[", "]");
    }

    public String toString(boolean alternatingSigns, String separator) {
        return this.toString(alternatingSigns, separator, "", "");
    }

    public String toString(boolean alternatingSigns, String separator, String prefix, String suffix) {
        StringJoiner stringJoiner = new StringJoiner(separator, prefix, suffix);
        for (int i = 0; i < this.data.length; ++i) {
            String sign = alternatingSigns ? (IrSequence.isFlash(i) ? "+" : "-") : "";
            stringJoiner.add(sign + Long.toString(Math.round(this.data[i])));
        }
        return stringJoiner.toString();
    }
}

