/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.ircore;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ThisCannotHappenException;

public final class IrSignal
implements Cloneable,
Serializable {
    public static final IrSignal EMPTY = new IrSignal();
    private IrSequence introSequence;
    private IrSequence repeatSequence;
    private IrSequence endingSequence;
    private EnumMap<Pass, IrSequence> map;
    private Double frequency;
    private Double dutyCycle = null;

    public IrSignal(IrSequence introSequence, IrSequence repeatSequence, IrSequence endingSequence, Double frequency, Double dutyCycle) {
        this.setup(introSequence, repeatSequence, endingSequence, frequency, dutyCycle);
    }

    public IrSignal(String introSequence, String repeatSequence, String endingSequence, Double frequency, Double dutyCycle) throws OddSequenceLengthException {
        this.setup(new IrSequence(introSequence), new IrSequence(repeatSequence), new IrSequence(endingSequence), frequency, dutyCycle);
    }

    public IrSignal(IrSequence introSequence, Double frequency, Double dutyCycle) {
        this(introSequence, null, null, frequency, dutyCycle);
    }

    public IrSignal(IrSequence introSequence, IrSequence repeatSequence, IrSequence endingSequence, Double frequency) {
        this(introSequence, repeatSequence, endingSequence, frequency, null);
    }

    public IrSignal(ModulatedIrSequence introSequence) {
        this((IrSequence)introSequence, new IrSequence(), new IrSequence(), introSequence.getFrequency(), introSequence.getDutyCycle());
    }

    public IrSignal(ModulatedIrSequence sequence, int beginningLength, int repeatLength, int noRepeats) throws InvalidArgumentException {
        IrSequence intro = sequence.truncate(beginningLength);
        IrSequence repeat = sequence.subSequence(beginningLength, repeatLength);
        int startEnding = beginningLength + noRepeats * repeatLength;
        int lengthEnding = sequence.getLength() - startEnding;
        IrSequence ending = sequence.subSequence(startEnding, lengthEnding);
        this.setup(intro, repeat, ending, sequence.getFrequency(), sequence.getDutyCycle());
    }

    public IrSignal(int[] durations, int noIntro, int noRepeat, double frequency) throws InvalidArgumentException {
        this(durations, noIntro, noRepeat, (Double)frequency, null);
    }

    public IrSignal(int[] durations, int noIntro, int noRepeat, Double frequency, Double dutyCycle) throws InvalidArgumentException {
        this(new IrSequence(durations, 0, noIntro), new IrSequence(durations, noIntro, noRepeat), new IrSequence(durations, noIntro + noRepeat, durations.length - (noIntro + noRepeat)), frequency, dutyCycle);
    }

    public IrSignal(IrSequence irSequence, int noIntro, int noRepeat, Double frequency, Double dutyCycle) throws InvalidArgumentException {
        this(irSequence.subSequence(0, noIntro), irSequence.subSequence(noIntro, noRepeat), irSequence.subSequence(noIntro + noRepeat, irSequence.getLength() - noIntro - noRepeat), frequency, dutyCycle);
    }

    public IrSignal() {
        this(IrSequence.EMPTY, IrSequence.EMPTY, IrSequence.EMPTY, (Double)38000.0, null);
    }

    public IrSignal(IrSignal irSignal, Double newFrequency) {
        this(irSignal.introSequence, irSignal.repeatSequence, irSignal.endingSequence, newFrequency, irSignal.dutyCycle);
    }

    private void setup(IrSequence introSequence, IrSequence repeatSequence, IrSequence endingSequence, Double frequency, Double dutyCycle) {
        this.frequency = frequency;
        this.dutyCycle = dutyCycle;
        this.introSequence = introSequence != null ? introSequence : new IrSequence();
        this.repeatSequence = repeatSequence != null ? repeatSequence : new IrSequence();
        this.endingSequence = endingSequence != null ? endingSequence : new IrSequence();
        this.map = new EnumMap(Pass.class);
        this.map.put(Pass.intro, this.introSequence);
        this.map.put(Pass.repeat, this.repeatSequence);
        this.map.put(Pass.ending, this.endingSequence);
    }

    public Double getFrequency() {
        return this.frequency;
    }

    public Double getFrequencyWithDefault() {
        return this.frequency != null ? this.frequency : 38000.0;
    }

    public Double getDutyCycle() {
        return this.dutyCycle;
    }

    public IrSignal clone() {
        IrSignal result = null;
        try {
            result = (IrSignal)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new ThisCannotHappenException(ex);
        }
        result.introSequence = this.introSequence.clone();
        result.repeatSequence = this.repeatSequence.clone();
        result.endingSequence = this.endingSequence.clone();
        return result;
    }

    public int getIntroLength() {
        return this.introSequence.getLength();
    }

    public int[] getIntroInts() {
        return this.introSequence.toInts();
    }

    public double getIntroDouble(int i) {
        return this.introSequence.get(i);
    }

    public int[] getIntroPulses() {
        return this.introSequence.toPulses(this.frequency);
    }

    public int getRepeatLength() {
        return this.repeatSequence.getLength();
    }

    public int[] getRepeatInts() {
        return this.repeatSequence.toInts();
    }

    public double getRepeatDouble(int i) {
        return this.repeatSequence.get(i);
    }

    public int[] getRepeatPulses() {
        return this.repeatSequence.toPulses(this.frequency);
    }

    public int getEndingLength() {
        return this.endingSequence.getLength();
    }

    public int[] getEndingInts() {
        return this.endingSequence.toInts();
    }

    public double getEndingDouble(int i) {
        return this.endingSequence.get(i);
    }

    public int[] getEndingPulses() {
        return this.endingSequence.toPulses(this.frequency);
    }

    public double getTotalDuration() {
        return this.introSequence.getTotalDuration() + this.repeatSequence.getTotalDuration() + this.endingSequence.getTotalDuration();
    }

    public double getDuration(int count) {
        return this.introSequence.getTotalDuration() + (double)this.repeatsPerCountSemantic(count) * this.repeatSequence.getTotalDuration() + this.endingSequence.getTotalDuration();
    }

    public double getDouble(Pass pass, int i) {
        return this.map.get((Object)pass).get(i);
    }

    public int getLength(Pass pass) {
        return this.map.get((Object)pass).getLength();
    }

    public boolean introOnly() {
        return this.repeatSequence.isEmpty() && this.endingSequence.isEmpty();
    }

    public boolean repeatOnly() {
        return this.introSequence.isEmpty() && this.endingSequence.isEmpty();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean alternatingSigns) {
        return "Freq=" + this.getFrequencyAsString() + this.introSequence.toString(alternatingSigns) + this.repeatSequence.toString(alternatingSigns) + this.endingSequence.toString(alternatingSigns);
    }

    public String getFrequencyAsString() {
        return (this.frequency != null ? Long.toString(Math.round(this.frequency)) : "?") + "Hz";
    }

    public int repeatsPerCountSemantic(int count) {
        return this.introSequence.isEmpty() ? count : count - 1;
    }

    public boolean isEmpty() {
        return this.introSequence.isEmpty() && this.repeatSequence.isEmpty() && this.endingSequence.isEmpty();
    }

    public boolean containsZeros() {
        return this.introSequence.containsZeros() || this.repeatSequence.containsZeros() || this.endingSequence.containsZeros();
    }

    public void replaceZeros(double replacement) {
        this.introSequence.replaceZeros(replacement);
        this.repeatSequence.replaceZeros(replacement);
        this.endingSequence.replaceZeros(replacement);
    }

    public void replaceZeros(int replacement) {
        this.replaceZeros(this.frequency > 0.0 ? IrCoreUtils.seconds2microseconds((double)replacement / this.frequency) : (double)replacement);
    }

    public double getGap() {
        return Math.max(this.introSequence.getLastGap(), this.repeatSequence.getLastGap());
    }

    public ModulatedIrSequence toModulatedIrSequence() {
        return this.toModulatedIrSequence(true, 1, true);
    }

    public ModulatedIrSequence toModulatedIrSequence(int count) {
        return this.toModulatedIrSequence(true, this.repeatsPerCountSemantic(count), true);
    }

    public ModulatedIrSequence toModulatedIrSequence(boolean intro, int repetitions, boolean ending) {
        IrSequence seq1 = intro ? this.introSequence : new IrSequence();
        IrSequence seq2 = seq1.append(this.repeatSequence, repetitions);
        IrSequence seq3 = ending ? seq2.append(this.endingSequence) : seq2;
        return new ModulatedIrSequence(seq3, this.frequency, this.dutyCycle);
    }

    public List<IrSequence> toIrSequences() {
        ArrayList<IrSequence> list = new ArrayList<IrSequence>(3);
        list.add(this.introSequence);
        list.add(this.repeatSequence);
        list.add(this.endingSequence);
        return list;
    }

    public IrSignal toOneShot(int count) {
        return new IrSignal((IrSequence)this.toModulatedIrSequence(count), null, null, this.frequency, this.dutyCycle);
    }

    public boolean approximatelyEquals(IrSignal irSignal, double absoluteTolerance, double relativeTolerance, double frequencyTolerance) {
        return IrCoreUtils.approximatelyEquals(this.frequency, irSignal.frequency, frequencyTolerance, 0.0) && this.introSequence.approximatelyEquals(irSignal.introSequence, absoluteTolerance, relativeTolerance) && this.repeatSequence.approximatelyEquals(irSignal.repeatSequence, absoluteTolerance, relativeTolerance) && this.endingSequence.approximatelyEquals(irSignal.endingSequence, absoluteTolerance, relativeTolerance);
    }

    public boolean approximatelyEquals(IrSignal irSignal) {
        return this.approximatelyEquals(irSignal, 100.0, 0.3, 2000.0);
    }

    public ModulatedIrSequence getIntroSequence() {
        return new ModulatedIrSequence(this.introSequence, this.frequency, this.dutyCycle);
    }

    public ModulatedIrSequence getRepeatSequence() {
        return new ModulatedIrSequence(this.repeatSequence, this.frequency, this.dutyCycle);
    }

    public ModulatedIrSequence getEndingSequence() {
        return new ModulatedIrSequence(this.endingSequence, this.frequency, this.dutyCycle);
    }

    public int[] toIntArray(int i) {
        ModulatedIrSequence seq = this.toModulatedIrSequence(i);
        return seq.toInts();
    }

    public static enum Pass {
        intro,
        repeat,
        ending,
        finish;

    }
}

