/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.ircore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ThisCannotHappenException;

public final class ModulatedIrSequence
extends IrSequence {
    private static final double ALLOWED_FREQUENCY_DEVIATION = 0.05;
    private static final double ZEROMODULATION_LIMIT = 1.0E-6;
    public static final double DEFAULT_FREQUENCY = 38000.0;
    public static final double DEFAULT_DUTYCYCLE = 0.4;
    public static final double DEFAULT_DEMODULATE_THRESHOLD = 35.0;
    public static final ModulatedIrSequence EMPTY = new ModulatedIrSequence();
    private Double frequency;
    private Double dutyCycle;

    public static ModulatedIrSequence concatenate(Collection<IrSequence> sequences, double frequency, double dutyCycle) {
        return new ModulatedIrSequence(IrSequence.concatenate(sequences), (Double)frequency, (Double)dutyCycle);
    }

    public static ModulatedIrSequence concatenate(ModulatedIrSequence[] seqs) {
        double minf = Double.MAX_VALUE;
        double maxf = Double.MIN_VALUE;
        double mindc = Double.MAX_VALUE;
        double maxdc = Double.MIN_VALUE;
        for (ModulatedIrSequence seq : seqs) {
            minf = Math.min(minf, seq.frequency);
            maxf = Math.max(maxf, seq.frequency);
            mindc = Math.min(mindc, seq.frequency);
            maxdc = Math.max(maxdc, seq.frequency);
        }
        double dutyCycle = mindc > 0.0 ? (mindc + maxdc) / 2.0 : -1.0;
        double frequency = minf > 0.0 ? (minf + maxf) / 2.0 : 0.0;
        return new ModulatedIrSequence(IrSequence.concatenate(seqs), (Double)frequency, (Double)dutyCycle);
    }

    public static double getFrequencyWithDefault(Double frequency) {
        return frequency != null ? frequency : 38000.0;
    }

    public static boolean isValidDutyCycle(Double dutyCycle) {
        return dutyCycle == null || dutyCycle > 0.0 && dutyCycle < 1.0;
    }

    public static ModulatedIrSequence demodulate(IrSequence irSequence, double threshold) {
        ArrayList<Double> list = new ArrayList<Double>(128);
        double pending = 0.0;
        double sumPulses = 0.0;
        double sumOn = 0.0;
        int numberPulses = 0;
        int begFlash = 0;
        for (int i = 0; i < irSequence.getLength(); i += 2) {
            pending += irSequence.get(i);
            if (irSequence.get(i + 1) > threshold) {
                list.add(pending);
                list.add(irSequence.get(i + 1));
                pending = 0.0;
                begFlash = i;
                continue;
            }
            pending += irSequence.get(i + 1);
            if (i <= begFlash) continue;
            sumPulses += irSequence.get(i) + irSequence.get(i + 1);
            sumOn += irSequence.get(i);
            ++numberPulses;
        }
        double freq = (double)numberPulses / IrCoreUtils.microseconds2seconds(sumPulses);
        double dutyCycle = sumOn / sumPulses;
        try {
            IrSequence seq = new IrSequence(list);
            return new ModulatedIrSequence(seq, (Double)freq, (Double)dutyCycle);
        }
        catch (OddSequenceLengthException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    public static ModulatedIrSequence demodulate(IrSequence irSequence) {
        return ModulatedIrSequence.demodulate(irSequence, 35.0);
    }

    public static Double frequencyAverage(Iterable<ModulatedIrSequence> seqs) {
        double sum = 0.0;
        int index = 0;
        for (ModulatedIrSequence seq : seqs) {
            Double freq = seq.getFrequency();
            if (freq == null) {
                return null;
            }
            sum += freq.doubleValue();
            ++index;
        }
        return index > 0 ? Double.valueOf(sum / (double)index) : null;
    }

    public ModulatedIrSequence() {
        this.frequency = null;
        this.dutyCycle = null;
    }

    public ModulatedIrSequence(IrSequence irSequence, Double frequency, Double dutyCycle) {
        super(irSequence);
        this.frequency = frequency;
        this.dutyCycle = dutyCycle;
    }

    public ModulatedIrSequence(IrSequence irSequence, Double frequency) {
        this(irSequence, frequency, null);
    }

    public ModulatedIrSequence(ModulatedIrSequence src, int start, int length) throws InvalidArgumentException {
        super(src, start, length);
        this.frequency = src.frequency;
        this.dutyCycle = src.dutyCycle;
    }

    public ModulatedIrSequence(double[] durations, Double frequency, Double dutyCycle) throws OddSequenceLengthException {
        this(new IrSequence(durations), frequency, dutyCycle);
    }

    public ModulatedIrSequence(double[] durations, Double frequency) throws OddSequenceLengthException {
        this(new IrSequence(durations), frequency, null);
    }

    public ModulatedIrSequence(int[] durations, Double frequency, Double dutyCycle) throws OddSequenceLengthException {
        this(new IrSequence(durations), frequency, dutyCycle);
    }

    public ModulatedIrSequence(int[] durations, Double frequency) throws OddSequenceLengthException {
        this(durations, frequency, (Double)null);
    }

    public Double getFrequency() {
        return this.frequency;
    }

    public double getFrequencyWithDefault() {
        return ModulatedIrSequence.getFrequencyWithDefault(this.frequency);
    }

    public Double getDutyCycle() {
        return this.dutyCycle;
    }

    public double getDutyCycleWithDefault() {
        return this.dutyCycle != null ? this.dutyCycle : 0.4;
    }

    public String toStringFrequency(boolean alternatingSigns) {
        return "{" + (this.frequency != null ? Integer.toString((int)Math.round(this.frequency)) + "," : "") + (this.dutyCycle != null ? Integer.toString((int)Math.round(100.0 * this.dutyCycle)) + "%," : "") + super.toString(alternatingSigns) + "}";
    }

    public String toStringFrequency() {
        return this.toStringFrequency(false);
    }

    public IrSignal toIrSignal() {
        return new IrSignal(this);
    }

    public ModulatedIrSequence setFrequency(Double newFrequency) {
        return new ModulatedIrSequence(this, newFrequency != null ? newFrequency : this.frequency);
    }

    public boolean approximatelyEquals(ModulatedIrSequence irSequence, double absoluteTolerance, double relativeTolerance, double frequencyTolerance, double dutyCycleTolerance) {
        return IrCoreUtils.approximatelyEquals(this.getFrequency(), irSequence.getFrequency(), frequencyTolerance, 0.0) && IrCoreUtils.approximatelyEquals(this.getDutyCycle(), irSequence.getDutyCycle(), dutyCycleTolerance, 0.0) && super.approximatelyEquals(irSequence, absoluteTolerance, relativeTolerance);
    }

    public boolean approximatelyEquals(ModulatedIrSequence irSequence, double absoluteTolerance, double relativeTolerance, double frequencyTolerance) {
        return this.approximatelyEquals(irSequence, absoluteTolerance, relativeTolerance, frequencyTolerance, 0.3);
    }

    public boolean approximatelyEquals(ModulatedIrSequence irSequence, double absoluteTolerance, double relativeTolerance) {
        return this.approximatelyEquals(irSequence, absoluteTolerance, relativeTolerance, 2000.0, 0.3);
    }

    public boolean approximatelyEquals(ModulatedIrSequence irSequence) {
        return this.approximatelyEquals(irSequence, 100.0, 0.3, 2000.0, 0.3);
    }

    public boolean isZeroModulated() {
        return this.frequency < 1.0E-6;
    }

    @Override
    public ModulatedIrSequence addNoise(double max) {
        return new ModulatedIrSequence(super.addNoise(max), this.frequency, this.dutyCycle);
    }

    @Override
    public ModulatedIrSequence append(double delay) throws InvalidArgumentException {
        IrSequence irSequence = super.append(delay);
        return new ModulatedIrSequence(irSequence, this.frequency, this.dutyCycle);
    }

    public ModulatedIrSequence append(ModulatedIrSequence tail) throws InvalidArgumentException {
        if (this.isZeroModulated() ? !tail.isZeroModulated() : Math.abs(this.frequency - tail.getFrequency()) / this.frequency > 0.05) {
            throw new InvalidArgumentException("concationation not possible; modulation frequencies differ");
        }
        IrSequence irSequence = super.append(tail);
        return new ModulatedIrSequence(irSequence, this.frequency, this.dutyCycle);
    }

    @Override
    public List<IrSequence> chop(double amount) {
        List<IrSequence> irSequences = super.chop(amount);
        ArrayList<IrSequence> mods = new ArrayList<IrSequence>(irSequences.size());
        irSequences.forEach(seq -> mods.add(new ModulatedIrSequence((IrSequence)seq, this.frequency, this.dutyCycle)));
        return mods;
    }

    @Override
    public ModulatedIrSequence clone() {
        return (ModulatedIrSequence)super.clone();
    }

    public IrSequence modulate() {
        ArrayList<Double> list = new ArrayList<Double>(1024);
        for (int i = 0; i < this.getLength(); i += 2) {
            List<Double> pulse = this.flash(this.get(i));
            if (pulse.size() % 2 == 1) {
                int lastIndex = pulse.size() - 1;
                Double lastOnDuration = pulse.get(lastIndex);
                if (lastOnDuration <= 0.5) {
                    pulse.set(lastIndex - 1, pulse.get(lastIndex - 1) + lastOnDuration + this.get(i + 1));
                    pulse.remove(lastIndex);
                } else {
                    pulse.add(this.get(i + 1));
                }
            } else {
                double lastGap = pulse.get(pulse.size() - 1);
                pulse.set(pulse.size() - 1, lastGap += this.get(i + 1));
            }
            list.addAll(pulse);
        }
        try {
            return new IrSequence(list);
        }
        catch (OddSequenceLengthException ex) {
            throw new ThisCannotHappenException();
        }
    }

    private List<Double> flash(double duration) {
        double left;
        double dutyCyc = this.getDutyCycleWithDefault();
        double periodTime = 1000000.0 / this.frequency;
        double onPeriod = periodTime * dutyCyc;
        double offPeriod = periodTime * (1.0 - dutyCyc);
        ArrayList<Double> list = new ArrayList<Double>(128);
        for (left = duration; left > periodTime; left -= periodTime) {
            list.add(onPeriod);
            list.add(offPeriod);
        }
        if (left < onPeriod) {
            list.add(left);
        } else {
            list.add(onPeriod);
            list.add(left -= onPeriod);
        }
        return list;
    }
}

