/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.ircore;

import java.util.ArrayList;
import java.util.List;
import org.harctoolbox.ircore.AbstractIrParser;
import org.harctoolbox.ircore.BracketedIrSignalParser;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.IrSignalParser;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.MultilineIrSignalParser;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ProntoParserLoose;

public class MultiParser
extends AbstractIrParser {
    private final List<IrSignalParser> parsers;

    public static List<IrSignalParser> ircoreParsersList(String source) {
        ArrayList<IrSignalParser> parsersList = new ArrayList<IrSignalParser>(4);
        parsersList.add(new ProntoParserLoose(source));
        parsersList.add(new BracketedIrSignalParser(source));
        parsersList.add(new MultilineIrSignalParser(source));
        return parsersList;
    }

    public static MultiParser newIrCoreParser(String source) {
        return new MultiParser(MultiParser.ircoreParsersList(source), source);
    }

    public static MultiParser newIrCoreParser(List<? extends CharSequence> args) {
        return MultiParser.newIrCoreParser(String.join((CharSequence)" ", args));
    }

    public MultiParser(List<IrSignalParser> parsers, String source) {
        super(source);
        this.parsers = parsers;
    }

    public MultiParser(List<IrSignalParser> parsers, Iterable<? extends CharSequence> args) {
        this(parsers, String.join((CharSequence)" ", args));
    }

    public MultiParser(Iterable<? extends CharSequence> args) {
        this(String.join((CharSequence)" ", args));
    }

    public MultiParser(String source) {
        this(MultiParser.ircoreParsersList(source), source);
    }

    public void addParser(IrSignalParser newParser) {
        this.parsers.add(0, newParser);
    }

    @Override
    public IrSignal toIrSignal(Double fallbackFrequency, Double dummyGap) throws InvalidArgumentException {
        for (IrSignalParser parser : this.parsers) {
            IrSignal irSignal = parser.toIrSignal(fallbackFrequency, dummyGap);
            if (irSignal == null) continue;
            return irSignal;
        }
        return null;
    }

    @Override
    public IrSequence toIrSequence(Double dummyGap) throws InvalidArgumentException {
        for (IrSignalParser parser : this.parsers) {
            IrSequence irSequence = parser.toIrSequence(dummyGap);
            if (irSequence == null) continue;
            return irSequence;
        }
        return null;
    }

    @Override
    public ModulatedIrSequence toModulatedIrSequence(Double fallbackFrequency, Double dummyGap) throws InvalidArgumentException {
        for (IrSignalParser parser : this.parsers) {
            ModulatedIrSequence modulatedirSequence = parser.toModulatedIrSequence(fallbackFrequency, dummyGap);
            if (modulatedirSequence == null) continue;
            return modulatedirSequence;
        }
        return null;
    }

    @Override
    public List<IrSequence> toList(Double dummyGap) throws OddSequenceLengthException, InvalidArgumentException {
        for (IrSignalParser parser : this.parsers) {
            List<IrSequence> list = parser.toList(dummyGap);
            if (list == null) continue;
            return list;
        }
        return null;
    }
}

