/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.ircore;

import java.util.List;
import org.harctoolbox.ircore.AbstractIrParser;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.IrSignalParser;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.OddSequenceLengthException;

public class MultilineIrSignalParser
extends AbstractIrParser
implements IrSignalParser {
    private static String[] splitLines(String str) {
        String[] stringArray;
        String[] arr = str.split("[\n\r]+");
        if (arr.length <= 3) {
            stringArray = arr;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = str;
        }
        return stringArray;
    }

    public MultilineIrSignalParser(String source) {
        super(MultilineIrSignalParser.fixIrRemoteSilliness(source));
    }

    public MultilineIrSignalParser(Iterable<? extends CharSequence> args) {
        this(String.join((CharSequence)" ", args));
    }

    @Override
    public List<IrSequence> toList(Double dummyGap) throws OddSequenceLengthException {
        return this.toList(MultilineIrSignalParser.splitLines(this.getSource()), dummyGap);
    }

    @Override
    public ModulatedIrSequence toModulatedIrSequence(Double fallbackFrequency, Double dummyGap) throws OddSequenceLengthException, InvalidArgumentException {
        try {
            int pos;
            Double frequency = fallbackFrequency;
            String s = this.getSource().replace(",", " ").trim();
            if (s.startsWith("f=")) {
                pos = s.indexOf(32, 3);
                frequency = Double.valueOf(s.substring(2, pos));
                s = s.substring(pos + 1).trim();
            } else if (s.startsWith("Freq=")) {
                pos = s.indexOf(72, 6);
                frequency = Double.valueOf(s.substring(5, pos));
                s = s.substring(pos + 2).trim();
            }
            IrSequence irSequence = new IrSequence(s, dummyGap);
            return new ModulatedIrSequence(irSequence, frequency);
        }
        catch (NumberFormatException ex) {
            throw new InvalidArgumentException(ex);
        }
    }

    @Override
    public IrSignal toIrSignal(Double fallbackFrequency, Double dummyGap) throws OddSequenceLengthException {
        try {
            return MultilineIrSignalParser.mkIrSignal(MultilineIrSignalParser.splitLines(this.getSource()), fallbackFrequency, dummyGap);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public String getName() {
        return "MultilineIrSignal";
    }
}

