/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.ircore;

import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ThisCannotHappenException;

public abstract class Pronto {
    public static final int CHARS_IN_DIGIT = 4;
    public static final double FREQUENCY_CONSTANT = 0.241246;
    private static final int FREQUENCY_ZERO_FALLBACK_FREQUNCY_CODE = 10;
    public static final String HEX_STRING_FORMAT = "%04X";
    protected static final int LEARNED_CODE = 0;
    protected static final int LEARNED_UNMODULATED_CODE = 256;
    protected static final int TYPE_INDEX = 0;
    protected static final int FREQUENCY_INDEX = 1;
    protected static final int INTRO_LENGTH_INDEX = 2;
    protected static final int REPEAT_LENGTH_INDEX = 3;
    protected static final int NUMBER_METADATA = 4;
    protected static final int MIN_CCF_LENGTH = 6;
    private static final Logger logger = Logger.getLogger(Pronto.class.getName());

    public static String formatInteger(int n) {
        return String.format(HEX_STRING_FORMAT, n);
    }

    public static int frequencyCode(double frequency) {
        return frequency > 0.0 ? (int)Math.round(1000000.0 / (frequency * 0.241246)) : 10;
    }

    public static double frequency(int code) throws InvalidArgumentException {
        return 1.0 / Pronto.pulseTime(code);
    }

    public static double pulseTime(int code) throws InvalidArgumentException {
        if (code <= 0) {
            throw new InvalidArgumentException();
        }
        return IrCoreUtils.microseconds2seconds((double)code * 0.241246);
    }

    public static int pulses(double time, double frequency) throws InvalidArgumentException {
        if (frequency < 0.0) {
            throw new InvalidArgumentException("Frequency must be >= 0");
        }
        double actualFrequency = frequency > 0.0 ? frequency : Pronto.frequency(10);
        return Math.min((int)Math.round(time * actualFrequency), 65535);
    }

    public static int pulsesMicroSeconds(double time, double frequency) throws InvalidArgumentException {
        return Pronto.pulses(IrCoreUtils.microseconds2seconds(time), frequency);
    }

    private static double[] usArray(int frequencyCode, int[] ccfArray, int beg, int end) throws InvalidArgumentException {
        double pulseTimeMicrosSeconds = IrCoreUtils.seconds2microseconds(Pronto.pulseTime(frequencyCode));
        double[] data = new double[end - beg];
        for (int i = beg; i < end; ++i) {
            data[i - beg] = pulseTimeMicrosSeconds * (double)ccfArray[i];
        }
        return data;
    }

    public static IrSignal parse(int[] ccf) throws OddSequenceLengthException, InvalidArgumentException {
        return Pronto.parse(ccf, false);
    }

    private static IrSignal parse(int[] ccf, boolean loose) throws OddSequenceLengthException, InvalidArgumentException {
        if (ccf.length < 6) {
            throw new InvalidArgumentException("Pronto Hex is invalid since it is just " + ccf.length + " < " + 6 + " numbers long.");
        }
        if (ccf.length % 2 != 0) {
            throw new OddSequenceLengthException("Pronto Hex is invalid since it has an odd number (" + ccf.length + ") of durations.");
        }
        int type = ccf[0];
        int frequencyCode = ccf[1];
        int introLength = ccf[2];
        int repeatLength = ccf[3];
        int expectedLength = 4 + 2 * (introLength + repeatLength);
        if (expectedLength != ccf.length) {
            if (loose) {
                logger.log(Level.WARNING, "Inconsistent length in Pronto Hex (claimed {0} pairs, was {1} pairs). Intro length set to {1} pairs; repeat length set to 0.", new Object[]{introLength + repeatLength, (ccf.length - 4) / 2});
                introLength = (ccf.length - 4) / 2;
                repeatLength = 0;
            } else {
                throw new InvalidArgumentException("Inconsistent length in Pronto Hex (claimed " + (introLength + repeatLength) + " pairs, was " + (ccf.length - 4) / 2 + " pairs).");
            }
        }
        IrSignal irSignal = null;
        switch (type) {
            case 0: 
            case 256: {
                double[] intro = Pronto.usArray(frequencyCode, ccf, 4, 4 + 2 * introLength);
                double[] repeat = Pronto.usArray(frequencyCode, ccf, 4 + 2 * introLength, 4 + 2 * (introLength + repeatLength));
                IrSequence introSequence = new IrSequence(intro);
                IrSequence repeatSequence = new IrSequence(repeat);
                irSignal = new IrSignal(introSequence, repeatSequence, null, (Double)(type == 0 ? Pronto.frequency(frequencyCode) : 0.0), null);
                break;
            }
            default: {
                throw new InvalidArgumentException("Pronto Hex type 0x" + Pronto.formatInteger(type) + " not supported.");
            }
        }
        return irSignal;
    }

    public static IrSignal parse(String ccfString) throws NonProntoFormatException, InvalidArgumentException {
        return Pronto.parse(ccfString, false);
    }

    public static IrSignal parseLoose(String ccfString) throws NonProntoFormatException, InvalidArgumentException {
        return Pronto.parse(ccfString, true);
    }

    static IrSignal parse(String ccfString, boolean loose) throws NonProntoFormatException, InvalidArgumentException {
        int[] ccf = Pronto.parseAsInts(ccfString);
        return Pronto.parse(ccf, loose);
    }

    public static IrSignal parse(String[] array, int begin) throws NonProntoFormatException, InvalidArgumentException {
        int[] ccf = Pronto.parseAsInts(array, begin);
        return Pronto.parse(ccf);
    }

    public static IrSignal parse(String[] array) throws InvalidArgumentException, NonProntoFormatException {
        return Pronto.parse(array, 0);
    }

    public static IrSignal parse(List<String> list) throws InvalidArgumentException, NonProntoFormatException {
        int[] ccf = Pronto.parseAsInts(list);
        return Pronto.parse(ccf);
    }

    protected static int[] parseAsInts(String ccfString) throws NonProntoFormatException {
        String[] array = ccfString.trim().split("\\s+");
        return Pronto.parseAsInts(array, 0);
    }

    public static int[] parseAsInts(String[] array, int begin) throws NonProntoFormatException {
        int[] ccf = new int[array.length];
        for (int i = begin; i < array.length; ++i) {
            String string = array[i];
            if (string == null || string.isEmpty() || string.charAt(0) == '-' || string.charAt(0) == '+' || string.length() != 4) {
                throw new NonProntoFormatException(string, i);
            }
            try {
                ccf[i] = Integer.parseInt(string, 16);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new NonProntoFormatException(string, i);
            }
        }
        return ccf;
    }

    protected static int[] parseAsInts(List<String> list) throws NonProntoFormatException {
        String[] x = list.toArray(new String[0]);
        return Pronto.parseAsInts(x, 0);
    }

    public static int[] toArray(IrSignal irSignal) throws OddSequenceLengthException, InvalidArgumentException {
        int i;
        if (irSignal.getIntroLength() % 2 != 0 || irSignal.getRepeatLength() % 2 != 0) {
            throw new OddSequenceLengthException();
        }
        if (irSignal.getEndingLength() != 0) {
            logger.log(Level.WARNING, "When computing the Pronto representation, a (non-empty) ending sequence was ignored");
        }
        int[] data = new int[4 + irSignal.getIntroLength() + irSignal.getRepeatLength()];
        int index = 0;
        int frequency = irSignal.getFrequencyWithDefault().intValue();
        data[index++] = frequency > 0 ? 0 : 256;
        data[index++] = Pronto.frequencyCode(frequency);
        data[index++] = irSignal.getIntroLength() / 2;
        data[index++] = irSignal.getRepeatLength() / 2;
        for (i = 0; i < irSignal.getIntroLength(); ++i) {
            data[index++] = Pronto.pulsesMicroSeconds(irSignal.getIntroDouble(i), frequency);
        }
        for (i = 0; i < irSignal.getRepeatLength(); ++i) {
            data[index++] = Pronto.pulsesMicroSeconds(irSignal.getRepeatDouble(i), frequency);
        }
        return data;
    }

    public static String toString(IrSignal irSignal) {
        try {
            return Pronto.toString(Pronto.toArray(irSignal));
        }
        catch (InvalidArgumentException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    public static String toString(int[] array) {
        StringJoiner s = new StringJoiner(" ");
        for (int n : array) {
            s.add(String.format(HEX_STRING_FORMAT, n));
        }
        return s.toString();
    }

    public static void main(String[] args) {
        try {
            IrSignal irSignal = args.length == 1 ? Pronto.parse(args[0]) : Pronto.parse(args);
            System.out.println(irSignal);
        }
        catch (InvalidArgumentException | NonProntoFormatException ex) {
            Logger.getLogger(Pronto.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected Pronto() {
    }

    public static class NonProntoFormatException
    extends IrCoreException {
        public NonProntoFormatException(String string, int pos) {
            super("Position " + pos + ": \"" + string + "\" is not a four digit hexadecimal string.");
        }
    }
}

