/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.ircore;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.AbstractIrParser;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.IrSignalParser;
import org.harctoolbox.ircore.Pronto;

public class ProntoParser
extends AbstractIrParser
implements IrSignalParser {
    private static final Logger logger = Logger.getLogger(ProntoParser.class.getName());

    public static IrSignal parse(String str) throws InvalidArgumentException {
        ProntoParser instance = new ProntoParser(str);
        return instance.toIrSignal();
    }

    public ProntoParser(String source) {
        super(source);
    }

    public ProntoParser(Iterable<? extends CharSequence> args) {
        super(args);
    }

    @Override
    public IrSignal toIrSignal(Double fallbackFrequency, Double dummyGap) throws InvalidArgumentException {
        return this.toIrSignal(fallbackFrequency, dummyGap, false);
    }

    protected IrSignal toIrSignal(Double fallbackFrequency, Double dummyGap, boolean loose) throws InvalidArgumentException {
        try {
            IrSignal irSignal = Pronto.parse(this.getSource(), loose);
            if (fallbackFrequency != null) {
                logger.log(Level.FINE, "Explicit frequency with a Pronto type signal meaningless, thus ignored.");
            }
            return irSignal;
        }
        catch (Pronto.NonProntoFormatException ex) {
            logger.log(Level.FINER, "Tried as Pronto, gave up ({0})", ex.getMessage());
            return null;
        }
    }

    @Override
    public String getName() {
        return "Pronto Hex";
    }
}

