/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.ircore;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ThingsLineParser<T> {
    private static final Logger logger = Logger.getLogger(ThingsLineParser.class.getName());
    private final String commentPrefix;
    private final ThingParser parser;

    public ThingsLineParser(ThingParser thingParser, String commentPrefix) {
        this.parser = thingParser;
        this.commentPrefix = commentPrefix;
    }

    public List<T> readThings(String urlOrFilename, String charSetName, boolean multiLines) throws IOException {
        try (InputStreamReader reader = IrCoreUtils.getInputReader(urlOrFilename, charSetName);){
            List<T> list = this.readThings(reader, multiLines);
            return list;
        }
    }

    public List<T> readThings(String input, String xslt, String encoding, boolean multiLines) throws SAXException, IOException, UnsupportedEncodingException, TransformerException {
        Objects.requireNonNull(xslt);
        try (InputStreamReader reader = XmlUtils.mkReaderXml(input, xslt, encoding);){
            List<T> list = this.readThings(reader, multiLines);
            return list;
        }
    }

    public List<T> readThings(Reader reader, boolean multiLines) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        ArrayList<T> list = new ArrayList<T>(4);
        while (true) {
            try {
                T thing;
                while ((thing = this.parseThing(in, multiLines)) != null) {
                    list.add(thing);
                }
            }
            catch (IOException | InvalidArgumentException ex) {
                logger.log(Level.FINE, "{0}", ex.getMessage());
                continue;
            }
            break;
        }
        return list;
    }

    public Map<String, T> readNamedThings(String urlOrFilename, String charSetName) throws IOException {
        try (InputStreamReader reader = IrCoreUtils.getInputReader(urlOrFilename, charSetName);){
            Map<String, T> map = this.readNamedThings(reader);
            return map;
        }
    }

    public Map<String, T> readNamedThings(String namedInput, String xslt, String encoding) throws SAXException, IOException, TransformerException {
        Objects.requireNonNull(xslt);
        try (InputStreamReader reader = XmlUtils.mkReaderXml(namedInput, xslt, encoding);){
            Map<String, T> map = this.readNamedThings(reader);
            return map;
        }
    }

    public Map<String, T> readNamedThings(String namedInput, Document stylesheet, String encoding) throws SAXException, IOException, TransformerException {
        Objects.requireNonNull(stylesheet);
        try (InputStreamReader reader = XmlUtils.mkReaderXml(namedInput, stylesheet, encoding);){
            Map<String, T> map = this.readNamedThings(reader);
            return map;
        }
    }

    public Map<String, T> readNamedThings(Reader reader) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(reader);
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>(4);
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || this.commentPrefix != null && line.startsWith(this.commentPrefix)) continue;
            String name = line;
            try {
                T thing = this.parseThing(in, true);
                if (thing == null) continue;
                map.put(name, thing);
            }
            catch (NumberFormatException | InvalidArgumentException ex) {
                logger.log(Level.WARNING, "{0}", ex.getMessage());
            }
        }
        return map;
    }

    T parseThing(BufferedReader in, boolean multiLines) throws IOException, InvalidArgumentException {
        String line;
        ArrayList<String> list = new ArrayList<String>(multiLines ? 4 : 1);
        do {
            if ((line = in.readLine()) != null) continue;
            return null;
        } while (line.trim().isEmpty());
        list.add(line);
        while (multiLines && (line = in.readLine()) != null && !line.trim().isEmpty()) {
            list.add(line);
        }
        return (T)this.parser.newThing(list);
    }

    public static interface ThingParser {
        public Object newThing(List<String> var1) throws InvalidArgumentException;
    }
}

