/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.DurationType;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrStream;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.Name;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.Numerical;
import org.harctoolbox.irp.ParserDriver;
import org.harctoolbox.irp.PrimaryItemExpression;
import org.harctoolbox.irp.RecognizeData;
import org.harctoolbox.irp.RenderData;
import org.harctoolbox.irp.SignalRecognitionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Assignment
extends IrpObject
implements IrStreamItem,
Numerical {
    private static final Logger logger = Logger.getLogger(Assignment.class.getName());
    private Name name;
    private Expression value;

    public static long parse(String str, NameEngine nameEngine) throws NameUnassignedException {
        Assignment assignment = new Assignment(str);
        return assignment.value.toLong(nameEngine);
    }

    public Assignment(String str) {
        this(new ParserDriver(str));
    }

    private Assignment(ParserDriver parserDriver) {
        this(parserDriver.getParser().assignment());
    }

    public Assignment(IrpParser.AssignmentContext assignment) {
        super(assignment);
        this.name = new Name(assignment.name());
        this.value = Expression.newExpression(assignment.expression());
    }

    public Assignment(IrpParser.NameContext name, IrpParser.ExpressionContext be) {
        this(new Name(name), Expression.newExpression(be));
    }

    public Assignment(Name name, Expression expression) {
        super(null);
        this.name = name;
        this.value = expression;
    }

    @Override
    public Assignment substituteConstantVariables(Map<String, Long> constantVariables) {
        return new Assignment(this.name, PrimaryItemExpression.newExpression(this.value.substituteConstantVariables(constantVariables)));
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this.name);
        hash = 43 * hash + Objects.hashCode(this.value);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Assignment)) {
            return false;
        }
        Assignment other = (Assignment)obj;
        return this.name.equals(other.name) && this.value.equals(other.value);
    }

    @Override
    public boolean isEmpty(NameEngine nameEngine) {
        return true;
    }

    @Override
    public long toLong(NameEngine nameEngine) throws NameUnassignedException {
        return this.value.toLong(nameEngine);
    }

    @Override
    public BitwiseParameter toBitwiseParameter(RecognizeData recognizeData) {
        return this.value.toBitwiseParameter(recognizeData);
    }

    @Override
    public long toLong() throws NameUnassignedException {
        return this.toLong(NameEngine.EMPTY);
    }

    public String getName() {
        return this.name.toString();
    }

    @Override
    public String toIrpString(int radix) {
        return this.name.toIrpString(radix) + "=" + this.value.toIrpString(radix);
    }

    @Override
    public void render(RenderData renderData, List<BitSpec> bitSpecs) throws NameUnassignedException {
        NameEngine nameEngine = renderData.getNameEngine();
        long val = this.value.toLong(nameEngine);
        try {
            nameEngine.define(this.name.toString(), val);
        }
        catch (InvalidNameException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    @Override
    public void evaluate(RenderData renderData, List<BitSpec> bitSpecStack) throws NameUnassignedException {
        this.render(renderData, bitSpecStack);
    }

    @Override
    public BareIrStream extractPass(IrSignal.Pass pass, IrStream.PassExtractorState state) {
        return new BareIrStream(this);
    }

    @Override
    public Element toElement(Document document) {
        Element element = super.toElement(document);
        element.appendChild(this.name.toElement(document));
        element.appendChild(this.value.toElement(document));
        return element;
    }

    @Override
    public Integer numberOfBareDurations() {
        return 0;
    }

    @Override
    public Integer numberOfDurations() {
        return 0;
    }

    @Override
    public void decode(RecognizeData recognizeData, List<BitSpec> bitSpecStack, boolean isLast) throws SignalRecognitionException {
        logger.log(recognizeData.logRecordEnter(this));
        try {
            String nameString = this.name.toString();
            BitwiseParameter val = this.value.toBitwiseParameter(recognizeData);
            recognizeData.assignment(nameString, val.getValue());
        }
        catch (InvalidNameException ex) {
            throw new SignalRecognitionException(ex);
        }
        logger.log(recognizeData.logRecordExit(this));
    }

    @Override
    public boolean interleavingOk(DurationType last, boolean gapFlashBitSpecs) {
        return true;
    }

    @Override
    public boolean interleavingOk(DurationType toCheck, DurationType last, boolean gapFlashBitSpecs) {
        return true;
    }

    @Override
    public DurationType endingDurationType(DurationType last, boolean gapFlashBitSpecs) {
        return DurationType.none;
    }

    @Override
    public DurationType startingDuratingType(DurationType last, boolean gapFlashBitSpecs) {
        return DurationType.none;
    }

    @Override
    public int weight() {
        return this.name.weight() + this.value.weight();
    }

    @Override
    public boolean hasExtent() {
        return false;
    }

    @Override
    public Set<String> assignmentVariables() {
        HashSet<String> list = new HashSet<String>(1);
        list.add(this.name.toString());
        return list;
    }

    @Override
    public Map<String, Object> propertiesMap(GeneralSpec generalSpec, NameEngine nameEngine) {
        Map<String, Object> map = super.propertiesMap(2);
        map.put("name", this.name.propertiesMap(false, generalSpec, nameEngine));
        map.put("expression", this.value.propertiesMap(true, generalSpec, nameEngine));
        return map;
    }

    @Override
    public Double microSeconds(GeneralSpec generalSpec, NameEngine nameEngine) {
        return 0.0;
    }

    @Override
    public boolean nonConstantBitFieldLength() {
        return false;
    }

    @Override
    public Integer guessParameterLength(String name) {
        return null;
    }

    @Override
    public TreeSet<Double> allDurationsInMicros(GeneralSpec generalSpec, NameEngine nameEngine) {
        return new TreeSet<Double>();
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return true;
    }
}

