/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.irp.BitField;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.BitspecIrstream;
import org.harctoolbox.irp.Duration;
import org.harctoolbox.irp.DurationType;
import org.harctoolbox.irp.EvaluatedIrStream;
import org.harctoolbox.irp.Flash;
import org.harctoolbox.irp.Gap;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrStream;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.ParameterSpecs;
import org.harctoolbox.irp.ParserDriver;
import org.harctoolbox.irp.RecognizeData;
import org.harctoolbox.irp.RenderData;
import org.harctoolbox.irp.SignalRecognitionException;
import org.harctoolbox.irp.Variation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class BareIrStream
extends IrpObject
implements IrStreamItem {
    private static final Logger logger = Logger.getLogger(BareIrStream.class.getName());
    private List<IrStreamItem> irStreamItems;
    private Integer numberInfiniteRepeatsCached = null;

    static DurationType startingDurationType(BareIrStream bareIrStream, DurationType last, boolean gapFlashBitSpecs) {
        return bareIrStream == null ? DurationType.none : bareIrStream.startingDuratingType(last, gapFlashBitSpecs);
    }

    static DurationType endingDurationType(BareIrStream bareIrStream, DurationType last, boolean gapFlashBitSpecs) {
        return bareIrStream == null ? DurationType.none : bareIrStream.startingDuratingType(last, gapFlashBitSpecs);
    }

    static boolean interleavingOk(BareIrStream bareIrStream, DurationType last, boolean gapFlashBitspecs) {
        return bareIrStream == null || bareIrStream.interleavingOk(last, gapFlashBitspecs);
    }

    static boolean interleavingOk(DurationType toCheck, BareIrStream bareIrStream, DurationType last, boolean gapFlashBitspecs) {
        return bareIrStream == null || bareIrStream.interleavingOk(last, gapFlashBitspecs);
    }

    private static List<IrStreamItem> parse(List<IrpParser.Irstream_itemContext> list) {
        ArrayList<IrStreamItem> irStreamItems = new ArrayList<IrStreamItem>(list.size());
        list.stream().map(item -> IrStreamItem.newIrStreamItem(item)).forEachOrdered(irStreamItem -> irStreamItems.add((IrStreamItem)irStreamItem));
        return irStreamItems;
    }

    private static List<IrStreamItem> mkIrStreamItemList(IrStreamItem irStreamItem) {
        ArrayList<IrStreamItem> list = new ArrayList<IrStreamItem>(1);
        list.add(irStreamItem);
        return list;
    }

    public BareIrStream(IrpParser.Bare_irstreamContext ctx) {
        super(ctx);
        this.irStreamItems = BareIrStream.parse(ctx.irstream_item());
    }

    public BareIrStream() {
        this(new ArrayList<IrStreamItem>(0));
    }

    public BareIrStream(List<IrStreamItem> list) {
        super(null);
        this.irStreamItems = list;
    }

    public BareIrStream(IrStreamItem irStreamItem) {
        this(BareIrStream.mkIrStreamItemList(irStreamItem));
    }

    private BareIrStream(ParserDriver parserDriver) {
        this(parserDriver.getParser().bare_irstream());
    }

    public BareIrStream(String s) {
        this(new ParserDriver(s));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BareIrStream)) {
            return false;
        }
        BareIrStream other = (BareIrStream)obj;
        if (this.irStreamItems.size() != other.irStreamItems.size()) {
            return false;
        }
        for (int i = 0; i < this.irStreamItems.size(); ++i) {
            if (this.irStreamItems.get(i).equals(other.irStreamItems.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.irStreamItems);
        return hash;
    }

    public void concatenate(BareIrStream bareIrStream) {
        this.irStreamItems.addAll(bareIrStream.irStreamItems);
    }

    @Override
    public boolean isEmpty(NameEngine nameEngine) {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return this.irStreamItems.isEmpty();
    }

    @Override
    public int numberOfInfiniteRepeats() {
        if (this.numberInfiniteRepeatsCached == null) {
            this.numberInfiniteRepeatsCached = 0;
            this.irStreamItems.forEach(item -> {
                this.numberInfiniteRepeatsCached = this.numberInfiniteRepeatsCached + item.numberOfInfiniteRepeats();
            });
        }
        return this.numberInfiniteRepeatsCached;
    }

    EvaluatedIrStream evaluate(IrSignal.Pass state, IrSignal.Pass pass, GeneralSpec generalSpec, NameEngine nameEngine) throws NameUnassignedException {
        RenderData renderData = new RenderData(generalSpec, nameEngine);
        this.evaluate(renderData, new ArrayList<BitSpec>(0));
        return renderData.getEvaluatedIrStream();
    }

    public boolean startsWithFlash() {
        for (IrStreamItem irStreamItem : this.irStreamItems) {
            if (irStreamItem instanceof Flash) {
                return true;
            }
            if (irStreamItem instanceof Gap) {
                return false;
            }
            if (irStreamItem instanceof BitField) {
                return false;
            }
            if (irStreamItem instanceof BitspecIrstream) {
                return ((BitspecIrstream)irStreamItem).startsWithFlash();
            }
            if (irStreamItem instanceof BareIrStream) {
                return ((BareIrStream)irStreamItem).startsWithFlash();
            }
            if (irStreamItem instanceof IrStream) {
                return ((IrStream)irStreamItem).startsWithFlash();
            }
            if (!(irStreamItem instanceof Variation)) continue;
            return ((Variation)irStreamItem).startsWithFlash();
        }
        return false;
    }

    public boolean hasVariation(IrSignal.Pass pass) {
        for (IrStreamItem irStreamItem : this.irStreamItems) {
            if (irStreamItem instanceof Variation && ((Variation)irStreamItem).hasPart(pass)) {
                return true;
            }
            if (irStreamItem instanceof BitspecIrstream && ((BitspecIrstream)irStreamItem).hasVariation(pass)) {
                return true;
            }
            if (irStreamItem instanceof BareIrStream && ((BareIrStream)irStreamItem).hasVariation(pass)) {
                return true;
            }
            if (!(irStreamItem instanceof IrStream) || !((IrStream)irStreamItem).hasVariation(pass)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVariationNonRecursive() {
        return this.irStreamItems.stream().anyMatch(irStreamItem -> irStreamItem instanceof Variation);
    }

    @Override
    public String toIrpString(int radix) {
        StringBuilder str = new StringBuilder(this.irStreamItems.size() * 20);
        ArrayList list = new ArrayList(this.irStreamItems.size());
        this.irStreamItems.stream().forEach(item -> list.add(item.toIrpString(radix)));
        return str.append(String.join((CharSequence)",", list)).toString();
    }

    @Override
    public Integer numberOfBitSpecs() {
        int sum = 0;
        sum = this.irStreamItems.stream().map(item -> item.numberOfBitSpecs()).reduce(sum, Integer::sum);
        return sum;
    }

    @Override
    public Element toElement(Document document) {
        Element element = super.toElement(document);
        return this.fillElement(document, element);
    }

    public Element toElement(Document document, String tagName) {
        Element element = document.createElement(tagName);
        return this.fillElement(document, element);
    }

    private Element fillElement(Document document, Element element) {
        Integer nod;
        Integer nob;
        Integer nobd = this.numberOfBareDurations();
        if (nobd != null) {
            element.setAttribute("numberOfBareDurations", Integer.toString(nobd));
        }
        if ((nob = this.numberOfBits()) != null) {
            element.setAttribute("numberOfBits", Integer.toString(nob));
        }
        if ((nod = this.numberOfDurations()) != null) {
            element.setAttribute("numberOfDurations", Integer.toString(nod));
        }
        element.setAttribute("numberOfBitSpecs", Integer.toString(this.numberOfBitSpecs()));
        this.irStreamItems.forEach(item -> element.appendChild(item.toElement(document)));
        return element;
    }

    @Override
    public Integer numberOfBareDurations() {
        int sum = 0;
        for (IrStreamItem item : this.irStreamItems) {
            Integer nobd = item.numberOfBareDurations();
            if (nobd == null) {
                return null;
            }
            sum += nobd.intValue();
        }
        return sum;
    }

    @Override
    public Integer numberOfBits() {
        int sum = 0;
        for (IrStreamItem item : this.irStreamItems) {
            Integer nob = item.numberOfBits();
            if (nob == null) {
                return null;
            }
            sum += nob.intValue();
        }
        return sum;
    }

    @Override
    public void decode(RecognizeData recognizeData, List<BitSpec> bitSpecStack, boolean isLast) throws SignalRecognitionException {
        logger.log(recognizeData.logRecordEnter(this));
        int currentLevel = recognizeData.getLevel();
        recognizeData.setLevel(currentLevel + 1);
        Iterator<IrStreamItem> it = this.irStreamItems.iterator();
        while (it.hasNext()) {
            IrStreamItem irStreamItem = it.next();
            irStreamItem.decode(recognizeData, bitSpecStack, isLast && !it.hasNext());
        }
        recognizeData.setLevel(currentLevel);
        logger.log(recognizeData.logRecordExit(this));
    }

    @Override
    public void evaluate(RenderData renderData, List<BitSpec> bitSpecStack) throws NameUnassignedException {
        this.render(renderData, bitSpecStack);
    }

    @Override
    public void render(RenderData renderData, List<BitSpec> bitSpecs) throws NameUnassignedException {
        for (IrStreamItem irStreamItem : this.irStreamItems) {
            irStreamItem.render(renderData, bitSpecs);
        }
    }

    @Override
    public BareIrStream extractPass(IrSignal.Pass pass, IrStream.PassExtractorState state) {
        ArrayList<IrStreamItem> list = new ArrayList<IrStreamItem>(this.irStreamItems.size());
        for (IrStreamItem irStreamItem : this.irStreamItems) {
            irStreamItem.updateStateWhenEntering(pass, state);
            if (state.getState() == pass) {
                list.addAll(irStreamItem.extractPass(pass, state).getIrStreamItems());
            }
            irStreamItem.updateStateWhenExiting(pass, state);
            if (state.getState() != IrSignal.Pass.finish) continue;
            break;
        }
        return new BareIrStream(list);
    }

    @Override
    public boolean nonConstantBitFieldLength() {
        return this.irStreamItems.stream().anyMatch(irStreamItem -> irStreamItem.nonConstantBitFieldLength());
    }

    @Override
    public Integer numberOfDurations() {
        int sum = 0;
        for (IrStreamItem irStreamItem : this.irStreamItems) {
            Integer numberDurations = irStreamItem.numberOfDurations();
            if (numberDurations == null) {
                return null;
            }
            sum += numberDurations.intValue();
        }
        return sum;
    }

    public List<Duration> getDurations() {
        ArrayList<Duration> result = new ArrayList<Duration>(this.irStreamItems.size());
        this.irStreamItems.stream().filter(irStreamItem -> irStreamItem instanceof Duration).forEachOrdered(irStreamItem -> result.add((Duration)irStreamItem));
        return result;
    }

    Integer numberOfDurations(int bitspecLength) {
        Integer nod = this.numberOfDurations();
        if (nod != null) {
            return nod;
        }
        Integer nobd = this.numberOfBareDurations();
        Integer nob = this.numberOfBits();
        return nobd != null && nob != null ? Integer.valueOf(nobd + bitspecLength * nob) : null;
    }

    @Override
    public DurationType endingDurationType(DurationType last, boolean gapFlashBitSpecs) {
        DurationType current = last;
        for (IrStreamItem item : this.irStreamItems) {
            current = item.endingDurationType(last, gapFlashBitSpecs);
        }
        return current;
    }

    @Override
    public DurationType startingDuratingType(DurationType last, boolean gapFlashBitSpecs) {
        return this.irStreamItems.isEmpty() ? DurationType.none : this.irStreamItems.get(0).startingDuratingType(last, gapFlashBitSpecs);
    }

    @Override
    public boolean interleavingOk(DurationType last, boolean gapFlashBitSpecs) {
        DurationType current = last;
        for (IrStreamItem item : this.irStreamItems) {
            if (!item.interleavingOk(current, gapFlashBitSpecs)) {
                return false;
            }
            current = item.endingDurationType(last, gapFlashBitSpecs);
        }
        return true;
    }

    @Override
    public boolean interleavingOk(DurationType toCheck, DurationType last, boolean gapFlashBitSpecs) {
        DurationType current = last;
        for (IrStreamItem item : this.irStreamItems) {
            if (!item.interleavingOk(toCheck, current, gapFlashBitSpecs)) {
                return false;
            }
            current = item.endingDurationType(last, gapFlashBitSpecs);
        }
        return true;
    }

    @Override
    public int weight() {
        int weight = 0;
        weight = this.irStreamItems.stream().map(item -> item.weight()).reduce(weight, Integer::sum);
        return weight;
    }

    @Override
    public boolean hasExtent() {
        return this.irStreamItems.stream().anyMatch(item -> item.hasExtent());
    }

    public List<IrStreamItem> getIrStreamItems() {
        return Collections.unmodifiableList(this.irStreamItems);
    }

    @Override
    public Set<String> assignmentVariables() {
        HashSet<String> set = new HashSet<String>(4);
        this.irStreamItems.stream().forEach(item -> set.addAll(item.assignmentVariables()));
        return set;
    }

    public Map<String, Object> topLevelPropertiesMap(GeneralSpec generalSpec, NameEngine nameEngine, int bitSpecLength) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("kind", "FunctionBody");
        Map<String, Object> body = this.propertiesMap(generalSpec, nameEngine);
        map.put("irStream", body);
        map.put("reset", this.hasExtent());
        map.put("numberOfDurations", this.numberOfDurations(bitSpecLength));
        return map;
    }

    @Override
    public Map<String, Object> propertiesMap(GeneralSpec generalSpec, NameEngine nameEngine) {
        ArrayList list = new ArrayList(this.irStreamItems.size());
        this.irStreamItems.stream().map(item -> item.propertiesMap(generalSpec, nameEngine)).filter(m -> !m.isEmpty()).forEachOrdered(m -> {
            if (m.containsKey("items")) {
                list.addAll((Collection)m.get("items"));
            } else {
                list.add(m);
            }
        });
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("kind", this.getClass().getSimpleName());
        result.put("items", list);
        return result;
    }

    double averageDuration(GeneralSpec generalSpec, NameEngine nameEngine) {
        double sum = 0.0;
        sum = this.irStreamItems.stream().map(item -> item.microSeconds(generalSpec, nameEngine)).reduce(sum, (accumulator, _item) -> accumulator + _item);
        return sum / (double)this.irStreamItems.size();
    }

    @Override
    public Double microSeconds(GeneralSpec generalSpec, NameEngine nameEngine) {
        return null;
    }

    @Override
    public Integer guessParameterLength(String name) {
        for (IrStreamItem item : this.irStreamItems) {
            Integer result = item.guessParameterLength(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public BareIrStream substituteConstantVariables(Map<String, Long> constantVariables) {
        ArrayList<IrStreamItem> newList = new ArrayList<IrStreamItem>(this.irStreamItems.size());
        this.irStreamItems.forEach(item -> newList.add(item.substituteConstantVariables(constantVariables)));
        return new BareIrStream(newList);
    }

    @Override
    public TreeSet<Double> allDurationsInMicros(GeneralSpec generalSpec, NameEngine nameEngine) {
        TreeSet<Double> result = new TreeSet<Double>();
        this.irStreamItems.forEach(item -> result.addAll(item.allDurationsInMicros(generalSpec, nameEngine)));
        return result;
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return this.irStreamItems.stream().noneMatch(irStreamItem -> !irStreamItem.constant(nameEngine));
    }

    @Override
    public void createParameterSpecs(ParameterSpecs parameterSpecs) throws InvalidNameException {
        for (IrStreamItem irStreamItem : this.irStreamItems) {
            irStreamItem.createParameterSpecs(parameterSpecs);
        }
    }
}

