/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.Number;
import org.harctoolbox.irp.Protocol;

public final class BitCounter {
    private final Map<Integer, BitCounterType> table;
    private int numberBits;
    private final BitCounterType unassigned;

    public static Map<String, BitCounter> scrutinizeProtocols(Iterable<Protocol> protocols) {
        LinkedHashMap<String, BitCounter> result = new LinkedHashMap<String, BitCounter>(4);
        for (Protocol protocol : protocols) {
            NameEngine definitions = protocol.getDefinitions();
            for (Map.Entry<String, Expression> kvp : definitions) {
                String name = kvp.getKey();
                Number value = kvp.getValue().toNumber();
                if (!result.containsKey(name)) {
                    Integer length = protocol.guessParameterLength(name);
                    result.put(name, length != null ? new BitCounter(length, false) : new BitCounter(true));
                }
                BitCounter bitCounter = result.get(name);
                bitCounter.aggregate(value);
            }
        }
        return result;
    }

    public BitCounter() {
        this(0, false);
    }

    public BitCounter(boolean unassignedIsZero) {
        this(0, unassignedIsZero);
    }

    public BitCounter(int length, boolean unassignedIsZero) {
        this.table = new HashMap<Integer, BitCounterType>(length);
        this.numberBits = length;
        this.unassigned = unassignedIsZero ? BitCounterType.zero : BitCounterType.virgin;
    }

    public BitCounter(int length) {
        this(length, false);
    }

    public int getNumberBits() {
        return this.numberBits;
    }

    public BitCounterType getType(int n) {
        BitCounterType val = this.table.get(n);
        return val != null ? val : this.unassigned;
    }

    public String toString(CharSequence delimiter) {
        StringJoiner str = new StringJoiner(delimiter);
        for (int i = this.numberBits - 1; i >= 0; --i) {
            str.add(this.getType(i).toString());
        }
        return str.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public List<Integer> toIntSequence() {
        ArrayList<Integer> list = new ArrayList<Integer>(16);
        boolean lastVarying = this.getType(this.numberBits - 1) == BitCounterType.varying;
        int length = 1;
        for (int i = this.numberBits - 2; i >= 0; --i) {
            boolean varying;
            boolean bl = varying = this.getType(i) == BitCounterType.varying;
            if (varying == lastVarying) {
                ++length;
                continue;
            }
            list.add(length);
            length = 1;
            lastVarying = varying;
        }
        list.add(length);
        return list;
    }

    public String toIntSequenceString() {
        List<Integer> list = this.toIntSequence();
        StringJoiner stringJoiner = new StringJoiner(",");
        list.forEach(len -> stringJoiner.add(Integer.toString(len)));
        return stringJoiner.toString();
    }

    public void aggregate(long x, int length) {
        int bitNo;
        long left = x;
        for (bitNo = 0; left != 0L || bitNo < length; left >>= 1, ++bitNo) {
            this.table.put(bitNo, this.getType(bitNo).update((int)left & 1));
        }
        this.numberBits = Math.max(this.numberBits, bitNo);
    }

    public void aggregate(Number x, int length) {
        int bitNo;
        Number left = x;
        for (bitNo = 0; !left.isZero() || bitNo < length; ++bitNo) {
            this.table.put(bitNo, this.getType(bitNo).update((int)left.and(1L)));
            left = left.shiftRight(1);
        }
        this.numberBits = Math.max(this.numberBits, bitNo);
    }

    public void aggregate(long x) {
        this.aggregate(x, this.numberBits);
    }

    public void aggregate(Number x) {
        this.aggregate(x, this.numberBits);
    }

    public static enum BitCounterType {
        zero,
        one,
        varying,
        virgin;


        public BitCounterType update(int bit) {
            return this == zero ? (bit == 0 ? zero : varying) : (this == one ? (bit != 0 ? one : varying) : (this == varying ? varying : (bit == 0 ? zero : one)));
        }

        public String toString() {
            return this == zero ? "0" : (this == one ? "1" : (this == virgin ? " " : "*"));
        }
    }
}

