/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.EquationSolving;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.FiniteBitField;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InfiniteBitField;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.IrpUtils;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.Numerical;
import org.harctoolbox.irp.ParserDriver;
import org.harctoolbox.irp.PrimaryItem;
import org.harctoolbox.irp.RecognizeData;

public abstract class BitField
extends IrpObject
implements Numerical,
EquationSolving {
    private final PrimaryItem data;
    private final PrimaryItem chop;
    private final boolean complement;

    public static BitField newBitField(String str) {
        return BitField.newBitField(new ParserDriver(str));
    }

    public static BitField newBitField(ParserDriver parserDriver) {
        return BitField.newBitField(parserDriver.getParser().bitfield());
    }

    public static BitField newBitField(IrpParser.BitfieldContext ctx) {
        return ctx instanceof IrpParser.Finite_bitfieldContext ? new FiniteBitField((IrpParser.Finite_bitfieldContext)ctx) : (ctx instanceof IrpParser.Infinite_bitfieldContext ? new InfiniteBitField((IrpParser.Infinite_bitfieldContext)ctx) : null);
    }

    public static long parse(String str, NameEngine nameEngine) throws NameUnassignedException {
        BitField bitField = BitField.newBitField(str);
        return bitField.toLong(nameEngine);
    }

    static Expression newExpression(IrpParser.BitfieldContext ctx) {
        if (ctx instanceof IrpParser.Infinite_bitfieldContext) {
            throw new ThisCannotHappenException("Cannot use an infinite bitfield as expression");
        }
        return FiniteBitField.newExpression(ctx);
    }

    protected BitField(ParseTree ctx, PrimaryItem data, PrimaryItem chop, boolean complement) {
        super(ctx);
        this.data = data;
        this.chop = chop;
        this.complement = complement;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BitField)) {
            return false;
        }
        BitField other = (BitField)obj;
        return this.complement == other.complement && this.data.equals(other.data) && this.chop.equals(other.chop);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.complement ? 1 : 0);
        hash = 53 * hash + Objects.hashCode(this.data);
        hash = 53 * hash + Objects.hashCode(this.chop);
        return hash;
    }

    @Override
    public long toLong() throws NameUnassignedException {
        return this.toLong(NameEngine.EMPTY);
    }

    public abstract String toString(NameEngine var1);

    public abstract long getWidth(NameEngine var1) throws NameUnassignedException;

    protected abstract BitwiseParameter getWidth(RecognizeData var1) throws NameUnassignedException;

    public PrimaryItem getChop() {
        return this.chop;
    }

    public boolean isComplement() {
        return this.complement;
    }

    public PrimaryItem getData() {
        return this.data;
    }

    public BitwiseParameter getChop(RecognizeData recognizeData) {
        return this.chop.toBitwiseParameter(recognizeData);
    }

    public boolean isEmpty(NameEngine nameEngine) throws NameUnassignedException {
        return this.getWidth(nameEngine) == 0L;
    }

    public boolean hasChop() {
        try {
            return this.chop.toLong() != 0L;
        }
        catch (NameUnassignedException ex) {
            return true;
        }
    }

    @Override
    public int weight() {
        return this.data.weight() + this.chop.weight();
    }

    public boolean hasExtent() {
        return false;
    }

    public Map<String, Object> propertiesMap(boolean eval, GeneralSpec generalSpec, NameEngine nameEngine) {
        Map<String, Object> map = IrpUtils.propertiesMap(6, this);
        map.put("data", this.data.propertiesMap(eval, generalSpec, nameEngine));
        try {
            long num = this.chop.toLong();
            if (num != 0L) {
                map.put("chop", this.chop.propertiesMap(true, generalSpec, nameEngine));
            }
        }
        catch (NameUnassignedException ex) {
            map.put("chop", this.chop.propertiesMap(true, generalSpec, nameEngine));
        }
        map.put("complement", this.complement);
        return map;
    }

    public Double microSeconds(GeneralSpec generalSpec, NameEngine nameEngine) {
        return null;
    }

    public Integer numberOfBareDurations() {
        return 0;
    }

    public abstract BitField substituteConstantVariables(Map<String, Long> var1);

    public boolean constant(NameEngine nameEngine) {
        return this.data.constant(nameEngine) && this.chop.constant(nameEngine);
    }

    @Override
    public abstract BitwiseParameter invert(BitwiseParameter var1, RecognizeData var2) throws NameUnassignedException;

    @Override
    public final PrimaryItem leftHandSide() {
        return this.data;
    }
}

