/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.AggregateLister;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.BitDirection;
import org.harctoolbox.irp.Duration;
import org.harctoolbox.irp.DurationType;
import org.harctoolbox.irp.EvaluatedIrStream;
import org.harctoolbox.irp.Flash;
import org.harctoolbox.irp.Gap;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.NonUniqueBitCodeException;
import org.harctoolbox.irp.ParameterSpecs;
import org.harctoolbox.irp.ParserDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class BitSpec
extends IrpObject
implements AggregateLister {
    private int chunkSize;
    private List<BareIrStream> bitCodes;
    private Integer numberOfInfiniteRepeatsCached = null;

    private static int computeNoBits(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        int x = n - 1;
        int m = 0;
        while (x != 0) {
            x >>= 1;
            ++m;
        }
        return m;
    }

    private static List<BareIrStream> parse(List<IrpParser.Bare_irstreamContext> list) {
        ArrayList<BareIrStream> result = new ArrayList<BareIrStream>(list.size());
        list.stream().forEach(bareIrStreamCtx -> result.add(new BareIrStream((IrpParser.Bare_irstreamContext)bareIrStreamCtx)));
        return result;
    }

    public BitSpec(String str) {
        this(new ParserDriver(str).getParser().bitspec());
    }

    public BitSpec(IrpParser.BitspecContext ctx) {
        super(ctx);
        this.bitCodes = BitSpec.parse(ctx.bare_irstream());
        this.chunkSize = BitSpec.computeNoBits(this.bitCodes.size());
    }

    public BitSpec(List<BareIrStream> list) throws NonUniqueBitCodeException {
        this();
        if (IrCoreUtils.hasDuplicatedElements(list)) {
            throw new NonUniqueBitCodeException();
        }
        this.chunkSize = BitSpec.computeNoBits(list.size());
        this.bitCodes = list;
    }

    public BitSpec() {
        super(null);
        this.chunkSize = 0;
        this.bitCodes = new ArrayList<BareIrStream>(0);
    }

    BitSpec substituteConstantVariables(Map<String, Long> constantVariables) {
        try {
            ArrayList<BareIrStream> list = new ArrayList<BareIrStream>(this.bitCodes.size());
            this.bitCodes.forEach(bitCode -> list.add((BareIrStream)bitCode.substituteConstantVariables((Map)constantVariables)));
            return new BitSpec(list);
        }
        catch (NonUniqueBitCodeException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    public Integer numberOfDurations() {
        int result = 0;
        for (BareIrStream bitCode : this.bitCodes) {
            Integer curr = bitCode.numberOfDurations();
            if (curr == null) {
                return null;
            }
            if (curr <= result) continue;
            result = curr;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BitSpec)) {
            return false;
        }
        BitSpec other = (BitSpec)obj;
        if (this.chunkSize != other.getChunkSize()) {
            return false;
        }
        if (this.bitCodes.size() != other.bitCodes.size()) {
            return false;
        }
        for (int i = 0; i < this.bitCodes.size(); ++i) {
            if (this.bitCodes.get(i).equals(other.bitCodes.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + this.chunkSize;
        hash = 53 * hash + Objects.hashCode(this.bitCodes);
        return hash;
    }

    public int size() {
        return this.bitCodes.size();
    }

    @Override
    public int numberOfInfiniteRepeats() {
        if (this.numberOfInfiniteRepeatsCached == null) {
            this.numberOfInfiniteRepeatsCached = 0;
            this.bitCodes.forEach(_item -> {
                this.numberOfInfiniteRepeatsCached = this.numberOfInfiniteRepeatsCached + this.numberOfInfiniteRepeats();
            });
        }
        return this.numberOfInfiniteRepeatsCached;
    }

    public BareIrStream get(int index) {
        if (index >= this.bitCodes.size()) {
            throw new ThisCannotHappenException("Cannot encode " + index + " with current bitspec.");
        }
        return this.bitCodes.get(index);
    }

    @Override
    public String toIrpString(int radix) {
        StringBuilder s = new StringBuilder(this.bitCodes.size() * 10);
        s.append("<");
        ArrayList list = new ArrayList(this.bitCodes.size() * 20);
        this.bitCodes.stream().forEach(bitCode -> list.add(bitCode.toIrpString(radix)));
        return s.append(String.join((CharSequence)"|", list)).append(">").toString();
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public boolean isEmpty() {
        return this.bitCodes.isEmpty();
    }

    public Integer numberOfBitspecDurations() {
        Integer numberDurations = null;
        for (BareIrStream bitCode : this.bitCodes) {
            int n = bitCode.numberOfBareDurations();
            if (numberDurations == null) {
                numberDurations = n;
                continue;
            }
            if (numberDurations == n) continue;
            return null;
        }
        return numberDurations;
    }

    public boolean isPWM() {
        return this.isPWM(2);
    }

    public boolean isPWM(int length) {
        return this.bitCodes.size() == length && this.isTwoLengthFlashGap();
    }

    private boolean isTwoLengthFlashGap() {
        return this.bitCodes.stream().allMatch(bitCode -> this.isTwoLengthFlashGap((BareIrStream)bitCode));
    }

    private boolean isTwoLengthFlashGap(BareIrStream bitCode) {
        List<Duration> durations = bitCode.getDurations();
        return durations.size() == 2 && durations.get(0) instanceof Flash && durations.get(1) instanceof Gap;
    }

    boolean isSonyType(GeneralSpec generalSpec, NameEngine nameEngine) {
        return this.isPWM() && !IrCoreUtils.approximatelyEquals(this.bitCodes.get(0).getIrStreamItems().get(0).microSeconds(generalSpec, nameEngine), this.bitCodes.get(1).getIrStreamItems().get(0).microSeconds(generalSpec, nameEngine));
    }

    public boolean isStandardBiPhase(GeneralSpec generalSpec, NameEngine nameEngine) {
        if (this.bitCodes.size() != 2) {
            return false;
        }
        Double a = null;
        for (BareIrStream bitCode : this.bitCodes) {
            try {
                EvaluatedIrStream on = bitCode.evaluate(IrSignal.Pass.intro, IrSignal.Pass.intro, generalSpec, nameEngine);
                if (on.getLength() != 2) {
                    return false;
                }
                if (a == null) {
                    a = on.get(0);
                }
                if (!IrCoreUtils.approximatelyEquals(a, on.get(0), 1.0, 0.0) || !IrCoreUtils.approximatelyEquals(-a.doubleValue(), on.get(1), 1.0, 0.0)) {
                    return false;
                }
                a = -a.doubleValue();
            }
            catch (NumberFormatException | IrpInvalidArgumentException | NameUnassignedException ex) {
                return false;
            }
        }
        return true;
    }

    public boolean isTrivial(GeneralSpec generalSpec, NameEngine nameEngine, boolean inverted) {
        if (this.bitCodes.size() != 2) {
            return false;
        }
        try {
            EvaluatedIrStream off = this.bitCodes.get(0).evaluate(IrSignal.Pass.intro, IrSignal.Pass.intro, generalSpec, nameEngine);
            EvaluatedIrStream on = this.bitCodes.get(1).evaluate(IrSignal.Pass.intro, IrSignal.Pass.intro, generalSpec, nameEngine);
            if (on.getLength() != 1 || off.getLength() != 1) {
                return false;
            }
            boolean sign = off.get(0) > 0.0;
            return IrCoreUtils.approximatelyEquals(on.get(0), -off.get(0)) && sign == inverted;
        }
        catch (IrpInvalidArgumentException | NameUnassignedException ex) {
            return false;
        }
    }

    public boolean isTrivial(GeneralSpec generalSpec, NameEngine nameEngine) {
        return this.isTrivial(generalSpec, nameEngine, true) || this.isTrivial(generalSpec, nameEngine, false);
    }

    @Override
    public Element toElement(Document document) {
        Element element = super.toElement(document);
        element.setAttribute("size", Integer.toString(this.bitCodes.size()));
        element.setAttribute("chunkSize", Integer.toString(this.chunkSize));
        element.setAttribute("bitMask", Long.toString(IrCoreUtils.ones(this.chunkSize)));
        element.setAttribute("pwm2", Boolean.toString(this.isPWM(2)));
        element.setAttribute("standardBiPhase", Boolean.toString(this.isStandardBiPhase(new GeneralSpec(), new NameEngine())));
        Integer nod = this.numberOfDurations();
        if (nod != null) {
            element.setAttribute("numberOfDurations", Integer.toString(nod));
        }
        this.bitCodes.forEach(bitCode -> element.appendChild(bitCode.toElement(document)));
        return element;
    }

    boolean interleaveOk(DurationType last, boolean gapFlashBitSpecs) {
        if (!gapFlashBitSpecs && (this.isPWM(2) || this.isPWM(4))) {
            return true;
        }
        return this.bitCodes.stream().noneMatch(bareIrStream -> bareIrStream.getIrStreamItems().size() < 2 || !bareIrStream.interleavingOk(last, gapFlashBitSpecs));
    }

    @Override
    public int weight() {
        int weight = 0;
        weight = this.bitCodes.stream().map(bitCode -> bitCode.weight()).reduce(weight, Integer::sum);
        return weight;
    }

    public boolean hasExtent() {
        return this.bitCodes.stream().anyMatch(bitCode -> bitCode.hasExtent());
    }

    Set<String> assignmentVariables() {
        HashSet<String> list = new HashSet<String>(1);
        this.bitCodes.stream().forEach(bitCode -> list.addAll(bitCode.assignmentVariables()));
        return list;
    }

    @Override
    public Map<String, Object> propertiesMap(GeneralSpec generalSpec, NameEngine nameEngine) {
        HashMap<String, Object> map = new HashMap<String, Object>(17);
        if (this.chunkSize > 1) {
            map.put("chunkSize", this.chunkSize);
        }
        map.put("bitMask", IrCoreUtils.ones(this.chunkSize));
        map.put("size", this.bitCodes.size());
        if (this.isPWM(2)) {
            map.put("pwm2", true);
            map.put("zeroGap", this.bitCodes.get(0).getIrStreamItems().get(1).microSeconds(generalSpec, nameEngine));
            map.put("zeroFlash", this.bitCodes.get(0).getIrStreamItems().get(0).microSeconds(generalSpec, nameEngine));
            map.put("oneGap", this.bitCodes.get(1).getIrStreamItems().get(1).microSeconds(generalSpec, nameEngine));
            map.put("oneFlash", this.bitCodes.get(1).getIrStreamItems().get(0).microSeconds(generalSpec, nameEngine));
            map.put("flashesDiffer", !IrCoreUtils.approximatelyEquals(this.bitCodes.get(0).getIrStreamItems().get(0).microSeconds(generalSpec, nameEngine), this.bitCodes.get(0).getIrStreamItems().get(0).microSeconds(generalSpec, nameEngine)));
        }
        if (this.isPWM(4)) {
            map.put("pwm4", true);
            map.put("zeroGap", this.bitCodes.get(0).getIrStreamItems().get(1).microSeconds(generalSpec, nameEngine));
            map.put("zeroFlash", this.bitCodes.get(0).getIrStreamItems().get(0).microSeconds(generalSpec, nameEngine));
            map.put("oneGap", this.bitCodes.get(1).getIrStreamItems().get(1).microSeconds(generalSpec, nameEngine));
            map.put("oneFlash", this.bitCodes.get(1).getIrStreamItems().get(0).microSeconds(generalSpec, nameEngine));
            map.put("twoGap", this.bitCodes.get(2).getIrStreamItems().get(1).microSeconds(generalSpec, nameEngine));
            map.put("twoFlash", this.bitCodes.get(2).getIrStreamItems().get(0).microSeconds(generalSpec, nameEngine));
            map.put("threeGap", this.bitCodes.get(3).getIrStreamItems().get(1).microSeconds(generalSpec, nameEngine));
            map.put("threeFlash", this.bitCodes.get(3).getIrStreamItems().get(0).microSeconds(generalSpec, nameEngine));
        }
        if (this.isStandardBiPhase(new GeneralSpec(), new NameEngine())) {
            map.put("standardBiPhase", true);
            map.put("biPhaseHalfPeriod", this.averageDuration(generalSpec, nameEngine));
            map.put("biPhaseInverted", this.bitCodes.get(0).getIrStreamItems().get(0) instanceof Flash);
        }
        map.put("lsbFirst", generalSpec.getBitDirection() == BitDirection.lsb);
        if (this.numberOfDurations() != null) {
            map.put("numberOfDurations", Integer.toString(this.numberOfDurations()));
        }
        ArrayList list = new ArrayList(this.bitCodes.size());
        this.bitCodes.stream().map(bitCode -> bitCode.propertiesMap(generalSpec, nameEngine)).forEach(list::add);
        map.put("list", list);
        return map;
    }

    double averageDuration(GeneralSpec generalSpec, NameEngine nameEngine) {
        double sum = 0.0;
        sum = this.bitCodes.stream().map(bitCode -> bitCode.averageDuration(generalSpec, nameEngine)).reduce(sum, (accumulator, _item) -> accumulator + _item);
        return sum / (double)this.bitCodes.size();
    }

    public TreeSet<Double> allDurationsInMicros(GeneralSpec generalSpec, NameEngine nameEngine) {
        TreeSet<Double> result = new TreeSet<Double>();
        this.bitCodes.forEach(bitCode -> result.addAll(bitCode.allDurationsInMicros(generalSpec, nameEngine)));
        if (result.size() == 1) {
            if (this.isStandardBiPhase(generalSpec, nameEngine)) {
                result.add(2.0 * result.first());
            } else if (this.isTrivial(generalSpec, nameEngine)) {
                result.add(0.0);
            }
        }
        return result;
    }

    public boolean constant(NameEngine nameEngine) {
        return this.bitCodes.stream().noneMatch(bitCode -> !bitCode.constant(nameEngine));
    }

    @Override
    public void createParameterSpecs(ParameterSpecs parameterSpecs) throws InvalidNameException {
        for (BareIrStream bitCode : this.bitCodes) {
            bitCode.createParameterSpecs(parameterSpecs);
        }
    }

    public static class IncompatibleBitSpecException
    extends RuntimeException {
        IncompatibleBitSpecException() {
        }

        IncompatibleBitSpecException(BitSpec bitSpec) {
            super("Incompatible BitSpec: " + bitSpec);
        }

        public IncompatibleBitSpecException(Throwable ex) {
            super(ex);
        }
    }
}

