/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.math.BigInteger;
import java.util.Objects;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.BitDirection;
import org.harctoolbox.irp.BitField;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.Evaluatable;
import org.harctoolbox.irp.EvaluatedIrStream;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InfiniteBitField;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class BitStream
extends IrpObject
implements Evaluatable {
    private static final int WEIGHT = 2;
    private long length;
    private BigInteger data;

    BitStream() {
        super(null);
        this.data = BigInteger.ZERO;
        this.length = 0L;
    }

    BitStream(BitField bitField, GeneralSpec generalSpec, NameEngine nameEngine) throws NameUnassignedException {
        super(null);
        Objects.requireNonNull(bitField);
        if (bitField instanceof InfiniteBitField) {
            throw new ThisCannotHappenException("Infinite bitfields cannot be converted to BitStreams.");
        }
        this.data = BigInteger.valueOf(generalSpec != null && generalSpec.getBitDirection() == BitDirection.msb ? bitField.toLong(nameEngine) : IrCoreUtils.reverse(bitField.toLong(nameEngine), (int)bitField.getWidth(nameEngine)));
        this.length = bitField.getWidth(nameEngine);
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public String toIrpString(int radix) {
        return "BitStream(" + this.data.toString(radix) + ":" + this.length + ")";
    }

    void add(BitStream bitStream, GeneralSpec generalSpec, NameEngine nameEngine) {
        this.data = this.data.shiftLeft((int)bitStream.length).or(bitStream.data);
        this.length += bitStream.length;
    }

    private int getChunkNo(int n, int chunksize) {
        if (n < 0 || this.length > 0L && (long)((n + 1) * chunksize - 1) >= this.length) {
            throw new IndexOutOfBoundsException("Illegal bit " + n + " in getChunkNo");
        }
        long mask = IrCoreUtils.ones(chunksize);
        return this.data.shiftRight(n * chunksize).and(BigInteger.valueOf(mask)).intValueExact();
    }

    EvaluatedIrStream evaluate(IrSignal.Pass state, IrSignal.Pass pass, GeneralSpec generalSpec, NameEngine nameEngine, BitSpec bitSpec) throws NameUnassignedException {
        EvaluatedIrStream list = new EvaluatedIrStream(nameEngine, generalSpec, pass);
        if (bitSpec == null || this.length % (long)bitSpec.getChunkSize() != 0L) {
            list.add(this);
        } else {
            int noChunks = (int)this.length / bitSpec.getChunkSize();
            for (int n = 0; n < noChunks; ++n) {
                int chunkNo = noChunks - n - 1;
                int msbindex = this.getChunkNo(chunkNo, bitSpec.getChunkSize());
                int index = generalSpec.getBitDirection() == BitDirection.msb ? msbindex : IrCoreUtils.reverse(msbindex, bitSpec.getChunkSize());
                BareIrStream irs = bitSpec.get(index);
                EvaluatedIrStream evaluatedIrStream = irs.evaluate(state, pass, generalSpec, nameEngine);
                list.add(evaluatedIrStream);
            }
        }
        return list;
    }

    @Override
    public Element toElement(Document document) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int weight() {
        return 2;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BitStream)) {
            return false;
        }
        BitStream other = (BitStream)obj;
        return this.length == other.length && this.data.equals(other.data);
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + (int)(this.length ^ this.length >>> 32);
        hash = 53 * hash + Objects.hashCode(this.data);
        return hash;
    }
}

