/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.DurationType;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrStream;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.ParameterSpecs;
import org.harctoolbox.irp.ParserDriver;
import org.harctoolbox.irp.RecognizeData;
import org.harctoolbox.irp.RenderData;
import org.harctoolbox.irp.SignalRecognitionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class BitspecIrstream
extends IrpObject
implements IrStreamItem {
    private static final Logger logger = Logger.getLogger(BitspecIrstream.class.getName());
    private BitSpec bitSpec;
    private IrStream irStream;

    public BitspecIrstream(IrpParser.ProtocolContext ctx) {
        this(ctx.bitspec_irstream());
    }

    public BitspecIrstream(BitSpec bitSpec, IrStream irStream, IrpParser.Bitspec_irstreamContext ctx) {
        super(ctx);
        this.bitSpec = bitSpec;
        this.irStream = irStream;
    }

    public BitspecIrstream(BitSpec bitSpec, IrStream irStream) {
        this(bitSpec, irStream, null);
    }

    public BitspecIrstream(IrpParser.Bitspec_irstreamContext ctx) {
        this(new BitSpec(ctx.bitspec()), new IrStream(ctx.irstream()), ctx);
    }

    public BitspecIrstream(String str) {
        this(new ParserDriver(str));
    }

    private BitspecIrstream(ParserDriver parserDriver) {
        this(parserDriver.getParser().bitspec_irstream());
    }

    public BitspecIrstream() {
        this(new BitSpec(), new IrStream());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BitspecIrstream)) {
            return false;
        }
        BitspecIrstream other = (BitspecIrstream)obj;
        return this.bitSpec.equals(other.bitSpec) && this.irStream.equals(other.irStream);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.bitSpec);
        hash = 97 * hash + Objects.hashCode(this.irStream);
        return hash;
    }

    @Override
    public String toIrpString(int radix) {
        return this.toIrpString(radix, "");
    }

    public String toIrpString(int radix, String separator) {
        return this.bitSpec.toIrpString(radix) + separator + this.irStream.toIrpString(radix, separator);
    }

    @Override
    public Element toElement(Document document) {
        Element root = super.toElement(document);
        root.setAttribute("interleavingOk", Boolean.toString(this.interleavingOk(null, null)));
        if (this.numberOfDurations() != null) {
            root.setAttribute("numberOfDuration", Integer.toString(this.numberOfDurations()));
        }
        root.appendChild(this.bitSpec.toElement(document));
        root.appendChild(this.irStream.toElement(document));
        return root;
    }

    @Override
    public boolean isEmpty(NameEngine nameEngine) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Integer numberOfBitSpecs() {
        return this.irStream.numberOfBitSpecs() + 1;
    }

    @Override
    public Integer numberOfBits() {
        return this.irStream.numberOfBits();
    }

    @Override
    public Integer numberOfBareDurations() {
        return this.irStream.numberOfBareDurations();
    }

    @Override
    public int numberOfInfiniteRepeats() {
        return this.bitSpec.numberOfInfiniteRepeats() + this.irStream.numberOfInfiniteRepeats();
    }

    @Override
    public void decode(RecognizeData recognizeData, List<BitSpec> inheritedBitSpecs, boolean isLast) throws SignalRecognitionException {
        logger.log(recognizeData.logRecordEnterWithIrStream(this));
        ArrayList<BitSpec> stack = new ArrayList<BitSpec>(inheritedBitSpecs);
        stack.add(this.bitSpec);
        int currentLevel = recognizeData.getLevel();
        recognizeData.setLevel(currentLevel + 1);
        this.irStream.decode(recognizeData, stack, isLast);
        recognizeData.setLevel(currentLevel);
        logger.log(recognizeData.logRecordExit(this));
    }

    @Override
    public void render(RenderData renderData, List<BitSpec> inheritedBitSpecs) throws NameUnassignedException {
        ArrayList<BitSpec> stack = new ArrayList<BitSpec>(inheritedBitSpecs);
        stack.add(this.bitSpec);
        renderData.push();
        this.irStream.render(renderData, stack);
        logger.log(Level.FINE, "renderdata (unreduced): {0}", renderData.getEvaluatedIrStream().toString());
        renderData.reduce(this.bitSpec);
        logger.log(Level.FINE, "renderdata (reduced): {0}", renderData.getEvaluatedIrStream().toString());
        renderData.pop();
    }

    @Override
    public void updateStateWhenEntering(IrSignal.Pass pass, IrStream.PassExtractorState state) {
        this.irStream.updateStateWhenEntering(pass, state);
    }

    @Override
    public void updateStateWhenExiting(IrSignal.Pass pass, IrStream.PassExtractorState state) {
        this.irStream.updateStateWhenExiting(pass, state);
    }

    @Override
    public BareIrStream extractPass(IrSignal.Pass pass, IrStream.PassExtractorState state) {
        BareIrStream extractList = this.irStream.extractPass(pass, state);
        IrStream reducedIrStream = new IrStream(extractList);
        ArrayList<IrStreamItem> result = new ArrayList<IrStreamItem>(1);
        result.add(new BitspecIrstream(this.bitSpec, reducedIrStream));
        return new BareIrStream(result);
    }

    public BareIrStream extractPass(IrSignal.Pass pass) {
        return this.irStream.extractPass(pass);
    }

    @Override
    public boolean interleavingOk(DurationType last, boolean gapFlashBitSpecsUnused) {
        boolean flashGapBitspecs = this.bitSpec.interleaveOk(DurationType.gap, true);
        boolean gapFlashBitspecs = this.bitSpec.interleaveOk(DurationType.flash, false);
        return (flashGapBitspecs || gapFlashBitspecs) && this.irStream.interleavingOk(last, gapFlashBitspecs);
    }

    public boolean interleavingOk(DurationType last) {
        boolean flashGapBitspecs = this.bitSpec.interleaveOk(DurationType.gap, false);
        boolean gapFlashBitspecs = this.bitSpec.interleaveOk(DurationType.flash, true);
        return (flashGapBitspecs || gapFlashBitspecs) && this.irStream.interleavingOk(last, gapFlashBitspecs);
    }

    @Override
    public boolean interleavingOk(DurationType toCheck, DurationType last, boolean gapFlashBitSpecs) {
        boolean flashGapBitspecs = this.bitSpec.interleaveOk(DurationType.gap, false);
        boolean gapFlashBitspecs = this.bitSpec.interleaveOk(DurationType.flash, true);
        return (flashGapBitspecs || gapFlashBitspecs) && this.irStream.interleavingOk(toCheck, last, gapFlashBitspecs);
    }

    public boolean interleavingOk(DurationType toCheck, DurationType last) {
        boolean flashGapBitspecs = this.bitSpec.interleaveOk(DurationType.gap, false);
        boolean gapFlashBitspecs = this.bitSpec.interleaveOk(DurationType.flash, true);
        return (flashGapBitspecs || gapFlashBitspecs) && this.irStream.interleavingOk(toCheck, last, gapFlashBitspecs);
    }

    public boolean interleavingOk() {
        return this.interleavingOk(DurationType.gap);
    }

    public boolean interleavingFlashOk() {
        return this.interleavingOk(DurationType.flash, DurationType.gap);
    }

    public boolean interleavingGapOk() {
        return this.interleavingOk(DurationType.gap, DurationType.gap);
    }

    @Override
    public DurationType endingDurationType(DurationType last, boolean gapFlashBitSpecs) {
        return this.irStream.endingDurationType(last, gapFlashBitSpecs);
    }

    @Override
    public DurationType startingDuratingType(DurationType last, boolean gapFlashBitSpecs) {
        return this.irStream.startingDuratingType(last, gapFlashBitSpecs);
    }

    boolean isPWM2() {
        return this.bitSpec.isPWM(2);
    }

    boolean isPWM4() {
        return this.bitSpec.isPWM(4);
    }

    boolean isPWM16() {
        return this.bitSpec.isPWM(16);
    }

    boolean isBiphase(GeneralSpec generalSpec, NameEngine nameEngine) {
        return this.bitSpec.isStandardBiPhase(generalSpec, nameEngine);
    }

    boolean isTrivial(GeneralSpec generalSpec, NameEngine definitions, boolean inverted) {
        return this.bitSpec.isTrivial(generalSpec, definitions, inverted);
    }

    boolean isRPlus() {
        return this.irStream.isRPlus();
    }

    boolean isSonyType(GeneralSpec generalSpec, NameEngine nameEngine) {
        return this.interleavingFlashOk() && this.bitSpec.isSonyType(generalSpec, nameEngine);
    }

    public DurationType startingDurationType(boolean gapFlashBitSpecs) {
        return this.irStream.startingDuratingType(DurationType.gap, gapFlashBitSpecs);
    }

    boolean hasVariation(IrSignal.Pass pass) {
        return this.irStream.hasVariation(pass);
    }

    boolean startsWithFlash() {
        return this.irStream.startsWithFlash();
    }

    @Override
    public int weight() {
        return this.bitSpec.weight() + this.irStream.weight();
    }

    @Override
    public boolean hasExtent() {
        return this.bitSpec.hasExtent() || this.irStream.hasExtent();
    }

    public BitSpec getBitSpec() {
        return this.bitSpec;
    }

    public IrStream getIrStream() {
        return this.irStream;
    }

    @Override
    public Set<String> assignmentVariables() {
        Set<String> list = this.bitSpec.assignmentVariables();
        list.addAll(this.irStream.assignmentVariables());
        return list;
    }

    @Override
    public Map<String, Object> propertiesMap(GeneralSpec generalSpec, NameEngine nameEngine) {
        throw new UnsupportedOperationException("Hierarchical BitSpecs not implemented yet.");
    }

    @Override
    public Double microSeconds(GeneralSpec generalSpec, NameEngine nameEngine) {
        return null;
    }

    @Override
    public Integer numberOfDurations() {
        Integer bsnod = this.bitSpec.numberOfDurations();
        return bsnod != null ? this.irStream.numberOfDurations(bsnod) : null;
    }

    @Override
    public void evaluate(RenderData renderData, List<BitSpec> bitSpecStack) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean nonConstantBitFieldLength() {
        return this.irStream.nonConstantBitFieldLength();
    }

    @Override
    public Integer guessParameterLength(String name) {
        return this.irStream.guessParameterLength(name);
    }

    @Override
    public BitspecIrstream substituteConstantVariables(Map<String, Long> constantVariables) {
        return new BitspecIrstream(this.bitSpec.substituteConstantVariables(constantVariables), (IrStream)this.irStream.substituteConstantVariables((Map)constantVariables));
    }

    @Override
    public TreeSet<Double> allDurationsInMicros(GeneralSpec generalSpec, NameEngine nameEngine) {
        TreeSet<Double> result = new TreeSet<Double>();
        TreeSet<Double> bitSpecDurations = this.bitSpec.allDurationsInMicros(generalSpec, nameEngine);
        result.addAll(bitSpecDurations);
        TreeSet<Double> irStreamDurations = this.irStream.allDurationsInMicros(generalSpec, nameEngine);
        result.addAll(irStreamDurations);
        return result;
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return this.bitSpec.constant(nameEngine) && this.irStream.constant(nameEngine);
    }

    @Override
    public void createParameterSpecs(ParameterSpecs parameterSpecs) throws InvalidNameException {
        this.bitSpec.createParameterSpecs(parameterSpecs);
        this.irStream.createParameterSpecs(parameterSpecs);
    }
}

