/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.ParameterInconsistencyException;
import org.harctoolbox.irp.SignalRecognitionException;

public final class BitwiseParameter {
    public static final long ALLBITS = -1L;
    public static final long NOBITS = 0L;
    private static final Logger logger = Logger.getLogger(BitwiseParameter.class.getName());
    public static final BitwiseParameter ZERO = new BitwiseParameter(0L);
    public static final BitwiseParameter NULL = new BitwiseParameter();
    private long value;
    private long bitmask;

    private static String toString(long value, long bitmask) {
        return Long.toString(value) + "&" + Long.toBinaryString(bitmask);
    }

    private static boolean isConsistent(long x, long y, long bitmask) {
        return ((x ^ y) & bitmask) == 0L;
    }

    public static int length(long x) {
        return 64 - Long.numberOfLeadingZeros(x);
    }

    private static boolean covers(long bitmask, long bm) {
        return (bitmask & bm) == bm;
    }

    private static long arithmeticBitmask(long b1, long b2) {
        return b1 & b2;
    }

    private static boolean isTrue(long value) {
        return value != 0L;
    }

    private static boolean ifFalse(long value) {
        return value == 0L;
    }

    public BitwiseParameter(long value) {
        this(value, -1L);
    }

    public BitwiseParameter(boolean b) {
        this(b ? 1L : 0L);
    }

    public BitwiseParameter() {
        this(0L, 0L);
    }

    public BitwiseParameter(long value, long bitmask) {
        this.value = value & bitmask;
        this.bitmask = bitmask;
    }

    public BitwiseParameter(BitwiseParameter old) {
        this.value = old.value & old.bitmask;
        this.bitmask = old.bitmask;
    }

    public BitwiseParameter restrict(long newBitmask) {
        return new BitwiseParameter(this.value, this.bitmask & newBitmask);
    }

    public boolean coversWidth(long width) {
        return this.covers(IrCoreUtils.ones(width));
    }

    public boolean covers(long bm) {
        return BitwiseParameter.covers(this.bitmask, bm);
    }

    boolean isEmpty() {
        return this.bitmask == 0L;
    }

    public int length() {
        return BitwiseParameter.length(this.bitmask);
    }

    private void canonicalize() {
        this.value &= this.bitmask;
    }

    public boolean isConsistent(BitwiseParameter parameter) {
        Objects.requireNonNull(parameter);
        return BitwiseParameter.isConsistent(this.value, parameter.value, this.bitmask & parameter.bitmask);
    }

    public boolean isConsistent(long val) {
        return BitwiseParameter.isConsistent(this.value, val, this.bitmask);
    }

    public void checkConsistency(String name, long val) throws ParameterInconsistencyException {
        if (!this.isConsistent(val)) {
            throw new ParameterInconsistencyException(name, this.getValue(), val);
        }
    }

    public void aggregate(BitwiseParameter parameter) {
        parameter.canonicalize();
        logger.log(Level.FINEST, "Changing {0} to {1}", new Object[]{this.toString(), BitwiseParameter.toString(this.value | parameter.value, this.bitmask | parameter.bitmask)});
        this.value &= parameter.bitmask ^ 0xFFFFFFFFFFFFFFFFL;
        this.value |= parameter.getValue();
        this.bitmask |= parameter.bitmask;
        this.canonicalize();
    }

    public void append(BitwiseParameter other) {
        if (!other.isEmpty()) {
            long size = other.length();
            this.value = this.value << (int)size | other.value;
            this.bitmask = this.bitmask << (int)size | other.bitmask;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BitwiseParameter)) {
            return false;
        }
        BitwiseParameter other = (BitwiseParameter)obj;
        return this.bitmask == other.bitmask && ((this.value ^ other.value) & this.bitmask) == 0L;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (int)(this.value ^ this.value >>> 32);
        hash = 41 * hash + (int)(this.bitmask ^ this.bitmask >>> 32);
        return hash;
    }

    public String toString() {
        return BitwiseParameter.toString(this.value, this.bitmask);
    }

    public long getValue() {
        return this.value & this.bitmask;
    }

    public long getBitmask() {
        return this.bitmask;
    }

    public void assign(long value) {
        this.value = value;
        this.bitmask = -1L;
    }

    BitwiseParameter bitInvert() {
        return new BitwiseParameter(this.value ^ 0xFFFFFFFFFFFFFFFFL, this.bitmask);
    }

    BitwiseParameter minus() {
        return new BitwiseParameter(-this.value, this.bitmask);
    }

    BitwiseParameter bitCount() {
        return new BitwiseParameter(Long.bitCount(this.value), this.bitmask);
    }

    BitwiseParameter negation() {
        return new BitwiseParameter(this.isFalse());
    }

    public BitwiseParameter minus(BitwiseParameter op) {
        return new BitwiseParameter(this.value - op.getValue(), this.arithmeticBitmask(op.getBitmask()));
    }

    BitwiseParameter plus(BitwiseParameter op) {
        return new BitwiseParameter(this.value + op.getValue(), this.arithmeticBitmask(op.getBitmask()));
    }

    BitwiseParameter div(BitwiseParameter op) {
        if (op.getValue() == 0L) {
            return NULL;
        }
        long d = IrCoreUtils.log2(op.value);
        long bm = this.bitmask >> (int)d;
        return new BitwiseParameter(this.value / op.getValue(), bm);
    }

    public BitwiseParameter mul(BitwiseParameter op) {
        boolean opIsPowerOf2 = Long.bitCount(op.getValue()) == 1;
        BitwiseParameter operator = opIsPowerOf2 ? op : this;
        long d = operator.value > 0L ? IrCoreUtils.log2(operator.value) : 0L;
        long bm = this.bitmask << (int)d | IrCoreUtils.ones(d);
        return new BitwiseParameter(this.value * op.getValue(), bm);
    }

    public BitwiseParameter xor(BitwiseParameter op) {
        return new BitwiseParameter(this.value ^ op.getValue(), this.bitmask & op.getBitmask());
    }

    BitwiseParameter power(BitwiseParameter op) {
        return new BitwiseParameter(IrCoreUtils.power(this.value, op.getValue()), -1L);
    }

    BitwiseParameter mod(BitwiseParameter op) {
        return new BitwiseParameter(this.value % op.getValue(), this.arithmeticBitmask(op.getBitmask()));
    }

    BitwiseParameter leftShift(BitwiseParameter op) {
        return new BitwiseParameter(this.value << (int)op.getValue(), this.bitmask << (int)op.getBitmask());
    }

    BitwiseParameter rightShift(BitwiseParameter op) {
        return new BitwiseParameter(this.value >> (int)op.getValue(), this.bitmask >>> (int)op.getBitmask());
    }

    BitwiseParameter le(BitwiseParameter op) {
        return new BitwiseParameter(this.value <= op.getValue());
    }

    BitwiseParameter ge(BitwiseParameter op) {
        return new BitwiseParameter(this.value >= op.getValue());
    }

    BitwiseParameter lt(BitwiseParameter op) {
        return new BitwiseParameter(this.value < op.getValue());
    }

    BitwiseParameter gt(BitwiseParameter op) {
        return new BitwiseParameter(this.value > op.getValue());
    }

    BitwiseParameter eq(BitwiseParameter op) {
        return new BitwiseParameter(this.value == op.getValue());
    }

    BitwiseParameter ne(BitwiseParameter op) {
        return new BitwiseParameter(this.value != op.getValue());
    }

    BitwiseParameter and(BitwiseParameter op) {
        return new BitwiseParameter(this.value & op.getValue(), this.arithmeticBitmask(op.getBitmask()));
    }

    BitwiseParameter or(BitwiseParameter op) {
        return new BitwiseParameter(op.value & op.getValue(), this.arithmeticBitmask(op.getBitmask()));
    }

    boolean isFalse() {
        return BitwiseParameter.ifFalse(this.value);
    }

    boolean isTrue() {
        return BitwiseParameter.isTrue(this.value);
    }

    BitwiseParameter reverse(BitwiseParameter length) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long longValueExact() {
        if (this.bitmask != -1L) {
            throw new IllegalArgumentException("value not known");
        }
        return this.value;
    }

    private long arithmeticBitmask(long bm) {
        return BitwiseParameter.arithmeticBitmask(this.bitmask, bm);
    }

    public boolean check(long payload, long bitmask) throws SignalRecognitionException {
        if (!this.isConsistent(payload)) {
            throw new SignalRecognitionException("BitwiseParameter " + this.toString() + " not consistent with previously read data = " + payload);
        }
        return this.covers(bitmask);
    }

    public boolean isFinished(Long bitmask) {
        Objects.requireNonNull(bitmask);
        return this.covers(bitmask);
    }

    public boolean isKnown() {
        return this.bitmask == -1L;
    }
}

