/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.ItemCodeGenerator;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.NamedProtocol;
import org.harctoolbox.irp.STCodeGenerator;
import org.harctoolbox.irp.UnknownProtocolException;
import org.harctoolbox.irp.UnsupportedRepeatException;

public abstract class CodeGenerator {
    private static final Logger logger = Logger.getLogger(CodeGenerator.class.getName());

    public abstract ItemCodeGenerator newItemCodeGenerator(String var1);

    public ItemCodeGenerator newItemCodeGenerator(Object object) {
        return this.newItemCodeGenerator(object.getClass().getSimpleName());
    }

    public String render(String name) {
        return this.newItemCodeGenerator(name).render();
    }

    public abstract String fileName(String var1);

    public boolean isAbstract() {
        return Boolean.parseBoolean(this.render("IsAbstract"));
    }

    public boolean manyProtocolsInOneFile() {
        return Boolean.parseBoolean(this.render("ManyProtocolsInOneFile"));
    }

    public void generate(Collection<String> protocolNames, IrpDatabase irpDatabase, File directory, boolean inspect, Map<String, String> parameters, Double absoluteTolerance, Double relativeTolerance, Double frequencyTolerance, String tool, String toolVersion, String commandLine) throws IOException, UnknownProtocolException, InvalidNameException, UnsupportedRepeatException, NameUnassignedException, IrpInvalidArgumentException {
        if (this.isAbstract()) {
            throw new IrpInvalidArgumentException("This target cannot generete code since it is declared abstract.");
        }
        if (directory == null || !directory.isDirectory() || !directory.canWrite()) {
            throw new IOException("directory must be a writeable directory");
        }
        STCodeGenerator.trackCreationEvents(inspect);
        for (String protocolName : protocolNames) {
            NamedProtocol protocol = irpDatabase.getNamedProtocol(protocolName);
            String protocolCName = IrCoreUtils.toCName(protocol.getName());
            String filename = new File(directory + "/" + this.fileName(protocolCName)).getCanonicalPath();
            PrintStream out = IrCoreUtils.getPrintStream(filename);
            try {
                this.generate(protocol, out, true, inspect, parameters, absoluteTolerance, relativeTolerance, frequencyTolerance, tool, toolVersion, commandLine);
                logger.log(Level.INFO, "Wrote {0}", filename);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    public void generate(Collection<String> protocolNames, IrpDatabase irpDatabase, PrintStream out, boolean inspect, Map<String, String> parameters, Double absoluteTolerance, Double relativeTolerance, Double frequencyTolerance, String tool, String toolVersion, String commandLine) throws IrpInvalidArgumentException {
        if (protocolNames == null || protocolNames.isEmpty()) {
            throw new IrpInvalidArgumentException("protocolNames cannot be null or empty");
        }
        if (this.isAbstract()) {
            throw new IrpInvalidArgumentException("This target cannot generete code since it is declared abstract.");
        }
        if (!this.manyProtocolsInOneFile() && protocolNames.size() > 1) {
            throw new IrpInvalidArgumentException("This target cannot generate more than one protocol in one file");
        }
        this.setInspect(inspect);
        this.generateFileBegin(out, tool, toolVersion, commandLine);
        protocolNames.forEach(protocolName -> {
            try {
                this.generate((String)protocolName, irpDatabase, out, false, inspect, parameters, absoluteTolerance, relativeTolerance, frequencyTolerance, tool, toolVersion, commandLine);
            }
            catch (ArithmeticException | InvalidNameException | IrpInvalidArgumentException | NameUnassignedException | UnknownProtocolException | UnsupportedRepeatException ex) {
                logger.log(Level.WARNING, "{0}, ignoring this protol", ex.getMessage());
            }
        });
        this.generateFileEnd(out);
    }

    private void generateFileBegin(PrintStream out, String tool, String toolVersion, String commandLine) {
        ItemCodeGenerator itemCodeGenerator = this.newItemCodeGenerator("FileBegin");
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("date", new Date().toString());
        map.put("userName", System.getProperty("user.name"));
        map.put("tool", tool);
        map.put("toolVersion", toolVersion);
        map.put("commandLineArguments", commandLine);
        itemCodeGenerator.addAggregateList("GenerateData", map);
        out.println(itemCodeGenerator.render());
    }

    private void generateFileEnd(PrintStream out) {
        ItemCodeGenerator itemCodeGenerator = this.newItemCodeGenerator("FileEnd");
        out.print(itemCodeGenerator.render());
    }

    private void generate(String protocolName, IrpDatabase irpDatabase, PrintStream out, boolean printPostAndPre, boolean inspect, Map<String, String> parameters, Double absoluteTolerance, Double relativeTolerance, Double frequencyTolerance, String tool, String toolVersion, String commandLine) throws UnknownProtocolException, InvalidNameException, UnsupportedRepeatException, IrpInvalidArgumentException, NameUnassignedException {
        NamedProtocol protocol = irpDatabase.getNamedProtocol(protocolName);
        this.generate(protocol, out, printPostAndPre, inspect, parameters, absoluteTolerance, relativeTolerance, frequencyTolerance, tool, toolVersion, commandLine);
    }

    private void generate(NamedProtocol protocol, PrintStream out, boolean printPostAndPre, boolean inspect, Map<String, String> parameters, Double absoluteTolerance, Double relativeTolerance, Double frequencyTolerance, String tool, String toolVersion, String commandLine) {
        if (printPostAndPre) {
            this.generateFileBegin(out, tool, toolVersion, commandLine);
        }
        ItemCodeGenerator code = protocol.code(this, parameters, absoluteTolerance, relativeTolerance, frequencyTolerance);
        out.println(code.render());
        if (printPostAndPre) {
            this.generateFileEnd(out);
        }
        if (inspect) {
            code.inspectAndWait();
        }
    }

    public abstract void setInspect(boolean var1);
}

