/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.Pronto;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.ElementaryDecode;
import org.harctoolbox.irp.HasPreferOvers;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.IrpParseException;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.NamedProtocol;
import org.harctoolbox.irp.PreferOver;
import org.harctoolbox.irp.Protocol;
import org.harctoolbox.irp.SignalRecognitionException;
import org.harctoolbox.irp.UnknownProtocolException;
import org.harctoolbox.irp.UnsupportedRepeatException;
import org.xml.sax.SAXException;

public final class Decoder {
    private static final Logger logger = Logger.getLogger(Decoder.class.getName());
    private static Pattern debugProtocolNamePattern = null;
    private static final int MAX_PREFER_OVER_NESTING = 10;
    private final Map<String, NamedProtocol> parsedProtocols;

    public static void setDebugProtocolRegExp(String regexp) {
        debugProtocolNamePattern = regexp == null || regexp.isEmpty() ? null : Pattern.compile(regexp.toLowerCase(Locale.US));
    }

    public static String getDebugProtocolRegExp() {
        return debugProtocolNamePattern != null ? debugProtocolNamePattern.pattern() : null;
    }

    public static void main(String[] args) {
        try {
            Decoder decoder = new Decoder();
            IrSignal irSignal = Pronto.parse(args);
            SimpleDecodesSet decodes = decoder.decodeIrSignal(irSignal);
            for (Decode decode : decodes) {
                System.out.println(decode);
            }
        }
        catch (IOException | InvalidArgumentException | Pronto.NonProntoFormatException | IrpParseException | SAXException ex) {
            logger.log(Level.SEVERE, null, ex);
            System.exit(1);
        }
    }

    public Decoder(IrpDatabase irpDatabase) throws IrpParseException {
        this(irpDatabase, null);
    }

    public Decoder() throws IrpParseException, IOException, SAXException {
        this(new IrpDatabase((String)null));
    }

    public Decoder(String ... names) throws IOException, IrpParseException, SAXException {
        this(new IrpDatabase((String)null), Arrays.asList(names));
    }

    public Decoder(IrpDatabase irpDatabase, List<String> names) throws IrpParseException {
        this.parsedProtocols = new LinkedHashMap<String, NamedProtocol>(irpDatabase.size());
        Collection<String> list = names != null ? names : irpDatabase.getKeys();
        list.forEach(protocolName -> {
            try {
                NamedProtocol namedProtocol = irpDatabase.getNamedProtocol((String)protocolName);
                if (namedProtocol.isDecodeable()) {
                    this.parsedProtocols.put((String)protocolName, namedProtocol);
                }
            }
            catch (InvalidNameException | IrpInvalidArgumentException | NameUnassignedException | UnknownProtocolException | UnsupportedRepeatException ex) {
                throw new ThisCannotHappenException(ex);
            }
        });
    }

    public DecodeTree decode(ModulatedIrSequence irSequence, DecoderParameters userSuppliedDecoderParameters) {
        HashMap<Integer, Map<String, TrunkDecodeTree>> map = new HashMap<Integer, Map<String, TrunkDecodeTree>>(16);
        DecodeTree decodes = this.decode(irSequence, 0, userSuppliedDecoderParameters, 0, map);
        if (decodes.isEmpty() && userSuppliedDecoderParameters.isIgnoreLeadingGarbage()) {
            int newStart = irSequence.firstBigGap(0, userSuppliedDecoderParameters.getMinimumLeadout()) + 1;
            return newStart > 0 ? this.decode(irSequence, newStart, userSuppliedDecoderParameters, 0, map) : decodes;
        }
        return decodes;
    }

    private DecodeTree decode(ModulatedIrSequence irSequence, int position, DecoderParameters userSuppliedDecoderParameters, int level, Map<Integer, Map<String, TrunkDecodeTree>> map) {
        logger.log(Level.FINE, String.format("level = %1$d position = %2$d", level, position));
        DecodeTree decodeTree = new DecodeTree(irSequence.getLength() - position);
        if (decodeTree.length == 0) {
            return decodeTree;
        }
        this.parsedProtocols.values().forEach(namedProtocol -> {
            try {
                TrunkDecodeTree decode;
                Map p;
                if (debugProtocolNamePattern != null && debugProtocolNamePattern.matcher(namedProtocol.getName().toLowerCase(Locale.US)).matches()) {
                    logger.log(Level.FINEST, "Trying protocol {0}", namedProtocol.getName());
                }
                if ((p = (Map)map.get(position)) != null && p.containsKey(namedProtocol.getName())) {
                    decode = (TrunkDecodeTree)p.get(namedProtocol.getName());
                } else {
                    decode = this.tryNamedProtocol((NamedProtocol)namedProtocol, irSequence, position, userSuppliedDecoderParameters, level, map);
                    if (!map.containsKey(position)) {
                        map.put(position, new HashMap(4));
                    }
                    ((Map)map.get(position)).put(namedProtocol.getName(), decode);
                }
                decodeTree.add(decode);
            }
            catch (SignalRecognitionException ex) {
                logger.log(Level.FINER, String.format("Protocol %1$s did not decode: %2$s", namedProtocol.getName(), ex.getMessage()));
            }
            catch (Protocol.ProtocolNotDecodableException protocolNotDecodableException) {
                // empty catch block
            }
        });
        if (userSuppliedDecoderParameters.isAllDecodes()) {
            decodeTree.computePreferred(this.parsedProtocols);
        } else {
            decodeTree.reduce(this.parsedProtocols);
            if (decodeTree.isComplete()) {
                decodeTree.removeIncompletes();
            }
        }
        decodeTree.sort();
        return decodeTree;
    }

    private TrunkDecodeTree tryNamedProtocol(NamedProtocol namedProtocol, ModulatedIrSequence irSequence, int position, DecoderParameters userSuppliedDecoderParameters, int level, Map<Integer, Map<String, TrunkDecodeTree>> map) throws SignalRecognitionException, Protocol.ProtocolNotDecodableException {
        Decode decode = namedProtocol.recognize(irSequence, position, userSuppliedDecoderParameters);
        if (userSuppliedDecoderParameters.isRemoveDefaultedParameters()) {
            decode.removeDefaulteds();
        }
        if (!userSuppliedDecoderParameters.recursive || decode.endPos == irSequence.getLength() - 1) {
            return new TrunkDecodeTree(decode, irSequence.getLength());
        }
        DecodeTree rest = this.decode(irSequence, decode.getEndPos() + 1, userSuppliedDecoderParameters, level + 1, map);
        return new TrunkDecodeTree(decode, rest);
    }

    public SimpleDecodesSet decodeIrSignal(IrSignal irSignal, DecoderParameters parameters) {
        ArrayList<Decode> decodes = new ArrayList<Decode>(8);
        this.parsedProtocols.values().forEach(namedProtocol -> {
            try {
                if (debugProtocolNamePattern != null && debugProtocolNamePattern.matcher(namedProtocol.getName().toLowerCase(Locale.US)).matches()) {
                    logger.log(Level.FINEST, "Trying protocol {0}", namedProtocol.getName());
                }
                Map<String, Long> params = namedProtocol.recognize(irSignal, parameters);
                if (parameters.isRemoveDefaultedParameters()) {
                    namedProtocol.removeDefaulteds(params);
                }
                Decode decode = new Decode((NamedProtocol)namedProtocol, params);
                decodes.add(decode);
            }
            catch (SignalRecognitionException ex) {
                logger.log(Level.FINE, String.format("Protocol %1$s did not decode: %2$s", namedProtocol.getName(), ex.getMessage()));
            }
            catch (Protocol.ProtocolNotDecodableException ex) {
                throw new ThisCannotHappenException();
            }
        });
        SimpleDecodesSet simpleDecodesSet = new SimpleDecodesSet((List<Decode>)decodes);
        if (parameters.isAllDecodes()) {
            simpleDecodesSet.computePreferred(this.parsedProtocols);
        } else {
            simpleDecodesSet.reduce(this.parsedProtocols);
        }
        simpleDecodesSet.sort();
        return simpleDecodesSet;
    }

    public SimpleDecodesSet decodeIrSignal(IrSignal irSignal) {
        return this.decodeIrSignal(irSignal, new DecoderParameters());
    }

    Collection<NamedProtocol> getParsedProtocols() {
        return this.parsedProtocols.values();
    }

    public AbstractDecodesCollection<? extends ElementaryDecode> decodeLoose(IrSignal irSignal, DecoderParameters decoderParams) {
        if (decoderParams.ignoreLeadingGarbage || !decoderParams.strict && (irSignal.introOnly() || irSignal.repeatOnly())) {
            ModulatedIrSequence sequence = irSignal.toModulatedIrSequence();
            return this.decode(sequence, decoderParams);
        }
        return this.decodeIrSignal(irSignal, decoderParams);
    }

    public AbstractDecodesCollection<? extends ElementaryDecode> decodeIrSignalWithFallback(IrSignal irSignal, DecoderParameters decoderParams) {
        SimpleDecodesSet decodes;
        if (!(!decoderParams.strict && irSignal.introOnly() || (decodes = this.decodeIrSignal(irSignal, decoderParams)).isEmpty())) {
            return decodes;
        }
        return this.decode(irSignal.toModulatedIrSequence(), decoderParams);
    }

    public static final class SimpleDecodesSet
    extends AbstractDecodesCollection<Decode> {
        public SimpleDecodesSet(List<Decode> list) {
            super(list);
        }

        public SimpleDecodesSet(DecodeTree decodeTree) {
            this(decodeTree.toList());
        }

        @Override
        List<Decode> sortedValues() {
            ArrayList<Decode> list = new ArrayList<Decode>(this.map.values());
            Collections.sort(list);
            return list;
        }
    }

    public static final class Decode
    implements ElementaryDecode,
    Comparable<Decode> {
        private final NamedProtocol namedProtocol;
        private final Map<String, Long> map;
        private final int begPos;
        private final int endPos;
        private final int numberOfRepetitions;

        public Decode(NamedProtocol namedProtocol, Map<String, Long> map, int begPos, int endPos, int numberOfRepetitions) {
            this.namedProtocol = namedProtocol;
            this.map = map;
            this.begPos = begPos;
            this.endPos = endPos;
            this.numberOfRepetitions = numberOfRepetitions;
        }

        Decode(NamedProtocol namedProtocol, Map<String, Long> params) {
            this(namedProtocol, params, -1, -1, 0);
        }

        Decode(NamedProtocol namedProtocol, Decode decode) {
            this.namedProtocol = namedProtocol;
            this.map = decode.map;
            this.begPos = decode.begPos;
            this.endPos = decode.endPos;
            this.numberOfRepetitions = decode.numberOfRepetitions;
        }

        public boolean same(String protocolName, NameEngine nameEngine) {
            return this.namedProtocol.getName().equalsIgnoreCase(protocolName) && nameEngine.numericallyEquals(nameEngine);
        }

        public String toString() {
            return this.toString(10, " ");
        }

        @Override
        public String toString(int radix, String separator) {
            return this.namedProtocol.getName() + ": " + this.mapToString(radix) + (this.begPos != -1 ? "," + separator + "beg=" + this.begPos : "") + (this.endPos != -1 ? ", end=" + this.endPos : "") + (this.numberOfRepetitions != 0 ? ", reps=" + this.numberOfRepetitions : "");
        }

        @Override
        public Set<String> getPreferOverNames() {
            List<PreferOver> preferOvers = this.namedProtocol.getPreferOver();
            HashSet<String> result = new HashSet<String>(preferOvers.size());
            for (PreferOver preferOver : preferOvers) {
                String removee = preferOver.toBeRemoved(this.map);
                if (removee == null) continue;
                result.add(removee);
            }
            return result;
        }

        public NamedProtocol getNamedProtocol() {
            return this.namedProtocol;
        }

        @Override
        public String getName() {
            return this.namedProtocol.getName();
        }

        int getBegPos() {
            return this.begPos;
        }

        int getEndPos() {
            return this.endPos;
        }

        int getNumberOfRepetitions() {
            return this.numberOfRepetitions;
        }

        @Override
        public Map<String, Long> getMap() {
            return this.map;
        }

        private void removeDefaulteds() {
            this.namedProtocol.removeDefaulteds(this.map);
        }

        private String mapToString(int radix) {
            if (this.map.isEmpty()) {
                return "";
            }
            StringJoiner stringJoiner = new StringJoiner(",", "{", "}");
            this.map.keySet().stream().sorted(this.namedProtocol.getParameterSpecs()).forEach(key -> stringJoiner.add(key + "=" + IrCoreUtils.radixPrefix(radix) + Long.toString(this.map.get(key), radix)));
            return stringJoiner.toString();
        }

        @Override
        public int compareTo(Decode other) {
            return IrCoreUtils.lexicalCompare(this.namedProtocol.compareTo(other.namedProtocol), this.begPos - other.begPos, this.endPos - other.endPos, this.numberOfRepetitions - other.numberOfRepetitions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.compareTo((Decode)obj) == 0;
        }

        public int hashCode() {
            int hash = 7;
            hash = 19 * hash + Objects.hashCode(this.namedProtocol);
            hash = 19 * hash + Objects.hashCode(this.map);
            hash = 19 * hash + this.begPos;
            hash = 19 * hash + this.endPos;
            hash = 19 * hash + this.numberOfRepetitions;
            return hash;
        }

        @Override
        public Decode getDecode() {
            return this;
        }
    }

    public static final class DecoderParameters {
        private boolean strict;
        private boolean allDecodes;
        private boolean removeDefaultedParameters;
        private boolean recursive;
        private Double frequencyTolerance;
        private Double absoluteTolerance;
        private Double relativeTolerance;
        private Double minimumLeadout;
        private boolean override;
        private boolean ignoreLeadingGarbage;

        public DecoderParameters(boolean strict, boolean allDecodes, boolean removeDefaultedParameters, boolean recursive, Double frequencyTolerance, Double absoluteTolerance, Double relativeTolerance, Double minimumLeadout, boolean override, boolean ignoreLeadingGarbage) {
            this.strict = strict;
            this.allDecodes = allDecodes;
            this.removeDefaultedParameters = removeDefaultedParameters;
            this.recursive = recursive;
            this.frequencyTolerance = frequencyTolerance;
            this.absoluteTolerance = absoluteTolerance;
            this.relativeTolerance = relativeTolerance;
            this.minimumLeadout = minimumLeadout;
            this.override = override;
            this.ignoreLeadingGarbage = ignoreLeadingGarbage;
        }

        public DecoderParameters() {
            this(false);
        }

        public DecoderParameters(boolean strict) {
            this(strict, false, true, false, null, null, null, null, false, false);
        }

        public DecoderParameters(boolean strict, Double frequencyTolerance, Double absoluteTolerance, Double relativeTolerance, Double minimumLeadout) {
            this(strict, false, true, false, frequencyTolerance, absoluteTolerance, relativeTolerance, minimumLeadout, false, false);
        }

        public DecoderParameters select(boolean newStrict, Double frequencyTolerance, Double absoluteTolerance, Double relativeTolerance, Double minimumLeadout) {
            return new DecoderParameters(this.strict || newStrict, this.allDecodes, this.removeDefaultedParameters, this.recursive, this.selectValue(frequencyTolerance, this.frequencyTolerance, this.override), this.selectValue(absoluteTolerance, this.absoluteTolerance, this.override), this.selectValue(relativeTolerance, this.relativeTolerance, this.override), this.selectValue(minimumLeadout, this.minimumLeadout, this.override), this.override, this.ignoreLeadingGarbage);
        }

        private Double selectValue(Double databaseValue, Double userValue, boolean override) {
            return override && userValue != null || databaseValue == null ? userValue : databaseValue;
        }

        public String toString() {
            StringJoiner sj = new StringJoiner(",", "{", "}");
            sj.add(Boolean.toString(this.strict));
            sj.add(Boolean.toString(this.allDecodes));
            sj.add(Boolean.toString(this.removeDefaultedParameters));
            sj.add(Boolean.toString(this.recursive));
            sj.add(Double.toString(this.frequencyTolerance));
            sj.add(Double.toString(this.absoluteTolerance));
            sj.add(Double.toString(this.relativeTolerance));
            sj.add(Double.toString(this.minimumLeadout));
            sj.add(Boolean.toString(this.override));
            sj.add(Boolean.toString(this.ignoreLeadingGarbage));
            return sj.toString();
        }

        public boolean isStrict() {
            return this.strict;
        }

        public boolean isAllDecodes() {
            return this.allDecodes;
        }

        public boolean isRemoveDefaultedParameters() {
            return this.removeDefaultedParameters;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public Double getFrequencyTolerance() {
            return IrCoreUtils.getFrequencyTolerance(this.frequencyTolerance);
        }

        public Double getAbsoluteTolerance() {
            return IrCoreUtils.getAbsoluteTolerance(this.absoluteTolerance);
        }

        public Double getRelativeTolerance() {
            return IrCoreUtils.getRelativeTolerance(this.relativeTolerance);
        }

        public Double getMinimumLeadout() {
            return IrCoreUtils.getMinimumLeadout(this.minimumLeadout);
        }

        public boolean isOverride() {
            return this.override;
        }

        public void setStrict(boolean strict) {
            this.strict = strict;
        }

        public void setAllDecodes(boolean allDecodes) {
            this.allDecodes = allDecodes;
        }

        public void setRemoveDefaultedParameters(boolean removeDefaultedParameters) {
            this.removeDefaultedParameters = removeDefaultedParameters;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        public void setFrequencyTolerance(Double frequencyTolerance) {
            this.frequencyTolerance = frequencyTolerance;
        }

        public void setAbsoluteTolerance(Double absoluteTolerance) {
            this.absoluteTolerance = absoluteTolerance;
        }

        public void setRelativeTolerance(Double relativeTolerance) {
            this.relativeTolerance = relativeTolerance;
        }

        public void setMinimumLeadout(Double minimumLeadout) {
            this.minimumLeadout = minimumLeadout;
        }

        public void setOverride(boolean override) {
            this.override = override;
        }

        public void setIgnoreLeadingGarbage(boolean ignoreLeadingGarbage) {
            this.ignoreLeadingGarbage = ignoreLeadingGarbage;
        }

        private boolean isIgnoreLeadingGarbage() {
            return this.ignoreLeadingGarbage;
        }
    }

    public static final class DecodeTree
    extends AbstractDecodesCollection<TrunkDecodeTree>
    implements Comparable<DecodeTree> {
        private int length;

        private DecodeTree(int length) {
            super(new ArrayList(8));
            this.length = length;
        }

        private DecodeTree(DecodeTree old) {
            super(old.map);
            this.length = old.length;
        }

        public String toString(int radix, String separator) {
            if (this.isVoid()) {
                return "";
            }
            StringJoiner stringJoiner = new StringJoiner(separator, "{", "}");
            if (this.map.isEmpty()) {
                stringJoiner.add("UNDECODED. length=" + Integer.toString(this.length, 10));
            }
            this.map.values().forEach(decode -> stringJoiner.add(decode.toString(radix, separator)));
            return stringJoiner.toString();
        }

        public List<Decode> toList() {
            ArrayList<Decode> result = new ArrayList<Decode>(this.size());
            this.map.values().forEach(tdt -> result.add(tdt.getTrunk()));
            return result;
        }

        public String toString() {
            return this.toString(10, ", ");
        }

        private void removeIncompletes() {
            DecodeTree old = new DecodeTree(this);
            for (TrunkDecodeTree decode : old) {
                if (decode.isComplete()) continue;
                this.remove(decode);
            }
        }

        boolean isVoid() {
            return this.isEmpty() && this.length == 0;
        }

        TrunkDecodeTree getAlternative(String protocolName) {
            return (TrunkDecodeTree)this.get(protocolName);
        }

        private boolean isComplete() {
            if (this.length == 0) {
                return true;
            }
            return this.map.values().stream().anyMatch(d -> ((TrunkDecodeTree)d).isComplete());
        }

        @Override
        public int compareTo(DecodeTree o) {
            Iterator it = this.iterator();
            Iterator jt = o.iterator();
            while (it.hasNext() && jt.hasNext()) {
                TrunkDecodeTree od;
                TrunkDecodeTree d = (TrunkDecodeTree)it.next();
                int c = d.compareTo(od = (TrunkDecodeTree)jt.next());
                if (c == 0) continue;
                return c;
            }
            return this.size() - o.size();
        }

        public int hashCode() {
            int hash = 5 + super.hashCode();
            hash = 83 * hash + this.length;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.compareTo((DecodeTree)obj) == 0;
        }

        @Override
        List<TrunkDecodeTree> sortedValues() {
            ArrayList<TrunkDecodeTree> list = new ArrayList<TrunkDecodeTree>(this.map.values());
            Collections.sort(list);
            return list;
        }

        @Override
        protected void printNoDecodes(PrintStream out, boolean quiet) {
            out.println(quiet ? "" : "No decodes.");
        }
    }

    public static final class TrunkDecodeTree
    implements ElementaryDecode,
    Comparable<TrunkDecodeTree> {
        private Decode trunk;
        private DecodeTree rest;

        private TrunkDecodeTree(Decode decode, int totalLenght) {
            this(decode, new DecodeTree(totalLenght - (decode.getEndPos() + 1)));
        }

        private TrunkDecodeTree(Decode decode, DecodeTree rest) {
            this.trunk = decode;
            this.rest = rest;
        }

        public String toString() {
            return this.toString(10, " ");
        }

        @Override
        public String toString(int radix, String separator) {
            StringJoiner stringJoiner = new StringJoiner(separator);
            stringJoiner.add(this.trunk.toString(radix, separator));
            if (!this.rest.isVoid()) {
                stringJoiner.add(this.rest.toString(radix, separator));
            }
            return stringJoiner.toString();
        }

        @Override
        public String getName() {
            return this.trunk.getName();
        }

        @Override
        public Map<String, Long> getMap() {
            return this.trunk.map;
        }

        public Decode getTrunk() {
            return this.trunk;
        }

        public DecodeTree getRest() {
            return this.rest;
        }

        boolean isEmpty() {
            return this.trunk == null;
        }

        private boolean isComplete() {
            return this.rest.isComplete();
        }

        @Override
        public int compareTo(TrunkDecodeTree trunkDecodeTree) {
            int c = this.trunk.compareTo(trunkDecodeTree.trunk);
            return c != 0 ? c : this.rest.compareTo(trunkDecodeTree.rest);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.compareTo((TrunkDecodeTree)obj) == 0;
        }

        public int hashCode() {
            int hash = 5;
            hash = 47 * hash + Objects.hashCode(this.trunk);
            hash = 47 * hash + Objects.hashCode(this.rest);
            return hash;
        }

        @Override
        public Set<String> getPreferOverNames() {
            return this.trunk.getPreferOverNames();
        }

        @Override
        public Decode getDecode() {
            return this.trunk;
        }
    }

    public static abstract class AbstractDecodesCollection<T extends ElementaryDecode>
    implements Iterable<T> {
        protected Map<String, T> map;
        private T preferred;

        AbstractDecodesCollection(Iterable<T> iterable, int size) {
            this.map = new LinkedHashMap<String, T>(size);
            iterable.forEach(e -> this.add(e));
        }

        AbstractDecodesCollection(List<T> list) {
            this(list, list.size());
        }

        AbstractDecodesCollection(Map<String, T> map) {
            this.map = new HashMap<String, T>(map);
        }

        public T getPreferred() {
            return this.preferred;
        }

        @Override
        public Iterator<T> iterator() {
            return this.map.values().iterator();
        }

        void reduce(Map<String, NamedProtocol> parsedProtocols) {
            HashMap<String, T> old = new HashMap<String, T>(this.map);
            for (Map.Entry kvp : old.entrySet()) {
                if (!this.toBeRemoved((ElementaryDecode)kvp.getValue(), parsedProtocols)) continue;
                this.map.remove(kvp.getKey());
            }
            Iterator<T> it = this.map.values().iterator();
            this.preferred = it.hasNext() ? (ElementaryDecode)it.next() : null;
        }

        void computePreferred(Map<String, NamedProtocol> parsedProtocols) {
            for (ElementaryDecode decode : this.map.values()) {
                if (this.toBeRemoved(decode, parsedProtocols)) continue;
                this.preferred = decode;
                return;
            }
        }

        private boolean toBeRemoved(T removeCandidate, Map<String, NamedProtocol> parsedProtocols) {
            for (ElementaryDecode remover : this.map.values()) {
                if (remover.equals(removeCandidate) || !this.toBeRemoved(removeCandidate, remover, parsedProtocols, 0)) continue;
                return true;
            }
            return false;
        }

        private boolean toBeRemoved(T removeCandidate, HasPreferOvers remover, Map<String, NamedProtocol> parsedProtocols, int level) {
            if (level > 10) {
                logger.log(Level.SEVERE, "Max prefer-over depth reached using protocol {0}, cycle likely. Please report.", remover.getName());
                return false;
            }
            logger.log(Level.FINEST, "Is {0} to be removed from {1}, level {2}", new Object[]{removeCandidate.getName(), remover.getName(), level});
            Set<String> preferOvers = remover.getPreferOverNames();
            boolean remove = preferOvers.contains(removeCandidate.getName());
            if (remove) {
                logger.log(Level.FINE, "Decode {0} removed by {1}", new Object[]{removeCandidate.getName(), remover.getName()});
                return true;
            }
            for (String preferOver : preferOvers) {
                ElementaryDecode t = (ElementaryDecode)this.map.get(preferOver);
                HasPreferOvers hpo = t != null ? t.getDecode() : (HasPreferOvers)parsedProtocols.get(preferOver.toLowerCase(Locale.US));
                boolean success = this.toBeRemoved(removeCandidate, hpo, parsedProtocols, level + 1);
                if (!success) continue;
                return true;
            }
            return false;
        }

        public void add(T decode) {
            this.map.put(decode.getName(), decode);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public T get(String name) {
            return (T)((ElementaryDecode)this.map.get(name));
        }

        public boolean contains(String name) {
            return this.map.containsKey(name);
        }

        public void remove(String protName) {
            if (protName != null && this.map.containsKey(protName)) {
                this.map.remove(protName);
            }
        }

        public void remove(T decode) {
            this.remove(decode.getName());
        }

        public int size() {
            return this.map.size();
        }

        public final void sort() {
            List<ElementaryDecode> list = this.sortedValues();
            this.map.clear();
            list.forEach(d -> this.add(d));
        }

        abstract List<T> sortedValues();

        public T first() {
            Iterator<T> it = this.iterator();
            return (T)(it.hasNext() ? (ElementaryDecode)it.next() : null);
        }

        public void println(PrintStream out, int radix, String separator, boolean quiet) {
            if (this.isEmpty()) {
                this.printNoDecodes(out, quiet);
            }
            this.map.values().forEach(decode -> out.println("\t" + decode.toString(radix, separator)));
        }

        protected void printNoDecodes(PrintStream out, boolean quiet) {
            out.println();
        }
    }
}

