/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.Duration;
import org.harctoolbox.irp.ItemCodeGenerator;

public final class DumpItemCodeGenerator
extends ItemCodeGenerator {
    private static final Logger logger = Logger.getLogger(Duration.class.getName());
    private final String name;
    private final Map<String, Object> aggregates;

    private static String mkPrefix(int level) {
        StringBuilder s = new StringBuilder(level);
        for (int i = 0; i < level; ++i) {
            s.append('\t');
        }
        return s.toString();
    }

    private static String render(Object object, int level) {
        Objects.requireNonNull(object);
        if (object instanceof List) {
            return DumpItemCodeGenerator.render((List)object, level);
        }
        if (object instanceof Map) {
            return DumpItemCodeGenerator.render((Map)object, level);
        }
        return object.toString();
    }

    private static String render(List<?> list, int level) {
        StringBuilder str = new StringBuilder(100);
        String prefix = DumpItemCodeGenerator.mkPrefix(level);
        str.append("[");
        if (list.isEmpty()) {
            str.append("]");
        } else {
            list.forEach(obj -> str.append(IrCoreUtils.LINE_SEPARATOR).append(prefix).append(DumpItemCodeGenerator.render(obj, level + 1)));
            str.append(IrCoreUtils.LINE_SEPARATOR).append(DumpItemCodeGenerator.mkPrefix(level - 1)).append(']');
        }
        return str.toString();
    }

    private static String render(Map<String, Object> map, int level) {
        StringBuilder str = new StringBuilder(100);
        String prefix = DumpItemCodeGenerator.mkPrefix(level);
        str.append("{");
        if (map.isEmpty()) {
            str.append("}");
        } else {
            map.entrySet().forEach(kvp -> str.append(IrCoreUtils.LINE_SEPARATOR).append(prefix).append((String)kvp.getKey()).append(" = ").append(DumpItemCodeGenerator.render(kvp.getValue(), level + 1)));
            str.append(IrCoreUtils.LINE_SEPARATOR).append(DumpItemCodeGenerator.mkPrefix(level - 1)).append('}');
        }
        return str.toString();
    }

    private static String render(String name, Object object, int level) {
        String prefix = DumpItemCodeGenerator.mkPrefix(level);
        StringBuilder str = new StringBuilder(100);
        str.append(prefix).append(name).append(" = ").append(DumpItemCodeGenerator.render(object, level + 1));
        return str.toString();
    }

    public DumpItemCodeGenerator(String name) {
        this.name = name;
        this.aggregates = new HashMap<String, Object>(10);
    }

    @Override
    public void setAttribute(String name, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addAttribute(String name, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addAggregate(String string, Object ... args) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addAggregateList(String name, Map<String, Object> map) {
        this.aggregates.put(name, map);
    }

    @Override
    public void inspect() {
        logger.warning("Inspect not supported, request ignored.");
    }

    @Override
    public void inspectAndWait() {
        this.inspect();
    }

    @Override
    public String render() {
        return DumpItemCodeGenerator.render(this.name, this.aggregates, 0) + IrCoreUtils.LINE_SEPARATOR;
    }
}

