/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BitCounter;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.Number;
import org.harctoolbox.irp.Protocol;

public final class DuplicateFinder {
    private int counter;
    private final Map<String, DuplicateCollection> result;
    private final Iterable<Protocol> protocols;

    public DuplicateFinder(Iterable<Protocol> protocols, Map<String, BitCounter> bitUsage) throws NameUnassignedException {
        this.protocols = protocols;
        this.counter = 0;
        this.result = new LinkedHashMap<String, DuplicateCollection>(bitUsage.size());
        for (Map.Entry<String, BitCounter> kvp : bitUsage.entrySet()) {
            String name = kvp.getKey();
            DuplicateCollection duplicates = this.findDuplicates(name, kvp.getValue());
            this.result.put(name, duplicates);
        }
    }

    public DuplicateFinder(String varName, Iterable<Protocol> protocols) throws NameUnassignedException {
        this(protocols, BitCounter.scrutinizeProtocols(protocols));
    }

    private DuplicateCollection findDuplicates(String name, BitCounter bitCounter) throws NameUnassignedException {
        DuplicateCollection duplicates = new DuplicateCollection(bitCounter);
        for (int pos = bitCounter.getNumberBits() - 1; pos > 0; --pos) {
            DuplicateEntry duplicate;
            if (bitCounter.getType(pos) != BitCounter.BitCounterType.varying || (duplicate = this.findDuplicate(name, bitCounter, pos)) == null) continue;
            duplicates.add(duplicate);
        }
        duplicates.combine();
        return duplicates;
    }

    private DuplicateEntry findDuplicate(String name, BitCounter bitCounter, int pos) throws NameUnassignedException {
        DuplicateEntry answer;
        ArrayList<DuplicateEntry.Occurance> occurances = new ArrayList<DuplicateEntry.Occurance>(8);
        occurances.add(new DuplicateEntry.Occurance(pos));
        block4: for (int i = pos - 1; i >= 0; --i) {
            if (bitCounter.getType(i) != BitCounter.BitCounterType.varying) continue;
            CompareType cmp = this.compare(name, pos, i);
            switch (cmp.ordinal()) {
                case 0: {
                    occurances.add(new DuplicateEntry.Occurance(i, false));
                    continue block4;
                }
                case 1: {
                    occurances.add(new DuplicateEntry.Occurance(i, true));
                    continue block4;
                }
            }
        }
        if (occurances.size() > 1) {
            answer = new DuplicateEntry(1, occurances, this.counter);
            ++this.counter;
        } else {
            answer = null;
        }
        return answer;
    }

    private CompareType compare(String name, int pos, int i) throws NameUnassignedException {
        boolean identical = true;
        boolean inverted = true;
        for (Protocol protocol : this.protocols) {
            boolean equal = this.compare(name, protocol, pos, i);
            identical = identical && equal;
            boolean bl = inverted = inverted && !equal;
            if (identical || inverted) continue;
            return CompareType.none;
        }
        return identical ? CompareType.identical : (inverted ? CompareType.inverted : CompareType.none);
    }

    private boolean compare(String name, Protocol protocol, int pos, int i) throws NameUnassignedException {
        Number x = protocol.getDefinitions().get(name).toNumber();
        return x.testBit(pos) == x.testBit(i);
    }

    public Map<String, DuplicateCollection> getDuplicates() {
        return Collections.unmodifiableMap(this.result);
    }

    public static class DuplicateCollection {
        private final List<DuplicateEntry> list;
        private final Map<Integer, DuplicateEntry> index;
        private final BitCounter bitCounter;

        private DuplicateCollection(BitCounter bitCounter) {
            this.bitCounter = bitCounter;
            this.list = new ArrayList<DuplicateEntry>(8);
            this.index = new HashMap<Integer, DuplicateEntry>(8);
        }

        public void add(DuplicateEntry duplicate) {
            if (!this.index.containsKey(duplicate.getFirstOccurance())) {
                this.list.add(duplicate);
                this.addToIndex(duplicate);
            }
        }

        private void addToIndex(DuplicateEntry duplicate) {
            duplicate.occurances.forEach(occurance -> this.index.put(occurance.position, duplicate));
        }

        public DuplicateEntry getPosition(int n) {
            return this.index.get(n);
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(CharSequence delimiter) {
            StringJoiner str = new StringJoiner(delimiter);
            int i = this.bitCounter.getNumberBits() - 1;
            while (i >= 0) {
                DuplicateEntry de = this.index.get(i);
                if (de != null) {
                    str.add("(" + de.occuranceIsInvertedChar(i) + de.name + ":" + de.length + ")");
                    i -= de.length;
                    continue;
                }
                str.add(this.bitCounter.getType(i).toString());
                --i;
            }
            return str.toString();
        }

        public List<Integer> getRecommendedParameterWidths() {
            ArrayList<Integer> result = new ArrayList<Integer>(8);
            int pos = this.bitCounter.getNumberBits() - 1;
            boolean lastWasConstant = true;
            int current = 0;
            while (pos >= 0) {
                DuplicateEntry variable = this.index.get(pos);
                if (variable != null) {
                    if (current > 0) {
                        result.add(current);
                    }
                    result.add(variable.length);
                    pos -= variable.length;
                    current = 0;
                    lastWasConstant = false;
                    continue;
                }
                BitCounter.BitCounterType type = this.bitCounter.getType(pos);
                if (type == BitCounter.BitCounterType.zero || type == BitCounter.BitCounterType.one) {
                    if (lastWasConstant) {
                        ++current;
                    } else {
                        if (current > 0) {
                            result.add(current);
                        }
                        current = 1;
                    }
                    lastWasConstant = true;
                } else {
                    if (lastWasConstant) {
                        if (current > 0) {
                            result.add(current);
                        }
                        current = 1;
                    } else {
                        current = 1;
                    }
                    lastWasConstant = false;
                }
                --pos;
            }
            if (current > 0) {
                result.add(current);
            }
            return result;
        }

        public List<String> getNames() {
            ArrayList<String> names = new ArrayList<String>(this.list.size());
            this.list.forEach(de -> names.add(((DuplicateEntry)de).getName()));
            return names;
        }

        private void combine() {
            ArrayList<DuplicateEntry> entries = new ArrayList<DuplicateEntry>(this.list);
            entries.stream().filter(entry -> this.list.contains(entry)).forEachOrdered(entry -> {
                int n = this.hasSameSuccessors((DuplicateEntry)entry);
                if (n > 0) {
                    ((DuplicateEntry)entry).length += n;
                    this.nuke((DuplicateEntry)entry, n);
                }
            });
            this.rebuildIndex();
        }

        private int hasSameSuccessors(DuplicateEntry entry) {
            int length = 1;
            while (true) {
                for (DuplicateEntry.Occurance occurence : entry.occurances) {
                    boolean ok = this.hasSameSuccessor(entry, length, occurence);
                    if (ok) continue;
                    return length - 1;
                }
                ++length;
            }
        }

        private boolean hasSameSuccessor(DuplicateEntry entry, int length, DuplicateEntry.Occurance occurence) {
            DuplicateEntry first = this.index.get(entry.getFirstOccurance() - length);
            DuplicateEntry second = this.index.get(occurence.position - length);
            return first != null ? first.equals(second) : false;
        }

        private void nuke(DuplicateEntry entry, int n) {
            for (int i = 1; i <= n; ++i) {
                DuplicateEntry de = this.index.get(entry.getFirstOccurance() - i);
                this.list.remove(de);
            }
        }

        private void rebuildIndex() {
            this.index.clear();
            this.list.forEach(de -> this.addToIndex((DuplicateEntry)de));
        }

        public String getRecommendedParameterWidthsAsString() {
            List<Integer> lst = this.getRecommendedParameterWidths();
            StringJoiner stringJoiner = new StringJoiner(",");
            lst.forEach(x -> stringJoiner.add(Integer.toString(x)));
            return stringJoiner.toString();
        }
    }

    public static class DuplicateEntry {
        private final String name;
        private int length;
        private final List<Occurance> occurances;

        private static String mkName(int counter) {
            return new String(new char[]{(char)(97 + counter)});
        }

        public DuplicateEntry(int length, List<Occurance> occurances, int counter) {
            this.length = length;
            this.occurances = occurances;
            this.name = DuplicateEntry.mkName(counter);
        }

        public int getFirstOccurance() {
            return this.occurances.get((int)0).position;
        }

        public String toString() {
            StringJoiner stringJoiner = new StringJoiner(",", "{", "}");
            this.occurances.forEach(occurence -> stringJoiner.add(occurence.toString()));
            return this.name + ":" + this.length + stringJoiner;
        }

        private String getName() {
            return this.name;
        }

        private String occuranceIsInvertedChar(int i) {
            return this.occuranceIsInverted(i) ? "~" : "";
        }

        private boolean occuranceIsInverted(int i) {
            for (Occurance occurance : this.occurances) {
                if (occurance.position != i) continue;
                return occurance.inverted;
            }
            throw new ThisCannotHappenException();
        }

        public static class Occurance {
            public final int position;
            public final boolean inverted;

            public Occurance(int position) {
                this(position, false);
            }

            public Occurance(int position, boolean inverted) {
                this.position = position;
                this.inverted = inverted;
            }

            public String toString() {
                return (this.inverted ? "~" : "") + Integer.toString(this.position);
            }
        }
    }

    private static enum CompareType {
        identical,
        inverted,
        none;

    }
}

