/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.DurationType;
import org.harctoolbox.irp.Evaluatable;
import org.harctoolbox.irp.Extent;
import org.harctoolbox.irp.Flash;
import org.harctoolbox.irp.Floatable;
import org.harctoolbox.irp.Gap;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.IrStream;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameOrNumber;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.ParserDriver;
import org.harctoolbox.irp.RecognizeData;
import org.harctoolbox.irp.RenderData;
import org.harctoolbox.irp.SignalRecognitionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Duration
extends IrpObject
implements IrStreamItem,
Floatable,
Evaluatable {
    private static final Logger logger = Logger.getLogger(Duration.class.getName());
    private static final double DUMMYTIMEUNIT = 999.0;
    protected Double us = null;
    protected Double time_periods = null;
    protected Double time_units = null;
    protected NameOrNumber nameOrNumber = null;
    protected String unit = null;

    public static Duration newDuration(String str) {
        return Duration.newDuration(new ParserDriver(str));
    }

    public static Duration newDuration(ParserDriver parserDriver) {
        IrpParser parser = parserDriver.getParser();
        try {
            return Duration.newDuration(parser.duration());
        }
        catch (ParseCancellationException ex) {
            return Duration.newDuration(parser.extent());
        }
    }

    public static Duration newDuration(IrpParser.DurationContext d) {
        ParseTree child = d.getChild(0);
        return child instanceof IrpParser.FlashContext ? new Flash((IrpParser.FlashContext)child) : (child instanceof IrpParser.GapContext ? new Gap((IrpParser.GapContext)child) : new Extent((IrpParser.ExtentContext)child));
    }

    public static Duration newDuration(IrpParser.ExtentContext e) {
        return new Extent(e);
    }

    public static boolean isOn(int index) {
        return index % 2 == 0;
    }

    protected Duration(double d, String unit) {
        super(null);
        this.nameOrNumber = new NameOrNumber(d);
        this.unit = unit != null ? unit : "";
    }

    protected Duration(double us) {
        this(us, "u");
    }

    protected Duration(IrpParser.Name_or_numberContext ctx, String unit) {
        super(ctx);
        this.nameOrNumber = new NameOrNumber(ctx);
        this.unit = unit != null ? unit : "";
    }

    protected Duration(NameOrNumber nameOrNumber, String unit) {
        super(null);
        this.nameOrNumber = nameOrNumber;
        this.unit = unit;
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return this.nameOrNumber == null || this.nameOrNumber.constant(nameEngine);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + IrCoreUtils.hashForDouble(this.us);
        hash = 43 * hash + IrCoreUtils.hashForDouble(this.time_periods);
        hash = 43 * hash + IrCoreUtils.hashForDouble(this.time_units);
        hash = 43 * hash + Objects.hashCode(this.nameOrNumber);
        hash = 43 * hash + Objects.hashCode(this.unit);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)obj;
        return this.unit.equals(other.unit) && IrCoreUtils.approximatelyEquals(this.us, other.us) && IrCoreUtils.approximatelyEquals(this.time_periods, other.time_periods) && IrCoreUtils.approximatelyEquals(this.time_units, other.time_units) && this.nameOrNumber.equals(other.nameOrNumber);
    }

    private void compute(GeneralSpec generalSpec, NameEngine nameEngine) throws NameUnassignedException, IrpInvalidArgumentException {
        double time = this.nameOrNumber.toFloat(generalSpec, nameEngine);
        switch (this.unit) {
            case "p": {
                this.time_periods = time;
                break;
            }
            case "m": {
                this.us = IrCoreUtils.milliseconds2microseconds(time);
                break;
            }
            case "u": {
                this.us = time;
                break;
            }
            default: {
                this.time_units = time;
            }
        }
    }

    private double multiplicator(GeneralSpec generalSpec) {
        Objects.requireNonNull(this.time_units);
        return this.unit.equals("p") ? IrCoreUtils.seconds2microseconds(1.0 / generalSpec.getFrequencyWitDefault()) : (this.unit.equals("m") ? 1000.0 : (this.unit.equals("u") ? 1.0 : this.time_units));
    }

    public abstract double evaluateWithSign(GeneralSpec var1, NameEngine var2, double var3) throws NameUnassignedException, IrpInvalidArgumentException;

    public double evaluate(GeneralSpec generalSpec, NameEngine nameEngine, double elapsed) throws NameUnassignedException, IrpInvalidArgumentException {
        this.compute(generalSpec, nameEngine);
        if (this.time_periods != null) {
            if (generalSpec == null) {
                return 999.0;
            }
            if (generalSpec.getFrequencyWitDefault() > 0.0) {
                return IrCoreUtils.seconds2microseconds(this.time_periods / generalSpec.getFrequencyWitDefault());
            }
            throw new ThisCannotHappenException("Units in p and frequency == 0 do not go together.");
        }
        if (this.time_units != null) {
            if (generalSpec == null) {
                return this.time_units * 999.0;
            }
            if (generalSpec.getUnit() > 0.0) {
                return this.time_units * generalSpec.getUnit();
            }
            throw new ThisCannotHappenException("Relative units and unit == 0 do not go together.");
        }
        return this.us;
    }

    public double evaluate(GeneralSpec generalSpec, NameEngine nameEngine) throws NameUnassignedException, IrpInvalidArgumentException {
        return this.evaluate(generalSpec, nameEngine, 0.0);
    }

    protected abstract Duration evaluatedDuration(GeneralSpec var1, NameEngine var2) throws NameUnassignedException, IrpInvalidArgumentException;

    @Override
    public final boolean isEmpty(NameEngine nameEngine) throws NameUnassignedException, IrpInvalidArgumentException {
        return this.evaluate(null, nameEngine, 0.0) == 0.0;
    }

    @Override
    public double toFloat(GeneralSpec generalSpec, NameEngine nameEngine) throws NameUnassignedException, IrpInvalidArgumentException {
        return this.evaluate(generalSpec, nameEngine, 0.0);
    }

    @Override
    public void render(RenderData renderData, List<BitSpec> bitSpecs) throws NameUnassignedException {
        try {
            renderData.add(this.evaluatedDuration(renderData.getGeneralSpec(), renderData.getNameEngine()));
        }
        catch (IrpInvalidArgumentException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    @Override
    public void decode(RecognizeData recognizeData, List<BitSpec> bitSpecStack, boolean isLast) throws SignalRecognitionException {
        double wanted;
        logger.log(recognizeData.logRecordEnter(this));
        if (!recognizeData.check(this.isOn())) {
            throw new SignalRecognitionException("Either end of sequence, or found flash when gap expected, or vice versa");
        }
        double actual = recognizeData.get();
        try {
            wanted = this.toFloat(recognizeData.getGeneralSpec(), recognizeData.getNameEngine());
        }
        catch (IrpInvalidArgumentException | NameUnassignedException ex) {
            throw new SignalRecognitionException(ex);
        }
        this.recognize(recognizeData, actual, wanted, isLast);
        logger.log(recognizeData.logRecordExit(this));
    }

    @Override
    public void evaluate(RenderData renderData, List<BitSpec> bitSpecStack) throws NameUnassignedException {
        this.render(renderData, bitSpecStack);
    }

    @Override
    public BareIrStream extractPass(IrSignal.Pass pass, IrStream.PassExtractorState state) {
        return new BareIrStream(this);
    }

    @Override
    public Element toElement(Document document) {
        Element element = super.toElement(document);
        element.setAttribute("unit", this.unit);
        element.appendChild(this.nameOrNumber.toElement(document));
        return element;
    }

    @Override
    public String toIrpString(int radix) {
        return this.nameOrNumber.toIrpString(radix) + this.unit;
    }

    @Override
    public Integer numberOfBareDurations() {
        return 1;
    }

    @Override
    public Integer numberOfDurations() {
        return 1;
    }

    @Override
    public Integer numberOfBits() {
        return 0;
    }

    protected void recognize(RecognizeData recognizeData, double actual, double wanted, boolean isLast) throws SignalRecognitionException {
        boolean equals = IrCoreUtils.approximatelyEquals(actual, wanted, recognizeData.getAbsoluteTolerance(), recognizeData.getRelativeTolerance());
        if (equals) {
            recognizeData.consume();
        } else if (actual > wanted && recognizeData.allowChopping()) {
            recognizeData.consume(wanted);
        } else if (recognizeData.leadoutOk(isLast)) {
            recognizeData.consume();
        } else {
            throw new SignalRecognitionException("Duration does not parse, wanted " + wanted + ", was " + actual + ", position = " + recognizeData.getPosition());
        }
    }

    protected abstract boolean isOn();

    @Override
    public boolean interleavingOk(DurationType last, boolean gapFlashBitSpecs) {
        return last == DurationType.none || last == DurationType.newDurationType(!this.isOn());
    }

    @Override
    public boolean interleavingOk(DurationType toCheck, DurationType last, boolean gapFlashBitSpecs) {
        DurationType current = DurationType.newDurationType(this.isOn());
        return current != toCheck || last != current;
    }

    @Override
    public DurationType endingDurationType(DurationType last, boolean gapFlashBitSpecs) {
        return DurationType.newDurationType(this.isOn());
    }

    @Override
    public DurationType startingDuratingType(DurationType last, boolean gapFlashBitSpecs) {
        return DurationType.newDurationType(this.isOn());
    }

    @Override
    public int weight() {
        return this.nameOrNumber.weight();
    }

    public String getUnit() {
        return this.unit;
    }

    public double getTimeInUnits() throws InvalidArgumentException {
        return this.nameOrNumber.toRawNumber();
    }

    @Override
    public boolean hasExtent() {
        return false;
    }

    @Override
    public Set<String> assignmentVariables() {
        return new HashSet<String>(0);
    }

    @Override
    public Map<String, Object> propertiesMap(GeneralSpec generalSpec, NameEngine nameEngine) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("kind", this.getClass().getSimpleName());
        try {
            long num = Math.round(this.toFloat(generalSpec, null));
            map.put("microseconds", num);
            return map;
        }
        catch (IrpInvalidArgumentException | NameUnassignedException irpException) {
            map.put("name", this.nameOrNumber.toString());
            map.put("multiplicator", this.multiplicator(generalSpec));
            return map;
        }
    }

    @Override
    public Double microSeconds(GeneralSpec generalSpec, NameEngine nameEngine) {
        try {
            return this.evaluate(generalSpec, nameEngine);
        }
        catch (IrpInvalidArgumentException | NameUnassignedException ex) {
            return null;
        }
    }

    @Override
    public boolean nonConstantBitFieldLength() {
        return false;
    }

    @Override
    public Integer guessParameterLength(String name) {
        return null;
    }

    @Override
    public TreeSet<Double> allDurationsInMicros(GeneralSpec generalSpec, NameEngine nameEngine) {
        TreeSet<Double> result = new TreeSet<Double>();
        result.add(this.microSeconds(generalSpec, nameEngine));
        return result;
    }
}

