/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.EquationSolving;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.Name;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.PrimaryItem;
import org.harctoolbox.irp.RecognizeData;

public class Equation {
    private EquationSolving leftHandSide;
    private BitwiseParameter rightHandSide;
    private RecognizeData recognizeData;

    public Equation(EquationSolving leftHandSide, BitwiseParameter rightHandSide, RecognizeData recognizeData) {
        this.leftHandSide = leftHandSide;
        this.rightHandSide = rightHandSide;
        this.recognizeData = recognizeData;
    }

    public Equation(EquationSolving leftHandSide, PrimaryItem rightHandSide, NameEngine nameEngine) throws NameUnassignedException {
        this(leftHandSide, rightHandSide.toLong(nameEngine), new RecognizeData(nameEngine));
    }

    public Equation(EquationSolving leftHandSide, Long rightHandSide, RecognizeData recognizeData) {
        this(leftHandSide, new BitwiseParameter(rightHandSide), recognizeData);
    }

    public Equation(EquationSolving leftHandSide, Long rightHandSide, long width, RecognizeData recognizeData) {
        this(leftHandSide, new BitwiseParameter(rightHandSide, IrCoreUtils.ones(width)), recognizeData);
    }

    public Equation(EquationSolving leftHandSide, Long rightHandSide) {
        this(leftHandSide, rightHandSide, new RecognizeData());
    }

    public Equation(String eq, long rhs) {
        this(Expression.newExpression(eq), (Long)rhs);
    }

    public Equation(String eq, String rhs, String string) throws InvalidNameException, NameUnassignedException {
        this((EquationSolving)Expression.newExpression(eq), Expression.newExpression(rhs), new NameEngine(string));
    }

    public Equation(String eq, String rhs) throws NameUnassignedException {
        this((EquationSolving)Expression.newExpression(eq), Expression.newExpression(rhs), NameEngine.EMPTY);
    }

    public boolean solve() throws NameUnassignedException {
        while (this.isOk() && !this.isFinished()) {
            this.solveStep();
        }
        return this.isOk();
    }

    private boolean isOk() {
        return this.leftHandSide != null && this.rightHandSide != null;
    }

    private boolean isFinished() {
        return this.leftHandSide instanceof Name;
    }

    private void solveStep() throws NameUnassignedException {
        this.rightHandSide = this.leftHandSide.invert(this.rightHandSide, this.recognizeData);
        this.leftHandSide = this.leftHandSide.leftHandSide();
    }

    public String toString() {
        return this.leftHandSide.toString() + "=" + this.rightHandSide.toString();
    }

    public Name getName() {
        return this.isOk() && this.isFinished() ? (Name)this.leftHandSide.leftHandSide() : null;
    }

    public BitwiseParameter getValue() {
        return this.isOk() && this.isFinished() ? this.rightHandSide : null;
    }

    public Long getBitmask() {
        return this.rightHandSide.getBitmask();
    }

    public boolean expandLhsSolve() throws NameUnassignedException {
        String name = this.getName().toString();
        Expression expression = this.recognizeData.getNameEngine().getPossiblyNull(name);
        if (expression != null) {
            this.leftHandSide = expression;
            return this.solve();
        }
        return false;
    }
}

