/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Logger;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.BitStream;
import org.harctoolbox.irp.Duration;
import org.harctoolbox.irp.Evaluatable;
import org.harctoolbox.irp.Extent;
import org.harctoolbox.irp.Flash;
import org.harctoolbox.irp.Gap;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;

final class EvaluatedIrStream {
    private static final Logger logger = Logger.getLogger(EvaluatedIrStream.class.getName());
    private final List<Evaluatable> elements;
    private final GeneralSpec generalSpec;
    private final IrSignal.Pass pass;
    private final NameEngine nameEngine;
    private IrSignal.Pass state;

    private static IrSequence mkIrSequence(List<Double> durations) throws OddSequenceLengthException {
        List<Double> interleaved = IrSequence.toInterleavingList(durations);
        return new IrSequence(interleaved);
    }

    EvaluatedIrStream(NameEngine nameEngine, GeneralSpec generalSpec, IrSignal.Pass pass) {
        this.nameEngine = nameEngine;
        this.generalSpec = generalSpec;
        this.pass = pass;
        this.elements = new ArrayList<Evaluatable>(10);
        this.state = null;
    }

    EvaluatedIrStream(EvaluatedIrStream evaluatedIrStream) {
        this(evaluatedIrStream.nameEngine, evaluatedIrStream.generalSpec, evaluatedIrStream.pass);
        this.state = evaluatedIrStream.state;
    }

    IrSequence toIrSequence() throws NameUnassignedException, IrpInvalidArgumentException, OddSequenceLengthException {
        ArrayList<Double> times = new ArrayList<Double>(this.elements.size() * 10);
        double elapsed = 0.0;
        for (Evaluatable element : this.elements) {
            Duration duration = (Duration)element;
            double time = duration.evaluateWithSign(this.generalSpec, this.nameEngine, elapsed);
            if (Math.abs(time) < 1.0E-4) {
                logger.warning("Zero duration ignored");
                continue;
            }
            times.add(time);
            if (duration instanceof Extent) {
                elapsed = 0.0;
                continue;
            }
            elapsed += Math.abs(time);
        }
        return EvaluatedIrStream.mkIrSequence(times);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        this.elements.stream().forEach(element -> joiner.add(element.toString()));
        return joiner.toString() + " " + this.nameEngine.toString();
    }

    void add(EvaluatedIrStream evaluatedIrStream) {
        if (evaluatedIrStream == null || evaluatedIrStream.isEmpty()) {
            return;
        }
        int lastIndex = this.elements.size() - 1;
        if (lastIndex >= 0 && this.elements.get(lastIndex) instanceof BitStream && evaluatedIrStream.elements.get(0) instanceof BitStream) {
            this.squeezeBitStreams((BitStream)evaluatedIrStream.elements.get(0));
            evaluatedIrStream.removeHead();
            this.add(evaluatedIrStream);
        } else {
            this.elements.addAll(evaluatedIrStream.elements);
        }
    }

    void add(BitStream bitStream) {
        int lastIndex = this.elements.size() - 1;
        if (lastIndex >= 0 && this.elements.get(lastIndex) instanceof BitStream) {
            this.squeezeBitStreams(bitStream);
        } else {
            this.elements.add(bitStream);
        }
    }

    public void reduce(BitSpec bitSpec) throws NameUnassignedException {
        int index = 0;
        while (index < this.elements.size()) {
            if (this.elements.get(index) instanceof BitStream) {
                index += this.reduce(bitSpec, index);
                continue;
            }
            ++index;
        }
        for (Evaluatable element : this.elements) {
            if (!(element instanceof BitStream) || ((BitStream)element).getLength() % (long)bitSpec.getChunkSize() == 0L) continue;
            throw new BitSpec.IncompatibleBitSpecException(bitSpec);
        }
    }

    private int reduce(BitSpec bitSpec, int index) throws NameUnassignedException {
        BitStream bitStream = (BitStream)this.elements.get(index);
        this.elements.remove(index);
        EvaluatedIrStream bitFieldDurations = bitStream.evaluate(this.pass, this.pass, this.generalSpec, this.nameEngine, bitSpec);
        int length = bitFieldDurations.elements.size();
        this.elements.addAll(index, bitFieldDurations.elements);
        return length;
    }

    void add(Duration evaluatable) {
        this.elements.add(evaluatable);
    }

    private void removeHead() {
        this.elements.remove(0);
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public int getLength() {
        return this.elements.size();
    }

    public double get(int i) throws IrpInvalidArgumentException, NameUnassignedException {
        Evaluatable object = this.elements.get(i);
        if (!(object instanceof Duration)) {
            throw new ThisCannotHappenException("Not numeric");
        }
        return ((Duration)object).evaluateWithSign(this.generalSpec, this.nameEngine, 0.0);
    }

    private void squeezeBitStreams(BitStream bitStream) {
        int lastIndex = this.elements.size() - 1;
        BitStream old = (BitStream)this.elements.get(lastIndex);
        old.add(bitStream, this.generalSpec, this.nameEngine);
    }

    public IrSignal.Pass getState() {
        return this.state;
    }

    public void setState(IrSignal.Pass state) {
        this.state = state;
    }

    boolean isFlash(int i) {
        return this.elements.get(i) instanceof Flash;
    }

    boolean isGap(int i) {
        return this.elements.get(i) instanceof Gap;
    }
}

