/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.List;
import java.util.Map;
import org.antlr.v4.gui.TreeViewer;
import org.antlr.v4.runtime.tree.ParseTree;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.FivePartExpression;
import org.harctoolbox.irp.IrpParseException;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.IrpUtils;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.Number;
import org.harctoolbox.irp.NumberExpression;
import org.harctoolbox.irp.OnePartExpression;
import org.harctoolbox.irp.ParserDriver;
import org.harctoolbox.irp.PrimaryItem;
import org.harctoolbox.irp.ThreePartExpression;
import org.harctoolbox.irp.TwoPartExpression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Expression
extends PrimaryItem {
    public static final Expression TRUE = Expression.newExpression(1L);
    public static final Expression FALSE = Expression.newExpression(0L);
    private ParserDriver parserDriver = null;

    public static Expression newExpression(long value) {
        return new NumberExpression(value);
    }

    public static Expression newExpressionEOF(String str) throws IrpParseException {
        ParserDriver parserDriver = new ParserDriver(str);
        Expression expression = Expression.newExpressionEOF(parserDriver);
        String matched = expression.getParseTree().getText();
        if (matched.length() < str.replaceAll("\\s+", "").length()) {
            throw new IrpParseException(str, "Did not match all input, just \"" + matched + "\".");
        }
        return expression;
    }

    public static Expression newExpression(String str) {
        try {
            long number = Long.parseLong(str);
            return new NumberExpression(number);
        }
        catch (NumberFormatException ex) {
            return Expression.newExpression(new ParserDriver(str));
        }
    }

    public static Expression newExpression(ParserDriver parserDriver) {
        Expression expression = Expression.newExpression(parserDriver.getParser().expression());
        expression.parserDriver = parserDriver;
        return expression;
    }

    public static Expression newExpressionEOF(ParserDriver parserDriver) {
        Expression expression = Expression.newExpression(parserDriver.getParser().expressionEOF().expression());
        expression.parserDriver = parserDriver;
        return expression;
    }

    static Expression newExpression(IrpParser.Para_expressionContext para_expressionContext) {
        return Expression.newExpression(para_expressionContext.expression());
    }

    static Expression newExpression(ParseTree ctx, IrpParser.Para_expressionContext para_expressionContext) {
        return Expression.newExpression(ctx, para_expressionContext.expression());
    }

    public static Expression newExpression(IrpParser.ExpressionContext ctx) {
        return Expression.newExpression((ParseTree)ctx, ctx);
    }

    public static Expression newExpression(ParseTree original, IrpParser.ExpressionContext ctx) {
        List children = ctx.children;
        switch (children.size()) {
            case 1: {
                return OnePartExpression.newExpression(original, ctx.getChild(0));
            }
            case 2: {
                return TwoPartExpression.newExpression(original, ctx.getChild(0).getText().charAt(0), ctx.expression(0));
            }
            case 3: {
                return ThreePartExpression.newExpression(original, ctx.expression(0), ctx.getChild(1).getText(), ctx.expression(1));
            }
            case 5: {
                return FivePartExpression.newExpression(original, ctx.expression(0), ctx.expression(1), ctx.expression(2));
            }
        }
        throw new ThisCannotHappenException("Unknown expression type");
    }

    protected static long cBoolean(boolean x) {
        return x ? 1L : 0L;
    }

    protected Expression(ParseTree ctx) {
        super(ctx);
    }

    public String toStringTree() {
        return this.parserDriver != null ? this.toStringTree(this.parserDriver) : null;
    }

    public TreeViewer toTreeViewer() {
        return this.toTreeViewer(this.parserDriver);
    }

    @Override
    public long toLong() throws NameUnassignedException {
        return this.toLong(NameEngine.EMPTY);
    }

    public Number toNumber() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, Object> propertiesMap(int noProperties) {
        return IrpUtils.propertiesMap(noProperties, "Expression");
    }

    @Override
    public Element toElement(Document document) {
        return document.createElement("Expression");
    }

    public boolean isNumericLiteral() {
        return false;
    }

    @Override
    public abstract boolean constant(NameEngine var1);
}

