/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.Duration;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameOrNumber;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.ParserDriver;
import org.harctoolbox.irp.RecognizeData;
import org.harctoolbox.irp.SignalRecognitionException;

public final class Extent
extends Duration {
    private static final Logger logger = Logger.getLogger(Extent.class.getName());

    public Extent(String str) {
        this(new ParserDriver(str));
    }

    public Extent(ParserDriver parserDriver) {
        this(parserDriver.getParser().extent());
    }

    public Extent(IrpParser.ExtentContext ctx) {
        super(ctx.name_or_number(), ctx.getChildCount() > 2 ? ctx.getChild(2).getText() : null);
    }

    public Extent(double d, String unit) {
        super(d, unit);
    }

    public Extent(double d) {
        this(d, null);
    }

    public Extent(NameOrNumber non, String unit) {
        super(non, unit);
    }

    @Override
    public IrStreamItem substituteConstantVariables(Map<String, Long> constantVariables) {
        return new Extent(this.nameOrNumber.substituteConstantVariables(constantVariables), this.unit);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Extent)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public double evaluate(GeneralSpec generalSpec, NameEngine nameEngine, double elapsed) throws NameUnassignedException, IrpInvalidArgumentException {
        double time = super.evaluate(generalSpec, nameEngine, 0.0) - elapsed;
        if (time < 0.0) {
            throw new IrpInvalidArgumentException("Argument of extent smaller than actual duration.");
        }
        return time;
    }

    @Override
    public double evaluateWithSign(GeneralSpec generalSpec, NameEngine nameEngine, double elapsed) throws NameUnassignedException, IrpInvalidArgumentException {
        return -this.evaluate(generalSpec, nameEngine, elapsed);
    }

    @Override
    public String toIrpString(int radix) {
        return "^" + super.toIrpString(radix);
    }

    @Override
    public void decode(RecognizeData recognizeData, List<BitSpec> bitSpecStack, boolean isLast) throws SignalRecognitionException {
        double theoretical;
        logger.log(recognizeData.logRecordEnter(this));
        double elapsed = recognizeData.elapsed();
        double physical = recognizeData.get();
        try {
            theoretical = this.toFloat(recognizeData.getGeneralSpec(), null) - elapsed;
        }
        catch (IrpInvalidArgumentException | NameUnassignedException ex) {
            throw new SignalRecognitionException(ex);
        }
        recognizeData.markExtentStart();
        this.recognize(recognizeData, physical, theoretical, isLast);
        logger.log(recognizeData.logRecordExit(this));
    }

    @Override
    protected boolean isOn() {
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        return hash + 31 * super.hashCode();
    }

    @Override
    public boolean hasExtent() {
        return true;
    }

    @Override
    protected Extent evaluatedDuration(GeneralSpec generalSpec, NameEngine nameEngine) throws NameUnassignedException, IrpInvalidArgumentException {
        return new Extent(this.evaluate(generalSpec, nameEngine), "u");
    }

    @Override
    public TreeSet<Double> allDurationsInMicros(GeneralSpec generalSpec, NameEngine nameEngine) {
        return new TreeSet<Double>();
    }
}

