/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.BareIrStream;
import org.harctoolbox.irp.BitDirection;
import org.harctoolbox.irp.BitField;
import org.harctoolbox.irp.BitSpec;
import org.harctoolbox.irp.BitStream;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.DurationType;
import org.harctoolbox.irp.Equation;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrStream;
import org.harctoolbox.irp.IrStreamItem;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.Name;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.Number;
import org.harctoolbox.irp.ParameterSpecs;
import org.harctoolbox.irp.ParserDriver;
import org.harctoolbox.irp.PrimaryItem;
import org.harctoolbox.irp.RecognizeData;
import org.harctoolbox.irp.RenderData;
import org.harctoolbox.irp.SignalRecognitionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class FiniteBitField
extends BitField
implements IrStreamItem {
    private static final Logger logger = Logger.getLogger(FiniteBitField.class.getName());
    public static final int MAXWIDTH = 63;
    private static boolean allowLargeBitfields = false;
    private PrimaryItem width;
    private boolean reverse;

    public static FiniteBitField newFiniteBitField(IrpParser.Finite_bitfieldContext ctx) {
        return new FiniteBitField(ctx);
    }

    public static void setAllowLargeBitfields(boolean aAllowLargeBitfields) {
        allowLargeBitfields = aAllowLargeBitfields;
    }

    private static void checkWidth(long width) {
        if (!allowLargeBitfields && width > 63L) {
            throw new IllegalArgumentException("Bitfields wider than 63 bits are currently not supported.");
        }
    }

    private static void checkWidth(PrimaryItem width) {
        try {
            FiniteBitField.checkWidth(width.toLong());
        }
        catch (NameUnassignedException nameUnassignedException) {
            // empty catch block
        }
    }

    public static long toLong(long data, long width, long chop, boolean complement, boolean reverse) {
        FiniteBitField.checkWidth(width);
        long x = data >> (int)chop;
        if (complement) {
            x ^= 0xFFFFFFFFFFFFFFFFL;
        }
        if (width < 63L) {
            x &= IrCoreUtils.ones(width);
        }
        if (reverse) {
            x = IrCoreUtils.reverse(x, (int)width);
        }
        return x;
    }

    public FiniteBitField(String str) {
        this(new ParserDriver(str));
    }

    private FiniteBitField(ParserDriver parserDriver) {
        this((IrpParser.Finite_bitfieldContext)parserDriver.getParser().bitfield());
    }

    public FiniteBitField(String name, long width) throws InvalidNameException {
        this(name, width, false);
    }

    public FiniteBitField(String name, long width, boolean complement) throws InvalidNameException {
        this(new Name(name), new Number(width), new Number(0), complement, false);
    }

    public FiniteBitField(long data, long width, long chop, boolean complement, boolean reverse) throws InvalidNameException {
        this(new Number(data), new Number(width), new Number(chop), complement, reverse);
    }

    private FiniteBitField(PrimaryItem data, PrimaryItem width, PrimaryItem chop, boolean complement, boolean reverse) throws InvalidNameException {
        this(null, data, width, chop, complement, reverse);
    }

    private FiniteBitField(IrpParser.Finite_bitfieldContext ctx, PrimaryItem data, PrimaryItem width, PrimaryItem chop, boolean complement, boolean reverse) {
        super(ctx, data, chop, complement);
        FiniteBitField.checkWidth(width);
        this.width = width;
        this.reverse = reverse;
    }

    public FiniteBitField(IrpParser.Finite_bitfieldContext ctx) {
        this(ctx, PrimaryItem.newPrimaryItem(ctx.primary_item(0)), PrimaryItem.newPrimaryItem(ctx.primary_item(1)), ctx.primary_item().size() > 2 ? PrimaryItem.newPrimaryItem(ctx.primary_item(2)) : PrimaryItem.newPrimaryItem(0L), !(ctx.getChild(0) instanceof IrpParser.Primary_itemContext), !(ctx.getChild(ctx.getChild(0) instanceof IrpParser.Primary_itemContext ? 2 : 3) instanceof IrpParser.Primary_itemContext));
    }

    @Override
    public FiniteBitField substituteConstantVariables(Map<String, Long> constantVariables) {
        try {
            return new FiniteBitField(this.getData().substituteConstantVariables(constantVariables), this.width.substituteConstantVariables(constantVariables), this.getChop().substituteConstantVariables(constantVariables), this.isComplement(), this.reverse);
        }
        catch (InvalidNameException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FiniteBitField)) {
            return false;
        }
        FiniteBitField other = (FiniteBitField)obj;
        return super.equals(obj) && this.reverse == other.reverse && this.width.equals(other.width);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.width);
        hash = 97 * hash + (this.reverse ? 1 : 0);
        return hash;
    }

    @Override
    public long toLong(NameEngine nameResolver) throws NameUnassignedException {
        return FiniteBitField.toLong(this.getData().toLong(nameResolver), this.width.toLong(nameResolver), this.getChop().toLong(nameResolver), this.isComplement(), this.reverse);
    }

    @Override
    public BitwiseParameter toBitwiseParameter(RecognizeData nameResolver) {
        BitwiseParameter payload = this.getData().toBitwiseParameter(nameResolver);
        if (payload == null) {
            return BitwiseParameter.NULL;
        }
        long wid = this.width.toBitwiseParameter(nameResolver).longValueExact();
        long ch = this.getChop().toBitwiseParameter(nameResolver).longValueExact();
        long value = FiniteBitField.toLong(payload.getValue(), wid, ch, this.isComplement(), this.reverse);
        long bitmap = IrCoreUtils.ones(wid) & payload.getBitmask() >> (int)ch;
        return new BitwiseParameter(value, bitmap);
    }

    public String toBinaryString(NameEngine nameEngine, boolean reverse) throws NameUnassignedException {
        String str = this.toBinaryString(nameEngine);
        return reverse ? this.reverse(str) : str;
    }

    private String reverse(String str) {
        StringBuilder s = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            s.append(str.charAt(str.length() - 1 - i));
        }
        return s.toString();
    }

    public String toBinaryString(NameEngine nameEngine) throws NameUnassignedException {
        String str = Long.toBinaryString(this.toLong(nameEngine));
        int wid = (int)this.getWidth(nameEngine);
        int len = str.length();
        if (len > wid) {
            return str.substring(len - wid);
        }
        for (int i = len; i < wid; ++i) {
            str = "0" + str;
        }
        return str;
    }

    @Override
    public long getWidth(NameEngine nameEngine) throws NameUnassignedException {
        long w = this.width.toLong(nameEngine);
        FiniteBitField.checkWidth(w);
        return w;
    }

    @Override
    public BitwiseParameter getWidth(RecognizeData recognizeData) {
        return this.width.toBitwiseParameter(recognizeData);
    }

    @Override
    public String toString(NameEngine nameEngine) {
        String widthString;
        String dataString;
        String chopString = "";
        if (this.hasChop()) {
            try {
                chopString = Long.toString(this.getChop().toLong(nameEngine));
            }
            catch (NameUnassignedException ex) {
                chopString = this.getChop().toIrpString(10);
            }
            chopString = ":" + chopString;
        }
        try {
            dataString = Long.toString(this.getData().toLong(nameEngine));
        }
        catch (NameUnassignedException ex) {
            dataString = this.getData().toIrpString(10);
        }
        try {
            widthString = Long.toString(this.width.toLong(nameEngine));
        }
        catch (NameUnassignedException ex) {
            widthString = this.width.toIrpString(10);
        }
        return (this.isComplement() ? "~" : "") + dataString + ":" + (this.reverse ? "-" : "") + widthString + chopString;
    }

    @Override
    public String toIrpString(int radix) {
        return (this.isComplement() ? "~" : "") + this.getData().toIrpString(radix) + ":" + (this.reverse ? "-" : "") + this.width.toIrpString(10) + (this.hasChop() ? ":" + this.getChop().toIrpString(10) : "");
    }

    @Override
    public void render(RenderData renderData, List<BitSpec> bitSpecs) throws NameUnassignedException {
        BitStream bitStream = new BitStream(this, renderData.getGeneralSpec(), renderData.getNameEngine());
        renderData.add(bitStream);
    }

    @Override
    public void evaluate(RenderData renderData, List<BitSpec> bitSpecStack) throws NameUnassignedException {
        BitStream bitStream = new BitStream(this, renderData.getGeneralSpec(), renderData.getNameEngine());
        renderData.add(bitStream);
    }

    @Override
    public BareIrStream extractPass(IrSignal.Pass pass, IrStream.PassExtractorState state) {
        return new BareIrStream(this);
    }

    @Override
    public Element toElement(Document document) {
        Element element = super.toElement(document);
        element.setAttribute("reverse", Boolean.toString(this.reverse));
        element.setAttribute("complement", Boolean.toString(this.isComplement()));
        Element dataElement = document.createElement("Data");
        dataElement.appendChild(this.getData().toElement(document));
        element.appendChild(dataElement);
        Element widthElement = document.createElement("Width");
        widthElement.appendChild(this.width.toElement(document));
        element.appendChild(widthElement);
        Element chopElement = document.createElement("Chop");
        chopElement.appendChild(this.getChop().toElement(document));
        element.appendChild(chopElement);
        return element;
    }

    @Override
    public Integer numberOfBits() {
        try {
            return (int)this.getWidth(NameEngine.EMPTY);
        }
        catch (NameUnassignedException ex) {
            return null;
        }
    }

    @Override
    public void decode(RecognizeData recognizeData, List<BitSpec> bitSpecStack, boolean isLast) throws SignalRecognitionException {
        logger.log(recognizeData.logRecordEnter(this));
        try {
            long payload = this.collectData(recognizeData, bitSpecStack);
            boolean success = this.isChecksum(recognizeData, payload);
            if (success) {
                logger.log(recognizeData.logRecordExit(this));
                return;
            }
            Equation equation = new Equation(this, payload, this.width.toLong(recognizeData.getNameEngine()), recognizeData);
            String origEquation = equation.toString();
            boolean solved = equation.solve();
            if (!solved) {
                throw new SignalRecognitionException("Could not solve equation: " + origEquation);
            }
            recognizeData.add(equation.getName(), equation.getValue());
            solved = equation.expandLhsSolve();
            if (solved) {
                recognizeData.add(equation.getName(), equation.getValue());
            }
        }
        catch (NameUnassignedException ex) {
            throw new SignalRecognitionException(ex);
        }
    }

    private boolean isChecksum(RecognizeData recognizeData, long payload) throws SignalRecognitionException {
        BitwiseParameter expected = this.toBitwiseParameter(recognizeData);
        return expected.check(payload, this.assignmentNeededBitmask(recognizeData));
    }

    private long collectData(RecognizeData recognizeData, List<BitSpec> bitSpecStack) throws SignalRecognitionException, NameUnassignedException {
        int rest;
        BitSpec bitSpec = bitSpecStack.get(bitSpecStack.size() - 1);
        int chunkSize = bitSpec.getChunkSize();
        long payload = 0L;
        int numWidth = (int)this.width.toBitwiseParameter(recognizeData).longValueExact();
        BitwiseParameter danglingData = recognizeData.getDanglingBitFieldData();
        if (!danglingData.isEmpty()) {
            payload = danglingData.getValue();
            numWidth -= Long.bitCount(danglingData.getBitmask());
            recognizeData.setDanglingBitFieldData();
        }
        int noChunks = (rest = numWidth % chunkSize) == 0 ? numWidth / chunkSize : numWidth / chunkSize + 1;
        for (int chunk = 0; chunk < noChunks; ++chunk) {
            int bareIrStreamNo;
            RecognizeData inData = null;
            for (bareIrStreamNo = 0; bareIrStreamNo < bitSpec.size(); ++bareIrStreamNo) {
                inData = recognizeData.clone();
                inData.setLevel(recognizeData.getLevel() + 1);
                ArrayList<BitSpec> poppedStack = new ArrayList<BitSpec>(bitSpecStack);
                poppedStack.remove(poppedStack.size() - 1);
                try {
                    bitSpec.get(bareIrStreamNo).decode(inData, poppedStack, false);
                    break;
                }
                catch (SignalRecognitionException signalRecognitionException) {
                    continue;
                }
            }
            assert (inData != null);
            if (bareIrStreamNo == bitSpec.size()) {
                throw new SignalRecognitionException("FiniteBitField did not parse");
            }
            if (recognizeData.getGeneralSpec().getBitDirection() == BitDirection.lsb) {
                bareIrStreamNo = IrCoreUtils.reverse(bareIrStreamNo, chunkSize);
            }
            recognizeData.setPosition(inData.getPosition());
            recognizeData.setHasConsumed(inData.getHasConsumed());
            payload = payload << (int)((long)chunkSize) | (long)bareIrStreamNo;
            recognizeData.getNameEngine().add(inData.getNameEngine());
        }
        if (rest != 0) {
            int bitsToStore = chunkSize - rest;
            long bitmask = IrCoreUtils.ones(bitsToStore);
            recognizeData.setDanglingBitFieldData(payload, bitmask);
            payload >>= bitsToStore;
        }
        if (recognizeData.getGeneralSpec().getBitDirection() == BitDirection.lsb) {
            payload = IrCoreUtils.reverse(payload, numWidth);
        }
        return payload;
    }

    @Override
    public BitwiseParameter invert(BitwiseParameter rhs, RecognizeData recognizeData) throws NameUnassignedException {
        long ch = this.getChop().toLong(recognizeData.getNameEngine());
        long wid = this.getWidth(recognizeData.getNameEngine());
        long payload = rhs.getValue();
        if (this.isComplement()) {
            payload ^= 0xFFFFFFFFFFFFFFFFL;
        }
        if (this.reverse) {
            payload = IrCoreUtils.reverse(payload, (int)wid);
        }
        long bitmask = (rhs.getBitmask() & IrCoreUtils.ones(wid)) << (int)ch;
        return new BitwiseParameter(payload <<= (int)ch, bitmask);
    }

    @Override
    public boolean interleavingOk(DurationType last, boolean gapFlashBitSpecs) {
        return true;
    }

    @Override
    public boolean interleavingOk(DurationType toCheck, DurationType last, boolean gapFlashBitSpecs) {
        return true;
    }

    @Override
    public DurationType endingDurationType(DurationType last, boolean gapFlashBitSpecs) {
        return gapFlashBitSpecs ? DurationType.flash : DurationType.gap;
    }

    @Override
    public DurationType startingDuratingType(DurationType last, boolean gapFlashBitSpecs) {
        return gapFlashBitSpecs ? DurationType.gap : DurationType.flash;
    }

    @Override
    public int weight() {
        try {
            return super.weight() + (int)this.width.toLong() / 8;
        }
        catch (NameUnassignedException ex) {
            logger.log(Level.WARNING, "Cannot compute weight of {0}", this.toString());
            return 1000;
        }
    }

    @Override
    public Set<String> assignmentVariables() {
        return new HashSet<String>(0);
    }

    @Override
    public Map<String, Object> propertiesMap(GeneralSpec generalSpec, NameEngine nameEngine) {
        Map<String, Object> map = super.propertiesMap(false, generalSpec, nameEngine);
        map.put("width", this.width.propertiesMap(true, generalSpec, nameEngine));
        map.put("reverse", this.reverse);
        return map;
    }

    @Override
    public Map<String, Object> propertiesMap(boolean eval, GeneralSpec generalSpec, NameEngine nameEngine) {
        Map<String, Object> map = super.propertiesMap(eval, generalSpec, nameEngine);
        map.put("width", this.width.propertiesMap(true, generalSpec, nameEngine));
        map.put("reverse", this.reverse);
        if (eval) {
            map.put("kind", "FiniteBitFieldExpression");
        }
        return map;
    }

    @Override
    public Integer numberOfDurations() {
        return null;
    }

    @Override
    public boolean nonConstantBitFieldLength() {
        try {
            this.width.toLong();
        }
        catch (NameUnassignedException ex) {
            return true;
        }
        return false;
    }

    @Override
    public Integer guessParameterLength(String name) {
        try {
            return this.getData().toString().equals(name) ? Integer.valueOf((int)this.width.toLong()) : null;
        }
        catch (NameUnassignedException ex) {
            return null;
        }
    }

    @Override
    public TreeSet<Double> allDurationsInMicros(GeneralSpec generalSpec, NameEngine nameEngine) {
        return new TreeSet<Double>();
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return super.constant(nameEngine) && this.width.constant(nameEngine);
    }

    private long assignmentNeededBitmask(RecognizeData recognizeData) {
        return this.getWidth(recognizeData).longValueExact() << (int)this.getChop(recognizeData).longValueExact();
    }

    @Override
    public void createParameterSpecs(ParameterSpecs parameterSpecs) throws InvalidNameException {
        if (!(this.getData() instanceof Name)) {
            throw new InvalidNameException(this.getData().toIrpString() + " cannot be used in createParameterSpecs");
        }
        String name = this.getData().toString();
        long max = (1L << (int)((long)this.numberOfBits().intValue())) - 1L;
        parameterSpecs.tweak(name, 0L, max);
    }
}

