/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.PrimaryItem;
import org.harctoolbox.irp.PrimaryItemExpression;
import org.harctoolbox.irp.RecognizeData;

final class FivePartExpression
extends Expression {
    private final Expression conditional;
    private final Expression trueExp;
    private final Expression falseExp;

    public static FivePartExpression newExpression(IrpParser.ExpressionContext ctx) {
        return FivePartExpression.newExpression(ctx, ctx.getChild(0), ctx.getChild(2), ctx.getChild(4));
    }

    public static FivePartExpression newExpression(ParseTree ctx, ParseTree cond, ParseTree trueExpression, ParseTree falseExpression) {
        return new FivePartExpression(ctx, (IrpParser.ExpressionContext)cond, (IrpParser.ExpressionContext)trueExpression, (IrpParser.ExpressionContext)falseExpression);
    }

    private FivePartExpression(ParseTree ctx, Expression cond, Expression trueExpression, Expression falseExpression) {
        super(ctx);
        this.conditional = cond;
        this.trueExp = trueExpression;
        this.falseExp = falseExpression;
    }

    private FivePartExpression(ParseTree ctx, IrpParser.ExpressionContext cond, IrpParser.ExpressionContext trueExpression, IrpParser.ExpressionContext falseExpression) {
        this(ctx, Expression.newExpression(cond), Expression.newExpression(trueExpression), Expression.newExpression(falseExpression));
    }

    private FivePartExpression(ParseTree parseTree, PrimaryItem cond, PrimaryItem trueExpression, PrimaryItem falseExpression) {
        this(parseTree, PrimaryItemExpression.newExpression(cond), PrimaryItemExpression.newExpression(trueExpression), PrimaryItemExpression.newExpression(falseExpression));
    }

    @Override
    public PrimaryItem substituteConstantVariables(Map<String, Long> constantVariables) {
        return new FivePartExpression(this.getParseTree(), this.conditional.substituteConstantVariables(constantVariables), this.trueExp.substituteConstantVariables(constantVariables), this.falseExp.substituteConstantVariables(constantVariables));
    }

    @Override
    public String toIrpString(int radix) {
        return "(" + this.conditional.toIrpString(radix) + "?" + this.trueExp.toIrpString(radix) + ":" + this.falseExp.toIrpString(radix) + ")";
    }

    @Override
    public Map<String, Object> propertiesMap(boolean eval, GeneralSpec generalSpec, NameEngine nameEngine) {
        Map<String, Object> map = super.propertiesMap(4);
        map.put("kind", "ConditionalOp");
        map.put("arg1", this.conditional.propertiesMap(true, generalSpec, nameEngine));
        map.put("arg2", this.trueExp.propertiesMap(true, generalSpec, nameEngine));
        map.put("arg3", this.falseExp.propertiesMap(true, generalSpec, nameEngine));
        return map;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.conditional);
        hash = 41 * hash + Objects.hashCode(this.trueExp);
        hash = 41 * hash + Objects.hashCode(this.falseExp);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FivePartExpression other = (FivePartExpression)obj;
        if (!Objects.equals(this.conditional, other.conditional)) {
            return false;
        }
        if (!Objects.equals(this.trueExp, other.trueExp)) {
            return false;
        }
        return Objects.equals(this.falseExp, other.falseExp);
    }

    @Override
    public int weight() {
        return 2 + this.conditional.weight() + this.trueExp.weight() + this.falseExp.weight();
    }

    @Override
    public long toLong(NameEngine nameEngine) throws NameUnassignedException {
        long ctrl = this.conditional.toLong(nameEngine);
        return ctrl != 0L ? this.trueExp.toLong(nameEngine) : this.falseExp.toLong(nameEngine);
    }

    @Override
    public BitwiseParameter toBitwiseParameter(RecognizeData recognizeData) {
        BitwiseParameter ctrl = this.conditional.toBitwiseParameter(recognizeData);
        return ctrl.isTrue() ? this.trueExp.toBitwiseParameter(recognizeData) : this.falseExp.toBitwiseParameter(recognizeData);
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return this.trueExp.constant(nameEngine) && this.falseExp.constant(nameEngine);
    }

    @Override
    public BitwiseParameter invert(BitwiseParameter rhs, RecognizeData recognizeData) throws NameUnassignedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

