/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irp;

import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.irp.Floatable;
import org.harctoolbox.irp.GeneralSpec;
import org.harctoolbox.irp.IrpObject;
import org.harctoolbox.irp.IrpParser;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.ParserDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class FloatNumber
extends IrpObject
implements Floatable {
    private static final int WEIGHT = 1;
    private final double data;

    public static double parse(String str) {
        FloatNumber floatNumber = new FloatNumber(str);
        return floatNumber.toFloat();
    }

    public static double parse(IrpParser.Float_numberContext ctx) {
        FloatNumber floatNumber = new FloatNumber(ctx);
        return floatNumber.toFloat();
    }

    public FloatNumber(double x) {
        super(null);
        this.data = x;
    }

    public FloatNumber(IrpParser.Float_numberContext ctx) {
        super(ctx);
        this.data = Double.parseDouble(ctx.getText());
    }

    public FloatNumber(String str) {
        this(new ParserDriver(str));
    }

    public FloatNumber(ParserDriver parserDriver) {
        this(parserDriver.getParser().float_number());
    }

    @Override
    public double toFloat(GeneralSpec generalSpec, NameEngine nameEngine) {
        return this.toFloat();
    }

    public double toFloat() {
        return this.data;
    }

    @Override
    public String toIrpString(int radix) {
        return Double.toString(this.data);
    }

    @Override
    public Element toElement(Document document) {
        Element element = super.toElement(document);
        element.setTextContent(this.toString());
        return element;
    }

    @Override
    public int weight() {
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FloatNumber)) {
            return false;
        }
        FloatNumber other = (FloatNumber)obj;
        return IrCoreUtils.approximatelyEquals(this.data, other.data);
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + (int)(Double.doubleToLongBits(this.data) ^ Double.doubleToLongBits(this.data) >>> 32);
        return hash;
    }

    @Override
    public boolean constant(NameEngine nameEngine) {
        return true;
    }
}

